/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.Dependency;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.Project;
import org.kuali.common.util.ProjectContext;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.ReflectionUtils;
import org.kuali.common.util.RepositoryUtils;
import org.kuali.common.util.Str;
import org.kuali.common.util.property.Constants;
import org.kuali.common.util.property.ProjectProperties;
import org.kuali.common.util.property.PropertiesContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.PropertyPlaceholderHelper;

@Deprecated
public class ProjectUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProjectUtils.class);
    private static final PropertyPlaceholderHelper PPH = Constants.DEFAULT_PROPERTY_PLACEHOLDER_HELPER;
    private static final String CLASSPATH = "classpath:";
    @Deprecated
    public static final String KUALI_COMMON_GROUP_ID = "org.kuali.common";
    @Deprecated
    public static final String KUALI_UTIL_ARTIFACT_ID = "kuali-util";
    private static final Map<String, Properties> PROJECT_PROPERTIES_CACHE = new HashMap<String, Properties>();

    public static List<Project> loadProjects(List<String> projectIds) {
        ArrayList<Project> projects = new ArrayList<Project>();
        for (String projectId : projectIds) {
            Project project = ProjectUtils.loadProject(projectId);
            projects.add(project);
        }
        return projects;
    }

    public static String getCommonClassPathPrefix(String artifactId) {
        return ProjectUtils.getClassPathPrefix(KUALI_COMMON_GROUP_ID, artifactId);
    }

    public static String getClassPathPrefix(String groupId, String artifactId) {
        Project project = ProjectUtils.loadProject(groupId, artifactId);
        return CLASSPATH + ProjectUtils.getResourcePath(project);
    }

    @Deprecated
    public static String getClassPathPrefixFromGAV(String projectId) {
        Project project = ProjectUtils.getProject(projectId);
        return ProjectUtils.getClassPathPrefix(project);
    }

    public static String getClassPathPrefixFromProjectId(String projectId) {
        Project project = ProjectUtils.getProject(projectId);
        return ProjectUtils.getClassPathPrefix(project);
    }

    public static String getClassPathPrefix(Project project) {
        return ProjectUtils.getClassPathPrefix(project.getGroupId(), project.getArtifactId());
    }

    public static File getResourceDirectory(File directory, Project project) {
        String resourcePath = ProjectUtils.getResourcePath(project);
        File file = new File(directory, resourcePath);
        return new File(LocationUtils.getCanonicalPath(file));
    }

    public static File getResourceFile(File directory, Project project, String filename) {
        File dir = ProjectUtils.getResourceDirectory(directory, project);
        return new File(dir, filename);
    }

    public static String getResourcePath(Project project) {
        Properties properties = project.getProperties();
        String groupIdPath = properties.getProperty("project.groupId.path");
        Assert.hasText((String)groupIdPath, (String)"groupIdPath has no text");
        String artifactId = project.getArtifactId();
        return groupIdPath + "/" + artifactId;
    }

    @Deprecated
    public static ProjectProperties getProjectProperties(ProjectContext context) {
        Project project = ProjectUtils.loadProject(context);
        PropertiesContext propertiesContext = new PropertiesContext(project.getProperties());
        propertiesContext.setEncoding(project.getEncoding());
        propertiesContext.setLocations(context.getPropertyLocations());
        return new ProjectProperties(project, propertiesContext);
    }

    @Deprecated
    public static Project loadProject(ProjectContext context) {
        return ProjectUtils.loadProject(ProjectUtils.getGav(context));
    }

    @Deprecated
    public static String getGav(ProjectContext context) {
        return ProjectUtils.getGav(context.getGroupId(), context.getArtifactId());
    }

    @Deprecated
    public static String getGav(Project project) {
        return ProjectUtils.getGav(project.getGroupId(), project.getArtifactId());
    }

    @Deprecated
    public static String getGav(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    public static String getProjectId(Project project) {
        return ProjectUtils.getProjectId(project.getGroupId(), project.getArtifactId());
    }

    public static String getProjectId(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    public static Project loadProject(String groupId, String artifactId) {
        String projectId = ProjectUtils.getProjectId(groupId, artifactId);
        return ProjectUtils.loadProject(projectId);
    }

    public static Project loadProject(String projectId) {
        Project project = ProjectUtils.getProject(projectId);
        Properties properties = ProjectUtils.loadProperties(project);
        Project loadedProject = ProjectUtils.getProject(properties);
        return loadedProject;
    }

    public static synchronized void clearCache() {
        PROJECT_PROPERTIES_CACHE.clear();
    }

    public static Project getProject(String gav) {
        logger.debug("Processing [{}]", (Object)gav);
        String[] tokens = StringUtils.split((String)gav, (String)":");
        Project project = new Project();
        if (tokens.length > 0) {
            project.setGroupId(RepositoryUtils.toNull(tokens[0]));
        }
        if (tokens.length > 1) {
            project.setArtifactId(RepositoryUtils.toNull(tokens[1]));
        }
        if (tokens.length > 2) {
            project.setPackaging(RepositoryUtils.toNull(tokens[2]));
        }
        if (tokens.length > 3) {
            project.setVersion(RepositoryUtils.toNull(tokens[3]));
        }
        if (tokens.length > 4) {
            project.setClassifier(RepositoryUtils.toNull(tokens[4]));
        }
        return project;
    }

    public static List<Dependency> getDependencies(String csv) {
        List<String> tokens = CollectionUtils.getTrimmedListFromCSV(csv);
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (String token : tokens) {
            Dependency dependency = RepositoryUtils.parseDependency(token);
            dependencies.add(dependency);
        }
        return dependencies;
    }

    public static Project getProject(Properties properties) {
        List<String> skipKeys = Arrays.asList("project.dependencies");
        String startsWith = "project.";
        List<String> keys = PropertyUtils.getStartsWithKeys(properties, startsWith);
        Project project = new Project();
        project.setProperties(properties);
        Map<String, Object> description = ReflectionUtils.describe(project);
        Set<String> beanProperties = description.keySet();
        for (String key : keys) {
            if (skipKeys.contains(key)) continue;
            String value = properties.getProperty(key);
            String beanProperty = ProjectUtils.getBeanProperty(key, startsWith);
            if (!beanProperties.contains(beanProperty)) continue;
            ReflectionUtils.copyProperty(project, beanProperty, value);
        }
        String csv = RepositoryUtils.toNull(properties.getProperty("project.dependencies"));
        List<Dependency> dependencies = ProjectUtils.getDependencies(csv);
        project.setDependencies(dependencies);
        return project;
    }

    protected static String getBeanProperty(String key, String startsWith) {
        String s = StringUtils.substring((String)key, (int)startsWith.length());
        String[] tokens = StringUtils.split((String)s, (String)".");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i == 0) {
                sb.append(token);
                continue;
            }
            sb.append(StringUtils.capitalize((String)token));
        }
        return sb.toString();
    }

    public static Properties loadProperties(String gav) {
        return ProjectUtils.loadProperties(ProjectUtils.getProject(gav));
    }

    public static synchronized Properties loadProperties(Project project) {
        String projectId = ProjectUtils.getProjectId(project.getGroupId(), project.getArtifactId());
        Properties properties = PROJECT_PROPERTIES_CACHE.get(projectId);
        if (properties == null) {
            properties = ProjectUtils.loadAndCache(project, projectId);
        }
        return properties;
    }

    protected static Properties loadAndCache(Project project, String projectId) {
        String location = ProjectUtils.getPropertiesFileLocation(project);
        Assert.exists(location);
        Properties properties = PropertyUtils.load(location);
        PROJECT_PROPERTIES_CACHE.put(projectId, properties);
        return properties;
    }

    public static String getPropertiesFileLocation(Project project) {
        Assert.hasText((String)project.getGroupId(), (String)"groupId has no text");
        Assert.hasText((String)project.getArtifactId(), (String)"artifactId has no text");
        Properties properties = new Properties();
        properties.setProperty("project.groupId.path", Str.getPath(project.getGroupId()));
        properties.setProperty("project.artifactId", project.getArtifactId());
        return PPH.replacePlaceholders("classpath:META-INF/${project.groupId.path}/${project.artifactId}/project.properties", properties);
    }
}

