/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.util.DirectoryScanner;
import org.kuali.common.util.CollectionUtils;

public class SimpleScanner
extends DirectoryScanner {
    private static final String FS = File.separator;

    public SimpleScanner() {
        this((File)null, (String)null, (String)null);
    }

    public SimpleScanner(File baseDir, String include, String exclude) {
        this(baseDir, CollectionUtils.toEmptyList(include), CollectionUtils.toEmptyList(exclude));
    }

    public SimpleScanner(File baseDir, List<String> includes, List<String> excludes) {
        if (baseDir != null) {
            this.setBasedir(baseDir);
        }
        if (!CollectionUtils.isEmpty(includes)) {
            this.setIncludes(CollectionUtils.toStringArray(includes));
        }
        if (!CollectionUtils.isEmpty(excludes)) {
            this.setExcludes(CollectionUtils.toStringArray(excludes));
        }
    }

    public List<File> getFiles() {
        this.scan();
        String[] includedFiles = this.getIncludedFiles();
        ArrayList<File> files = new ArrayList<File>();
        for (String includedFile : includedFiles) {
            String filename = this.getBasedir().getAbsolutePath() + FS + includedFile;
            File file = new File(filename);
            files.add(file);
        }
        return files;
    }

    public List<String> getDirectories() {
        this.scan();
        String[] includedDirectories = this.getIncludedDirectories();
        ArrayList<String> directories = new ArrayList<String>();
        for (String includedDirectory : includedDirectories) {
            directories.add(includedDirectory);
        }
        return directories;
    }
}

