/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.Mode;
import org.kuali.common.util.ModeUtils;
import org.kuali.common.util.UnixCmds;
import org.kuali.common.util.log.LoggerLevel;
import org.kuali.common.util.stream.LoggingStreamConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixUtils {
    private static final Logger logger = LoggerFactory.getLogger(UnixUtils.class);
    private static final String SCP = "scp";
    private static final String SSH = "ssh";
    private static final String RSYNC = "rsync";
    private static final String FORWARD_SLASH = "/";
    public static final int SUCCESS = 0;
    private static final UnixCmds cmds = new UnixCmds();

    public static final int rsyncdirs(File source, File destination) {
        String sourcePath = UnixUtils.validateRsyncSourceDir(source);
        String destinationPath = UnixUtils.validateRsyncDestinationDir(destination);
        boolean different = !source.equals(destination);
        Assert.isTrue((boolean)different);
        return UnixUtils.rsyncdirs(null, sourcePath, destinationPath);
    }

    public static final int rsyncdirs(File source, String destination) {
        String sourcePath = UnixUtils.validateRsyncSourceDir(source);
        return UnixUtils.rsyncdirs(null, sourcePath, destination);
    }

    public static final int rsyncdirs(String source, File destination) {
        String destinationPath = UnixUtils.validateRsyncDestinationDir(destination);
        return UnixUtils.rsyncdirs(null, source, destinationPath);
    }

    public static final int rsyncdirs(List<String> options, File source, File destination) {
        String sourcePath = UnixUtils.validateRsyncSourceDir(source);
        String destinationPath = UnixUtils.validateRsyncDestinationDir(destination);
        return UnixUtils.rsyncdirs(options, sourcePath, destinationPath);
    }

    public static final int rsync(List<String> options, File source, String destination) {
        String sourcePath = UnixUtils.validateRsyncSourceDir(source);
        return UnixUtils.rsyncdirs(options, sourcePath, destination);
    }

    public static final int rsyncdirs(List<String> options, String source, File destination) {
        String destinationPath = UnixUtils.validateRsyncDestinationDir(destination);
        return UnixUtils.rsyncdirs(options, source, destinationPath);
    }

    public static final int rsyncdirs(List<String> options, String source, String destination) {
        List<String> rsyncDirOptions = UnixUtils.getRsyncDirOptions(options);
        String trailingSlashSource = StringUtils.endsWith((CharSequence)source, (CharSequence)FORWARD_SLASH) ? source : source + FORWARD_SLASH;
        return UnixUtils.rsync(rsyncDirOptions, trailingSlashSource, destination);
    }

    public static final int rsyncdirs(String source, String destination) {
        return UnixUtils.rsyncdirs(null, source, destination);
    }

    public static final int rsync(String source, String destination) {
        return UnixUtils.rsync(null, source, destination);
    }

    public static final int rsync(List<String> options, String source, String destination) {
        Assert.notNull((Object)source);
        Assert.notNull((Object)destination);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.addAll(CollectionUtils.toEmptyList(options));
        arguments.add(source);
        arguments.add(destination);
        Commandline cl = new Commandline();
        cl.setExecutable(RSYNC);
        cl.addArguments(CollectionUtils.toStringArray(arguments));
        return UnixUtils.execute(cl);
    }

    public static final int sshchown(List<String> args, String user, String hostname, List<String> options, String owner, String group, String file) {
        Assert.notNull((Object)owner);
        Assert.notNull((Object)group);
        Assert.notNull((Object)file);
        String command = cmds.chown(options, owner, group, file);
        return UnixUtils.ssh(args, user, hostname, command);
    }

    public static final int sshchownr(String hostname, String owner, String group, String file) {
        return UnixUtils.sshchownr(null, null, hostname, owner, group, file);
    }

    public static final int sshchownr(String user, String hostname, String owner, String group, String file) {
        return UnixUtils.sshchownr(null, user, hostname, owner, group, file);
    }

    public static final int sshchownr(List<String> args, String hostname, String owner, String group, String file) {
        return UnixUtils.sshchownr(args, null, hostname, owner, group, file);
    }

    public static final int sshchownr(List<String> args, String user, String hostname, String owner, String group, String file) {
        return UnixUtils.sshchown(args, user, hostname, Arrays.asList("-R"), owner, group, file);
    }

    public static final int sshchown(List<String> args, String hostname, String owner, String group, String file) {
        return UnixUtils.sshchown(args, null, hostname, null, owner, group, file);
    }

    public static final int sshchown(List<String> args, String user, String hostname, String owner, String group, String file) {
        return UnixUtils.sshchown(args, user, hostname, null, owner, group, file);
    }

    public static final int sshchown(String user, String hostname, String owner, String group, String file) {
        return UnixUtils.sshchown(null, user, hostname, null, owner, group, file);
    }

    public static final int sshchown(String hostname, String owner, String group, String file) {
        return UnixUtils.sshchown(null, null, hostname, owner, group, file);
    }

    public static final int sshrm(String hostname, String file) {
        return UnixUtils.sshrm(null, null, hostname, file);
    }

    public static final int sshrm(String user, String hostname, String file) {
        return UnixUtils.sshrm(null, user, hostname, file);
    }

    public static final int sshrm(List<String> args, String hostname, String file) {
        return UnixUtils.sshrm(args, null, hostname, file);
    }

    public static final int sshrm(List<String> args, String user, String hostname, String file) {
        Assert.notNull((Object)file);
        return UnixUtils.sshrm(args, user, hostname, Collections.singletonList(file));
    }

    public static final int sshrm(String hostname, List<String> paths) {
        return UnixUtils.sshrm(null, null, hostname, paths);
    }

    public static final int sshrm(String user, String hostname, List<String> paths) {
        return UnixUtils.sshrm(null, user, hostname, paths);
    }

    public static final int sshrm(List<String> args, String hostname, List<String> paths) {
        return UnixUtils.sshrm(args, null, hostname, paths);
    }

    public static final int sshrm(List<String> args, String user, String hostname, List<String> paths) {
        return UnixUtils.sshrm(args, user, hostname, Arrays.asList("-r", "-f"), paths);
    }

    public static final int sshrm(List<String> args, String user, String hostname, List<String> options, List<String> paths) {
        Assert.notEmpty(paths);
        String command = cmds.rm(options, paths);
        return UnixUtils.ssh(args, user, hostname, command);
    }

    public static final int sshchmod(List<String> args, String user, String hostname, String mode, String path) {
        Assert.hasLength((String)mode);
        Assert.notNull((Object)path);
        return UnixUtils.ssh(args, user, hostname, cmds.chmod(mode, path));
    }

    public static final int sshchmod(String user, String hostname, String mode, String file) {
        return UnixUtils.sshchmod(null, user, hostname, mode, file);
    }

    public static final int sshmkdir(String user, String hostname, String path) {
        return UnixUtils.sshmkdir(null, user, hostname, path);
    }

    public static final int sshmkdir(List<String> args, String user, String hostname, String path) {
        Assert.notBlank(path);
        return UnixUtils.ssh(args, user, hostname, cmds.mkdirp(path));
    }

    public static final int sshmkdir(String hostname, String path) {
        return UnixUtils.sshmkdir(null, null, hostname, path);
    }

    public static final int sshmkdir(List<String> args, String hostname, String path) {
        return UnixUtils.sshmkdir(args, null, hostname, path);
    }

    public static final int sshsu(String hostname, String login, String command) {
        return UnixUtils.sshsu(null, null, hostname, login, command);
    }

    public static final int sshsu(List<String> args, String hostname, String login, String command) {
        return UnixUtils.sshsu(args, null, hostname, login, command);
    }

    public static final int sshsu(String user, String hostname, String login, String command) {
        return UnixUtils.sshsu(null, user, hostname, login, command);
    }

    public static final int sshsu(List<String> args, String user, String hostname, String login, String command) {
        Assert.notNull((Object)login);
        Assert.notNull((Object)command);
        return UnixUtils.ssh(user, hostname, cmds.su(login, command));
    }

    public static final int ssh(String hostname, String command) {
        return UnixUtils.ssh(null, null, hostname, command);
    }

    public static final int ssh(String user, String hostname, String command) {
        return UnixUtils.ssh(null, user, hostname, command);
    }

    public static final int ssh(List<String> args, String hostname, String command) {
        return UnixUtils.ssh(args, null, hostname, command);
    }

    public static final int ssh(List<String> args, String user, String hostname, String command) {
        Assert.notNull((Object)hostname);
        Assert.notNull((Object)command);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.addAll(CollectionUtils.toEmptyList(args));
        if (!StringUtils.isBlank((CharSequence)user)) {
            arguments.add(user + "@" + hostname);
        } else {
            arguments.add(hostname);
        }
        arguments.add(command);
        Commandline cl = new Commandline();
        cl.setExecutable(SSH);
        cl.addArguments(CollectionUtils.toStringArray(arguments));
        return UnixUtils.execute(cl);
    }

    public static final int scp(String source, String destination) {
        return UnixUtils.scp(null, source, destination);
    }

    public static final int scp(List<String> args, String source, String destination) {
        Assert.notNull((Object)source);
        Assert.notNull((Object)destination);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.addAll(CollectionUtils.toEmptyList(args));
        arguments.add(source);
        arguments.add(destination);
        Commandline cl = new Commandline();
        cl.setExecutable(SCP);
        cl.addArguments(CollectionUtils.toStringArray(arguments));
        return UnixUtils.execute(cl);
    }

    public static final int scp(List<String> args, File source, String destination) {
        Assert.notNull((Object)source);
        String sourcePath = LocationUtils.getCanonicalPath(source);
        if (!source.exists()) {
            throw new IllegalArgumentException(sourcePath + " does not exist");
        }
        return UnixUtils.scp(args, sourcePath, destination);
    }

    public static final int scp(List<String> args, String source, File destination) {
        try {
            FileUtils.touch((File)destination);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO error", e);
        }
        String localPath = LocationUtils.getCanonicalPath(destination);
        return UnixUtils.scp(args, source, localPath);
    }

    public static final int scp(File source, String destination) {
        return UnixUtils.scp(null, source, destination);
    }

    public static final int scp(String source, File destination) {
        return UnixUtils.scp(null, source, destination);
    }

    public static final void validate(int exitValue, String message, Mode mode) {
        if (exitValue != 0) {
            ModeUtils.validate(mode, message + " Exit value=[" + exitValue + "]");
        }
    }

    public static final void validate(int exitValue, String message) {
        UnixUtils.validate(exitValue, message, Mode.ERROR);
    }

    public static final int execute(Commandline cl) {
        try {
            LoggingStreamConsumer stdout = new LoggingStreamConsumer(logger, LoggerLevel.INFO);
            LoggingStreamConsumer stderr = new LoggingStreamConsumer(logger, LoggerLevel.WARN);
            logger.info(cl.toString());
            return CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
        }
        catch (CommandLineException e) {
            throw new IllegalStateException(e);
        }
    }

    public static final String getLocation(String user, String hostname, String filename) {
        Assert.notNull((Object)user);
        Assert.notNull((Object)filename);
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isBlank((CharSequence)user)) {
            sb.append(user + "@");
        }
        sb.append(hostname);
        sb.append(":");
        sb.append(filename);
        return sb.toString();
    }

    protected static final String validateRsyncSourceDir(File dir) {
        String path = LocationUtils.getCanonicalPath(dir);
        if (!dir.exists()) {
            throw new IllegalArgumentException(path + " does not exist");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(path + " is not a directory");
        }
        if (!StringUtils.endsWith((CharSequence)path, (CharSequence)FORWARD_SLASH)) {
            return path + FORWARD_SLASH;
        }
        return path;
    }

    protected static final String validateRsyncDestinationDir(File dir) {
        try {
            FileUtils.forceMkdir((File)dir);
            return dir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unexpected IO error", e);
        }
    }

    protected static final List<String> getRsyncDirOptions(List<String> options) {
        ArrayList<String> rsyncDirOptions = new ArrayList<String>();
        rsyncDirOptions.add("--recursive");
        rsyncDirOptions.add("--archive");
        rsyncDirOptions.add("--delete");
        for (String option : CollectionUtils.toEmptyList(options)) {
            if (rsyncDirOptions.contains(option)) continue;
            rsyncDirOptions.add(option);
        }
        return rsyncDirOptions;
    }
}

