/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.base;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public class Precondition {
    private static final String NOT_BLANK_MSG = "'%s' cannot be blank";
    private static final String MIN_MSG = "%s not allowed. '%s' must be greater than or equal to %s";

    public static String checkNotBlank(String arg, String argName) {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)arg) ? 1 : 0) != 0, (String)NOT_BLANK_MSG, (Object[])new Object[]{argName});
        return arg;
    }

    public static Optional<String> checkNotBlank(Optional<String> arg, String argName) {
        if (arg.isPresent()) {
            Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)((CharSequence)arg.get())) ? 1 : 0) != 0, (Object)argName);
        }
        return arg;
    }

    public static Optional<Integer> checkMin(Optional<Integer> arg, int min, String argName) {
        if (arg.isPresent()) {
            Precondition.checkMin((Integer)arg.get(), min, argName);
        }
        return arg;
    }

    public static Optional<Long> checkMin(Optional<Long> arg, long min, String argName) {
        if (arg.isPresent()) {
            Precondition.checkMin((Long)arg.get(), min, argName);
        }
        return arg;
    }

    public static int checkMin(int arg, int min, String argName) {
        Preconditions.checkArgument((arg >= min ? 1 : 0) != 0, (String)MIN_MSG, (Object[])new Object[]{arg, min, argName});
        return arg;
    }

    public static long checkMin(long arg, long min, String argName) {
        Preconditions.checkArgument((arg >= min ? 1 : 0) != 0, (String)MIN_MSG, (Object[])new Object[]{arg, min, argName});
        return arg;
    }
}

