/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.base;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Map;

public final class Replacer {
    private final ImmutableBiMap<String, String> tokens;

    public String replace(String string) {
        String s = string;
        for (Map.Entry pair : this.tokens.entrySet()) {
            s = s.replace((CharSequence)pair.getKey(), (CharSequence)pair.getValue());
        }
        return s;
    }

    public String restore(String string) {
        String s = string;
        for (Map.Entry pair : this.tokens.entrySet()) {
            s = s.replace((CharSequence)pair.getValue(), (CharSequence)pair.getKey());
        }
        return s;
    }

    private Replacer(Builder builder) {
        this.tokens = ImmutableBiMap.copyOf((Map)builder.tokens);
    }

    public static Replacer create(String oldToken, String newToken) {
        return Replacer.builder().add(oldToken, newToken).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public BiMap<String, String> getTokens() {
        return this.tokens;
    }

    public static class Builder {
        private BiMap<String, String> tokens = HashBiMap.create();

        public Builder add(String oldToken, String newToken) {
            this.tokens.put((Object)oldToken, (Object)newToken);
            return this;
        }

        public Builder tokens(BiMap<String, String> tokens) {
            this.tokens = tokens;
            return this;
        }

        public Replacer build() {
            Replacer instance = new Replacer(this);
            Builder.validate(instance);
            return instance;
        }

        private static void validate(Replacer instance) {
            Preconditions.checkNotNull((Object)instance.tokens);
        }

        public BiMap<String, String> getTokens() {
            return this.tokens;
        }

        public void setTokens(BiMap<String, String> tokens) {
            this.tokens = tokens;
        }
    }
}

