/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.channel.model;

import org.kuali.common.util.Assert;

public final class CommandResult {
    private final byte[] command;
    private final int exitValue;
    private final long start;
    private final long stop = System.currentTimeMillis();
    private final long elapsed;

    public CommandResult(byte[] command, int exitValue, long start) {
        Assert.isTrue((this.stop >= start ? 1 : 0) != 0);
        Assert.noNulls(new Object[]{command});
        Assert.noNegatives(start);
        this.command = command;
        this.exitValue = exitValue;
        this.start = start;
        this.elapsed = this.stop - start;
    }

    public byte[] getCommand() {
        return this.command;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public long getStart() {
        return this.start;
    }

    public long getStop() {
        return this.stop;
    }

    public long getElapsed() {
        return this.elapsed;
    }
}

