/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.config.DefaultProjectConfig;
import org.kuali.common.util.config.ProjectConfig;
import org.springframework.util.Assert;

@Deprecated
public class ConfigUtils {
    public static final String DELIMITER = ":";

    public static List<ProjectConfig> getProjectConfigs(List<String> configIds) {
        ArrayList<ProjectConfig> requests = new ArrayList<ProjectConfig>();
        for (String configId : configIds) {
            ProjectConfig request = ConfigUtils.getProjectConfig(configId);
            requests.add(request);
        }
        return requests;
    }

    public static String getConfigId(ProjectConfig config) {
        return ConfigUtils.getConfigId(config.getGroupId(), config.getArtifactId(), config.getContextId());
    }

    public static String getConfigId(String groupId, String artifactId, String contextId) {
        Assert.hasText((String)groupId, (String)"groupId is blank");
        Assert.hasText((String)artifactId, (String)"artifactId is blank");
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.trimToEmpty((String)groupId));
        sb.append(DELIMITER);
        sb.append(StringUtils.trimToEmpty((String)artifactId));
        if (!StringUtils.isBlank((CharSequence)contextId)) {
            sb.append(DELIMITER);
            sb.append(StringUtils.trimToEmpty((String)contextId));
        }
        return sb.toString();
    }

    public static ProjectConfig getProjectConfig(String configId) {
        String[] tokens = StringUtils.split((String)configId, (String)DELIMITER);
        Assert.isTrue((tokens.length > 1 ? 1 : 0) != 0, (String)"2 tokens are required");
        String groupId = tokens[0];
        String artifactId = tokens[1];
        String contextId = ConfigUtils.getContextId(tokens);
        DefaultProjectConfig config = new DefaultProjectConfig();
        config.setGroupId(groupId);
        config.setArtifactId(artifactId);
        config.setContextId(contextId);
        return config;
    }

    protected static String getContextId(String[] tokens) {
        if (tokens.length < 3) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 2; i < tokens.length; ++i) {
            if (i != 2) {
                sb.append(DELIMITER);
            }
            sb.append(tokens[i]);
        }
        return sb.toString();
    }
}

