/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.enc;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jasypt.util.text.TextEncryptor;
import org.kuali.common.util.Assert;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.Str;
import org.kuali.common.util.enc.EncStrength;
import org.kuali.common.util.enc.EncUtils;
import org.kuali.common.util.spring.SpringUtils;
import org.kuali.common.util.spring.env.BasicEnvironmentService;
import org.kuali.common.util.spring.env.EnvUtils;
import org.kuali.common.util.spring.env.EnvironmentService;

public final class EncContext {
    private final Optional<TextEncryptor> textEncryptor;
    private final EncStrength strength;

    private EncContext(Builder builder) {
        this.strength = builder.strength;
        this.textEncryptor = builder.textEncryptor;
    }

    public Optional<TextEncryptor> getTextEncryptor() {
        return this.textEncryptor;
    }

    public EncStrength getStrength() {
        return this.strength;
    }

    public static Builder builder(String password) {
        return new Builder(password);
    }

    public static Builder builder(EnvironmentService env) {
        return new Builder(env);
    }

    public static class Builder {
        private final Optional<String> password;
        private final Optional<EnvironmentService> env;
        private Optional<TextEncryptor> textEncryptor = Optional.absent();
        private EncStrength strength = EncStrength.BASIC;
        private boolean required = false;
        private boolean removeSystemProperties = false;
        private static final List<String> PASSWORD_KEYS = ImmutableList.of((Object)"enc.password", (Object)"properties.enc.password");
        private static final List<String> STRENGTH_KEYS = ImmutableList.of((Object)"enc.strength", (Object)"properties.enc.strength");
        private static final List<String> PASSWORD_REQUIRED_KEYS = ImmutableList.of((Object)"enc.password.required", (Object)"properties.decrypt");
        private static final String PASSWORD_REMOVE_KEY = "enc.password.removeSystemProperty";

        public Builder(String password) {
            this(EnvUtils.ABSENT, (Optional<String>)Optional.of((Object)password));
        }

        public Builder(EnvironmentService env, String password) {
            this((Optional<EnvironmentService>)Optional.of((Object)env), (Optional<String>)Optional.of((Object)password));
        }

        public Builder() {
            this(new BasicEnvironmentService());
        }

        public Builder(EnvironmentService env) {
            this((Optional<EnvironmentService>)Optional.of((Object)env), (Optional<String>)Optional.absent());
        }

        private Builder(Optional<EnvironmentService> env, Optional<String> password) {
            this.password = env.isPresent() ? SpringUtils.getString(env, PASSWORD_KEYS, password) : password;
            this.env = env;
        }

        public Builder removeSystemProperties(boolean removeSystemProperties) {
            this.removeSystemProperties = removeSystemProperties;
            return this;
        }

        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        public Builder strength(EncStrength strength) {
            this.strength = strength;
            return this;
        }

        private void override() {
            if (this.env.isPresent()) {
                this.strength(SpringUtils.getProperty(this.env, STRENGTH_KEYS, EncStrength.class, this.strength));
                this.required(SpringUtils.getProperty(this.env, PASSWORD_REQUIRED_KEYS, Boolean.class, this.required));
                this.removeSystemProperties(((EnvironmentService)this.env.get()).getBoolean(PASSWORD_REMOVE_KEY, this.removeSystemProperties));
            }
        }

        private void validate(EncContext ctx, boolean required, Optional<String> password) {
            Assert.notNull(ctx.getTextEncryptor(), (String)"'textEncryptor' cannot be null");
            Assert.notNull((Object)((Object)ctx.getStrength()), (String)"'strength' cannot be null");
            if (required) {
                Assert.isTrue((boolean)ctx.getTextEncryptor().isPresent());
            }
            if (password.isPresent()) {
                Assert.noBlanks((String)password.get());
                Assert.notEncrypted((String)password.get());
                Assert.notConcealed((String)password.get());
            }
        }

        private void finish() {
            this.override();
            if (this.password.isPresent()) {
                String revealed = Str.reveal((String)this.password.get());
                TextEncryptor enc = EncUtils.getTextEncryptor(revealed, this.strength);
                this.textEncryptor = Optional.of((Object)enc);
            }
        }

        public EncContext build() {
            this.finish();
            boolean required = this.required;
            boolean removeSystemProperties = this.removeSystemProperties;
            Optional password = Optional.fromNullable((Object)this.password.orNull());
            EncContext ctx = new EncContext(this);
            this.validate(ctx, required, (Optional<String>)password);
            if (removeSystemProperties) {
                PropertyUtils.removeSystemProperties(PASSWORD_KEYS);
            }
            return ctx;
        }
    }
}

