/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.execute;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.util.FileUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.FileSystemUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.LoggerUtils;
import org.kuali.common.util.execute.Executable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CopyFilePatternsExecutable
implements Executable {
    private static final Logger logger = LoggerFactory.getLogger(CopyFilePatternsExecutable.class);
    public static final List<String> DEFAULT_INCLUDES = FileSystemUtils.DEFAULT_RECURSIVE_INCLUDES;
    public static final List<String> DEFAULT_EXCLUDES = new ArrayList<String>();
    List<String> includes = DEFAULT_INCLUDES;
    List<String> excludes = DEFAULT_EXCLUDES;
    File srcDir;
    File dstDir;
    File relativeDir;
    boolean skip;

    @Override
    public void execute() {
        if (this.skip) {
            return;
        }
        Assert.notNull((Object)this.srcDir, (String)"srcDir is null");
        Assert.notNull((Object)this.dstDir, (String)"dstDir is null");
        Assert.isExistingDir(this.srcDir, "srcDir is not an existing directory");
        try {
            String includesCSV = StringUtils.trimToNull((String)CollectionUtils.getCSV(this.includes));
            String excludesCSV = StringUtils.trimToNull((String)CollectionUtils.getCSV(this.excludes));
            FileUtils.forceMkdir((File)this.dstDir);
            this.logCopy();
            FileUtils.copyDirectory((File)this.srcDir, (File)this.dstDir, (String)includesCSV, (String)excludesCSV);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO error", e);
        }
    }

    protected void logCopy() {
        String path = FileSystemUtils.getRelativePathQuietly(this.relativeDir, this.dstDir);
        Object[] args = new Object[]{path, LoggerUtils.getLogMsg(this.includes, this.excludes)};
        logger.debug("srcDir - [{}]", (Object)LocationUtils.getCanonicalPath(this.srcDir));
        logger.info("Copying to - [{}] - {}", args);
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public File getSrcDir() {
        return this.srcDir;
    }

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    public File getDstDir() {
        return this.dstDir;
    }

    public void setDstDir(File dstDir) {
        this.dstDir = dstDir;
    }

    public File getRelativeDir() {
        return this.relativeDir;
    }

    public void setRelativeDir(File relativeDir) {
        this.relativeDir = relativeDir;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}

