/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.execute;

import java.util.Arrays;
import java.util.List;
import org.kuali.common.util.Assert;
import org.kuali.common.util.FileSystemUtils;
import org.kuali.common.util.execute.CopyFileRequest;
import org.kuali.common.util.execute.CopyFileResult;
import org.kuali.common.util.execute.Executable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyFilesExecutable
implements Executable {
    private static final Logger logger = LoggerFactory.getLogger(CopyFilesExecutable.class);
    boolean skip;
    List<CopyFileRequest> requests;
    List<CopyFileResult> results;

    public CopyFilesExecutable() {
        this(null, false);
    }

    public CopyFilesExecutable(CopyFileRequest request) {
        this(Arrays.asList(request), false);
    }

    public CopyFilesExecutable(List<CopyFileRequest> requests) {
        this(requests, false);
    }

    public CopyFilesExecutable(List<CopyFileRequest> requests, boolean skip) {
        this.requests = requests;
        this.skip = skip;
    }

    @Override
    public void execute() {
        if (this.skip) {
            return;
        }
        Assert.notNull(this.requests, (String)"requests is null");
        logger.info("Copying {} files", (Object)this.requests.size());
        List<CopyFileResult> results = FileSystemUtils.copyFiles(this.requests);
        this.results = results;
    }

    public List<CopyFileResult> getResults() {
        return this.results;
    }

    public List<CopyFileRequest> getRequests() {
        return this.requests;
    }

    public void setRequests(List<CopyFileRequest> requests) {
        this.requests = requests;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}

