/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.execute;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.execute.Executable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ExecutablesExecutable
implements Executable {
    private static final Logger logger = LoggerFactory.getLogger(ExecutablesExecutable.class);
    List<? extends Executable> executables;
    boolean skip;
    boolean timed;

    public ExecutablesExecutable() {
        this((List<? extends Executable>)null);
    }

    public ExecutablesExecutable(Executable ... executables) {
        this(Arrays.asList(executables));
    }

    public ExecutablesExecutable(List<? extends Executable> executables) {
        this(executables, false);
    }

    public ExecutablesExecutable(List<? extends Executable> executables, boolean skip) {
        this(executables, skip, false);
    }

    public ExecutablesExecutable(List<? extends Executable> executables, boolean skip, boolean timed) {
        this.executables = executables;
        this.skip = skip;
        this.timed = timed;
    }

    @Override
    public void execute() {
        if (this.skip) {
            logger.info("Skipping execution of {} executables", (Object)CollectionUtils.toEmptyList(this.executables).size());
            return;
        }
        long start = System.currentTimeMillis();
        for (Executable executable : this.executables) {
            executable.execute();
        }
        if (this.timed) {
            long stop = System.currentTimeMillis();
            logger.info("------------------------------------------------------------------------");
            logger.info("Total Time: {}", (Object)FormatUtils.getTime(stop - start));
            logger.info("Finished at: {}", (Object)new Date(stop));
            logger.info("------------------------------------------------------------------------");
        }
    }

    public List<? extends Executable> getExecutables() {
        return this.executables;
    }

    public void setExecutables(List<? extends Executable> executables) {
        this.executables = executables;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public boolean isTimed() {
        return this.timed;
    }

    public void setTimed(boolean timed) {
        this.timed = timed;
    }
}

