/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.execute;

import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.ScmUtils;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.scm.ScmRequest;
import org.kuali.common.util.service.ScmService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ScmExecutable
implements Executable {
    private static final Logger logger = LoggerFactory.getLogger(ScmExecutable.class);
    boolean skip;
    boolean logConfiguration;
    ScmService service;
    ScmRequest request;

    @Override
    public void execute() {
        if (this.logConfiguration) {
            this.log(this);
        }
        if (this.skip) {
            logger.info("Skipping execution");
            return;
        }
        Assert.notNull((Object)this.request);
        if (this.isEmpty(this.request)) {
            logger.info("Skipping execution.  Nothing to do!");
            return;
        }
        this.validateConfiguration(this.service, this.request);
        if (!CollectionUtils.isEmpty(this.request.getAdds())) {
            this.service.add(this.request.getAdds());
        }
        if (!CollectionUtils.isEmpty(this.request.getDeletes())) {
            this.service.delete(this.request.getDeletes());
        }
        if (!CollectionUtils.isEmpty(this.request.getCommits())) {
            this.service.commit(this.request.getCommits(), this.request.getCommitMessage());
        }
    }

    protected void validateConfiguration(ScmService service, ScmRequest request) {
        Assert.notNull((Object)service, (String)"service is null");
        if (!CollectionUtils.isEmpty(request.getCommits())) {
            Assert.hasText((String)request.getCommitMessage(), (String)"commitMessage has no text");
        }
    }

    protected void log(ScmExecutable exec) {
        ScmRequest request = ScmUtils.cloneOrNew(exec.getRequest());
        String adds = FormatUtils.getCount(CollectionUtils.toEmptyList(request.getAdds()).size());
        String deletes = FormatUtils.getCount(CollectionUtils.toEmptyList(request.getDeletes()).size());
        String commits = FormatUtils.getCount(CollectionUtils.toEmptyList(request.getCommits()).size());
        logger.info(" -- SCM --");
        logger.info("Adds: {}", (Object)adds);
        logger.info("Deletes: {}", (Object)deletes);
        logger.info("Commits: {}", (Object)commits);
        logger.info("Skip: {}", (Object)this.skip);
    }

    public boolean isEmpty(ScmRequest request) {
        if (!CollectionUtils.isEmpty(request.getAdds())) {
            return false;
        }
        if (!CollectionUtils.isEmpty(request.getDeletes())) {
            return false;
        }
        return CollectionUtils.isEmpty(request.getCommits());
    }

    public ScmService getService() {
        return this.service;
    }

    public void setService(ScmService service) {
        this.service = service;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public ScmRequest getRequest() {
        return this.request;
    }

    public void setRequest(ScmRequest request) {
        this.request = request;
    }

    public boolean isLogConfiguration() {
        return this.logConfiguration;
    }

    public void setLogConfiguration(boolean logConfiguration) {
        this.logConfiguration = logConfiguration;
    }
}

