/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.execute.impl;

import java.io.File;
import java.util.List;
import org.kuali.common.util.Assert;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.execute.Executable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCopyLocationsExecutable
implements Executable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCopyLocationsExecutable.class);
    private final String locationListing;
    private final File directory;
    private final boolean skip;

    public AbstractCopyLocationsExecutable(String locationListing, File directory) {
        this(locationListing, directory, false);
    }

    public AbstractCopyLocationsExecutable(String locationListing, File directory, boolean skip) {
        Assert.noBlanks(locationListing);
        Assert.notNull((Object)directory);
        Assert.exists(locationListing);
        this.locationListing = locationListing;
        this.directory = directory;
        this.skip = skip;
    }

    protected abstract List<File> getFiles(List<String> var1);

    @Override
    public void execute() {
        logger.info("Copying [{}] -> [{}]", (Object)this.locationListing, (Object)LocationUtils.getCanonicalPath(this.directory));
        List<String> locations = LocationUtils.getLocations(this.locationListing);
        List<File> files = this.getFiles(locations);
        LocationUtils.copyLocationsToFiles(locations, files);
        logger.info("Copied {} files", (Object)locations.size());
    }

    public String getLocationListing() {
        return this.locationListing;
    }

    public File getDirectory() {
        return this.directory;
    }

    public boolean isSkip() {
        return this.skip;
    }
}

