/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.execute.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.log.LoggerContext;
import org.kuali.common.util.log.LoggerExecutable;
import org.kuali.common.util.log.LoggerUtils;
import org.slf4j.Logger;

public class SetSystemPropertyExecutable
implements Executable {
    private static final Logger logger = LoggerUtils.make();
    private final boolean skip;
    private final Optional<LoggerContext> context;
    private final String key;
    private final String value;

    @Override
    public void execute() {
        if (this.skip) {
            return;
        }
        if (this.context.isPresent()) {
            LoggerExecutable.create((LoggerContext)this.context.get()).execute();
        }
        System.setProperty(this.key, this.value);
    }

    private SetSystemPropertyExecutable(Builder builder) {
        this.key = builder.key;
        this.value = builder.value;
        this.skip = builder.skip;
        this.context = builder.context;
    }

    public static Builder builder(String key, String value) {
        return new Builder(key, value);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public Optional<LoggerContext> getContext() {
        return this.context;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public static class Builder {
        private final String key;
        private final String value;
        private Optional<LoggerContext> context = Optional.absent();
        private boolean skip = false;

        public Builder(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public Builder log(String msg) {
            return this.log(msg, (List<Object>)ImmutableList.of());
        }

        public Builder log(String msg, List<Object> args) {
            return this.context(LoggerContext.builder(logger, msg).args(args).build());
        }

        public Builder context(LoggerContext context) {
            this.context = Optional.of((Object)context);
            return this;
        }

        public Builder skip(boolean skip) {
            this.skip = skip;
            return this;
        }

        public SetSystemPropertyExecutable build() {
            SetSystemPropertyExecutable instance = new SetSystemPropertyExecutable(this);
            Builder.validate(instance);
            return instance;
        }

        private static void validate(SetSystemPropertyExecutable instance) {
            Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)instance.key) ? 1 : 0) != 0, (Object)"key cannot be blank");
            Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)instance.value) ? 1 : 0) != 0, (Object)"value cannot be blank");
            Preconditions.checkNotNull((Object)instance.context, (Object)"context cannot be null");
        }

        public Optional<LoggerContext> getContext() {
            return this.context;
        }

        public void setContext(Optional<LoggerContext> context) {
            this.context = context;
        }

        public boolean isSkip() {
            return this.skip;
        }

        public void setSkip(boolean skip) {
            this.skip = skip;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

