/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.execute.impl;

import java.nio.charset.Charset;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.file.CanonicalFile;
import org.kuali.common.util.log.LoggerUtils;
import org.slf4j.Logger;

public class ShowEnvExec
implements Executable {
    private static final Logger logger = LoggerUtils.make();
    private final boolean skip;

    public ShowEnvExec() {
        this(false);
    }

    public ShowEnvExec(boolean skip) {
        this.skip = skip;
    }

    @Override
    public void execute() {
        if (this.skip) {
            return;
        }
        Object[] java = new Object[]{System.getProperty("java.runtime.version"), System.getProperty("java.vm.name"), System.getProperty("java.vm.vendor")};
        Object[] javaHome = new Object[]{new CanonicalFile(System.getProperty("java.home"))};
        Object[] JAVA_HOME = this.getJavaHomeEnvironmentVariable();
        Object[] other = new Object[]{Locale.getDefault().toString(), Charset.defaultCharset().displayName()};
        Object[] os = new Object[]{System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")};
        logger.info("Java version: {}, name: {}, vendor: {}", java);
        logger.info("Java home: {}", javaHome);
        logger.info("JAVA_HOME: {}", JAVA_HOME);
        logger.info("Default locale: {}, platform encoding: {}", other);
        logger.info("OS name: {}, version: {}, arch: {}", os);
    }

    public Object[] getJavaHomeEnvironmentVariable() {
        String javaHome = System.getenv("JAVA_HOME");
        if (StringUtils.isBlank((CharSequence)javaHome)) {
            return new Object[]{"-- Not set --"};
        }
        return new Object[]{new CanonicalFile(javaHome)};
    }

    public boolean isSkip() {
        return this.skip;
    }
}

