/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.log;

import com.google.common.base.Preconditions;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.log.LoggerContext;
import org.kuali.common.util.log.LoggerUtils;

public class LoggerExecutable
implements Executable {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final LoggerContext context;
    private final boolean skip;

    @Override
    public void execute() {
        if (!this.skip) {
            LoggerUtils.logMsg(this.context.getMsg(), this.context.getArgs().toArray(EMPTY_OBJECT_ARRAY), this.context.getLogger(), this.context.getLevel());
        }
    }

    private LoggerExecutable(Builder builder) {
        this.context = builder.context;
        this.skip = builder.skip;
    }

    public static LoggerExecutable create(LoggerContext context) {
        return LoggerExecutable.builder(context).build();
    }

    public static Builder builder(LoggerContext context) {
        return new Builder(context);
    }

    public LoggerContext getContext() {
        return this.context;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public static class Builder {
        private final LoggerContext context;
        private boolean skip = false;

        public Builder(LoggerContext context) {
            this.context = context;
        }

        public Builder skip(boolean skip) {
            this.skip = skip;
            return this;
        }

        public LoggerExecutable build() {
            LoggerExecutable instance = new LoggerExecutable(this);
            Builder.validate(instance);
            return instance;
        }

        private static void validate(LoggerExecutable instance) {
            Preconditions.checkNotNull((Object)instance.context, (Object)"context may not be null");
        }
    }
}

