/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.main;

import java.util.Collections;
import java.util.Map;
import org.kuali.common.util.main.MainContext;
import org.kuali.common.util.main.Status;
import org.kuali.common.util.spring.SpringExecutable;
import org.kuali.common.util.spring.service.SpringContext;
import org.kuali.common.util.spring.service.SpringService;

public class MainUtils {
    public static final String MAIN_CONTEXT_BEAN_NAME = "mainContext";
    public static final String MAIN_PROFILE_NAME = "main";

    public static void runAndExit(Class<?> mainClass, String[] args) {
        MainUtils.runAndExit(mainClass, args, false);
    }

    public static void runAndExit(Class<?> mainClass, String[] args, boolean stacktrace) {
        MainUtils.run(mainClass, args, stacktrace, true);
    }

    public static void run(Class<?> mainClass, String[] args, boolean stacktrace) {
        MainUtils.run(mainClass, args, stacktrace, false);
    }

    public static void run(Class<?> mainClass, String[] args) {
        MainUtils.run(mainClass, args, true, false);
    }

    public static void run(Class<?> mainClass, String[] args, boolean stacktrace, boolean exit) {
        try {
            MainContext mainContext = new MainContext(mainClass, args);
            Map<String, Object> beans = Collections.singletonMap(MAIN_CONTEXT_BEAN_NAME, mainContext);
            SpringContext context = new SpringContext(beans, mainClass, MAIN_PROFILE_NAME);
            SpringService service = SpringExecutable.DEFAULT_SPRING_SERVICE;
            new SpringExecutable(service, context).execute();
            if (exit) {
                System.exit(Status.SUCCESS.getValue());
            }
        }
        catch (Exception e) {
            MainUtils.handleException(e, stacktrace, exit);
        }
    }

    protected static void handleException(Exception e, boolean stacktrace, boolean exit) {
        if (stacktrace) {
            e.printStackTrace();
        } else {
            System.err.print(e.getMessage());
        }
        if (exit) {
            System.exit(Status.FAILURE.getValue());
        }
    }
}

