/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.maven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.Project;
import org.kuali.common.util.ProjectUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.project.ProjectService;
import org.kuali.common.util.property.ProjectProperties;
import org.kuali.common.util.property.PropertiesContext;
import org.kuali.common.util.property.processor.ProjectProcessor;
import org.kuali.common.util.property.processor.PropertyProcessor;
import org.kuali.common.util.property.processor.VersionProcessor;
import org.kuali.common.util.spring.PropertySourceUtils;
import org.kuali.common.util.spring.service.DefaultPropertySourceService;
import org.kuali.common.util.spring.service.DefaultSpringService;
import org.kuali.common.util.spring.service.PropertySourceService;
import org.kuali.common.util.spring.service.SpringContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

public class MavenUtils {
    private static final Logger logger = LoggerFactory.getLogger(MavenUtils.class);
    @Deprecated
    public static final String POM = "pom";
    @Deprecated
    public static final String PROJECT_VERSION_KEY = "project.version";
    @Deprecated
    public static final String PROJECT_ENCODING_KEY = "project.encoding";

    @Deprecated
    public static SpringContext getMavenizedSpringContext(Class<?> propertySourceConfig) {
        return MavenUtils.getMavenizedSpringContext(null, propertySourceConfig);
    }

    @Deprecated
    public static SpringContext getMavenizedSpringContext(Properties mavenProperties, Class<?> propertySourceConfig) {
        DefaultPropertySourceService service = new DefaultPropertySourceService(new DefaultSpringService());
        return MavenUtils.getMavenizedSpringContext(service, mavenProperties, propertySourceConfig);
    }

    @Deprecated
    public static SpringContext getMavenizedSpringContext(PropertySourceService service, Properties mavenProperties, Class<?> propertySourceConfig) {
        Map<String, Object> beans = CollectionUtils.toEmptyMap("mavenProperties", mavenProperties);
        List<PropertySource<?>> sources = service.getPropertySources(beans, null, null, propertySourceConfig);
        Assert.isTrue((sources.size() == 1 ? 1 : 0) != 0, (String)"sources.size != 1");
        return PropertySourceUtils.getSinglePropertySourceContext(sources.get(0));
    }

    @Deprecated
    public static void augmentProjectProperties(ProjectService service, Properties mavenProperties) {
        MavenUtils.augmentProjectProperties(mavenProperties);
    }

    public static void augmentProjectProperties(Properties mavenProperties) {
        ArrayList<PropertyProcessor> processors = new ArrayList<PropertyProcessor>();
        processors.add(new ProjectProcessor());
        processors.add(new VersionProcessor(Arrays.asList(PROJECT_VERSION_KEY), true));
        PropertyUtils.process(mavenProperties, processors);
        String encoding = PropertyUtils.getRequiredResolvedProperty(mavenProperties, PROJECT_ENCODING_KEY);
        PropertyUtils.prepareContextProperties(mavenProperties, encoding);
    }

    @Deprecated
    public static ProjectProperties getMavenProjectProperties(Properties mavenProperties) {
        Project project = ProjectUtils.getProject(mavenProperties);
        PropertiesContext pc = new PropertiesContext();
        pc.setProperties(mavenProperties);
        ProjectProperties pp = new ProjectProperties();
        pp.setProject(project);
        pp.setPropertiesContext(pc);
        return pp;
    }

    @Deprecated
    protected static List<String> getList(Properties properties, String key) {
        String csv = properties.getProperty(key);
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(CollectionUtils.getTrimmedListFromCSV(csv));
        return list;
    }

    @Deprecated
    protected static List<String> getList(Environment env, Properties properties, String key) {
        String csv = env.getProperty(key);
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(CollectionUtils.getTrimmedListFromCSV(csv));
        list.addAll(MavenUtils.getList(properties, key));
        return list;
    }

    public static final boolean skip(boolean forceMojoExecution, boolean skip, String packaging) {
        if (forceMojoExecution) {
            logger.info("Forced mojo execution");
            return false;
        }
        if (skip) {
            logger.info("Skipping mojo execution");
            return true;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)packaging, (CharSequence)POM)) {
            logger.info("Skipping mojo execution for project with packaging type '{}'", (Object)POM);
            return true;
        }
        return false;
    }
}

