/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.Str;
import org.kuali.common.util.maven.model.Artifact;
import org.kuali.common.util.maven.model.Dependency;
import org.kuali.common.util.nullify.NullUtils;

public class RepositoryUtils {
    private static final String FS = File.separator;
    private static final String GAV_DELIMITER = ":";
    private static final String DEFAULT_MAVEN_REPO_PATH = ".m2" + FS + "repository";

    public static File getDefaultLocalRepository() {
        return new File(FileUtils.getUserDirectoryPath() + FS + DEFAULT_MAVEN_REPO_PATH);
    }

    public static final void copyArtifactToDirectory(String repository, Artifact artifact, File localRepository) {
        String filename = RepositoryUtils.getFilename(artifact);
        File file = new File(localRepository, filename);
        RepositoryUtils.copyArtifactToFile(repository, artifact, file);
    }

    public static final void copyArtifactToFile(String repository, Artifact artifact, File file) {
        String location = repository + RepositoryUtils.getRepositoryPath(artifact);
        LocationUtils.copyLocationToFile(location, file);
    }

    public static final String toString(Artifact artifact) {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add(RepositoryUtils.toEmpty(artifact.getGroupId()));
        tokens.add(RepositoryUtils.toEmpty(artifact.getArtifactId()));
        tokens.add(RepositoryUtils.toEmpty(artifact.getVersion()));
        tokens.add(RepositoryUtils.toEmpty((String)artifact.getClassifier().orNull()));
        tokens.add(RepositoryUtils.toEmpty(artifact.getType()));
        int delimiterCount = RepositoryUtils.getDelimiterCount(tokens);
        return RepositoryUtils.getDelimitedString(tokens, delimiterCount, GAV_DELIMITER);
    }

    public static final String toString(Dependency dependency) {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add(RepositoryUtils.toEmpty(dependency.getGroupId()));
        tokens.add(RepositoryUtils.toEmpty(dependency.getArtifactId()));
        tokens.add(RepositoryUtils.toEmpty(dependency.getVersion()));
        tokens.add(RepositoryUtils.toEmpty((String)dependency.getClassifier().orNull()));
        tokens.add(RepositoryUtils.toEmpty(dependency.getType()));
        tokens.add(RepositoryUtils.toEmpty(dependency.getScope()));
        int delimiterCount = RepositoryUtils.getDelimiterCount(tokens);
        return RepositoryUtils.getDelimitedString(tokens, delimiterCount, GAV_DELIMITER);
    }

    public static final Artifact parseArtifact(String gav) {
        Assert.noBlanks(gav);
        String[] tokens = StringUtils.splitPreserveAllTokens((String)gav, (String)GAV_DELIMITER);
        int len = tokens.length;
        Assert.isTrue((len >= 2 ? 1 : 0) != 0, (String)"groupId, artifactId, and version are required");
        for (int i = 0; i < len; ++i) {
            tokens[i] = NullUtils.trimToNull(tokens[i]);
        }
        String groupId = tokens[0];
        String artifactId = tokens[1];
        String version = tokens[2];
        String classifier = len > 3 ? tokens[3] : "NONE";
        String type = len > 4 ? tokens[4] : "jar";
        return new Artifact.Builder(groupId, artifactId, version).classifier(classifier).type(type).build();
    }

    public static final Dependency parseDependency(String gav) {
        Assert.noBlanks(gav);
        String[] tokens = StringUtils.splitPreserveAllTokens((String)gav, (String)GAV_DELIMITER);
        int len = tokens.length;
        Assert.isTrue((len >= 2 ? 1 : 0) != 0, (String)"groupId, artifactId, and version are required");
        for (int i = 0; i < len; ++i) {
            tokens[i] = NullUtils.trimToNull(tokens[i]);
        }
        String groupId = tokens[0];
        String artifactId = tokens[1];
        String version = tokens[2];
        String classifier = len > 3 ? tokens[3] : "NONE";
        String type = len > 4 ? tokens[4] : "jar";
        String scope = len > 5 ? tokens[5] : "compile";
        return new Dependency.Builder(groupId, artifactId, version).classifier(classifier).type(type).scope(scope).build();
    }

    protected static final String getDelimitedString(List<String> tokens, int delimiterCount, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            if (i != 0 && i < delimiterCount) {
                sb.append(delimiter);
            }
            sb.append(tokens.get(i));
        }
        return sb.toString();
    }

    protected static final int getDelimiterCount(List<String> tokens) {
        int count = 0;
        for (int i = 0; i < tokens.size(); ++i) {
            String token = RepositoryUtils.toEmpty(tokens.get(i));
            if (StringUtils.isEmpty((CharSequence)token)) continue;
            count = i + 1;
        }
        return count == 0 ? tokens.size() : count;
    }

    @Deprecated
    public static String toNull(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        if (NullUtils.isNullOrNone(token)) {
            return null;
        }
        return token;
    }

    public static String toEmpty(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            return "";
        }
        if (NullUtils.isNullOrNone(token)) {
            return "";
        }
        return token;
    }

    public static final String getRepositoryPath(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(Str.getPath(artifact.getGroupId()));
        sb.append(FS);
        sb.append(artifact.getArtifactId());
        sb.append(FS);
        sb.append(artifact.getVersion());
        return sb.toString();
    }

    public static final String getFilename(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getArtifactId());
        sb.append("-");
        sb.append(artifact.getVersion());
        if (artifact.getClassifier().isPresent()) {
            sb.append("-");
            sb.append((String)artifact.getClassifier().get());
        }
        sb.append(".");
        sb.append(artifact.getType());
        return sb.toString();
    }

    public static final File getFile(File localRepositoryDir, Artifact artifact) {
        String path = RepositoryUtils.getRepositoryPath(artifact);
        String filename = RepositoryUtils.getFilename(artifact);
        return new File(localRepositoryDir.getAbsolutePath() + FS + path, filename);
    }

    public static final boolean exists(File localRepositoryDir, Artifact artifact) {
        File file = RepositoryUtils.getFile(localRepositoryDir, artifact);
        return LocationUtils.exists(file);
    }
}

