/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.metainf.model;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.kuali.common.util.Assert;
import org.kuali.common.util.metainf.model.MetaInfResource;

public final class MetaInfContext {
    private final File outputFile;
    private final File scanDir;
    private final String encoding;
    private final boolean sort;
    private final boolean includePropertiesFile;
    private final Optional<Comparator<MetaInfResource>> comparator;
    private final boolean includeFileSizes;
    private final boolean includeLineCounts;
    private final List<String> includes;
    private final List<String> excludes;
    private final boolean relativePaths;
    private final File relativeDir;
    private final String urlPrefix;

    public File getOutputFile() {
        return this.outputFile;
    }

    public File getScanDir() {
        return this.scanDir;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isSort() {
        return this.sort;
    }

    public boolean isIncludePropertiesFile() {
        return this.includePropertiesFile;
    }

    public boolean isIncludeFileSizes() {
        return this.includeFileSizes;
    }

    public boolean isIncludeLineCounts() {
        return this.includeLineCounts;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public boolean isRelativePaths() {
        return this.relativePaths;
    }

    public File getRelativeDir() {
        return this.relativeDir;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public Optional<Comparator<MetaInfResource>> getComparator() {
        return this.comparator;
    }

    public static Builder builder(File outputFile, String encoding, File scanDir) {
        return new Builder(outputFile, encoding, scanDir);
    }

    private MetaInfContext(Builder builder) {
        this.sort = builder.sort;
        this.encoding = builder.encoding;
        this.urlPrefix = builder.urlPrefix;
        this.includeFileSizes = builder.includeFileSizes;
        this.includeLineCounts = builder.includeLineCounts;
        this.includePropertiesFile = builder.includePropertiesFile;
        this.includes = builder.includes;
        this.excludes = builder.excludes;
        this.scanDir = builder.scanDir;
        this.relativeDir = builder.relativeDir;
        this.outputFile = builder.outputFile;
        this.relativePaths = builder.relativePaths;
        this.comparator = builder.comparator;
    }

    public static class Builder {
        private final File outputFile;
        private final File scanDir;
        private final String encoding;
        private boolean sort = true;
        private boolean includePropertiesFile = false;
        private boolean includeFileSizes = true;
        private boolean includeLineCounts = false;
        private List<String> includes = Collections.emptyList();
        private List<String> excludes = Collections.emptyList();
        private boolean relativePaths = true;
        private String urlPrefix = "classpath:";
        private Optional<Comparator<MetaInfResource>> comparator = Optional.absent();
        private File relativeDir;

        public Builder(File outputFile, String encoding, File scanDir) {
            this.outputFile = outputFile;
            this.encoding = encoding;
            this.scanDir = scanDir;
            this.relativeDir = scanDir;
        }

        public Builder comparator(Comparator<MetaInfResource> comparator) {
            this.comparator = Optional.of(comparator);
            return this;
        }

        public Builder sort(boolean sort) {
            this.sort = sort;
            return this;
        }

        public Builder includes(List<String> includes) {
            this.includes = includes;
            return this;
        }

        public Builder excludes(List<String> excludes) {
            this.excludes = excludes;
            return this;
        }

        public Builder relativePaths(boolean relativePaths) {
            this.relativePaths = relativePaths;
            return this;
        }

        public Builder includePropertiesFile(boolean includePropertiesFile) {
            this.includePropertiesFile = includePropertiesFile;
            return this;
        }

        public Builder includeFileSizes(boolean includeFileSizes) {
            this.includeFileSizes = includeFileSizes;
            return this;
        }

        public Builder includeLineCounts(boolean includeLineCounts) {
            this.includeLineCounts = includeLineCounts;
            return this;
        }

        public MetaInfContext build() {
            Assert.noNulls(this.outputFile, this.scanDir, this.includes, this.excludes, this.relativeDir, this.comparator);
            Assert.noBlanks(this.encoding, this.urlPrefix);
            this.includes = ImmutableList.copyOf(this.includes);
            this.excludes = ImmutableList.copyOf(this.excludes);
            return new MetaInfContext(this);
        }
    }
}

