/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.metainf.service;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.SimpleScanner;
import org.kuali.common.util.Str;
import org.kuali.common.util.metainf.model.PathComparator;
import org.kuali.common.util.metainf.spring.MetaInfDataLocation;
import org.kuali.common.util.metainf.spring.MetaInfDataType;
import org.kuali.common.util.metainf.spring.MetaInfGroup;
import org.kuali.common.util.project.KualiUtilProjectConstants;
import org.kuali.common.util.project.ProjectUtils;
import org.kuali.common.util.project.model.Build;
import org.kuali.common.util.project.model.FeatureIdentifier;
import org.kuali.common.util.project.model.Project;
import org.kuali.common.util.project.model.ProjectIdentifier;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class MetaInfUtils {
    public static final String RESOURCES_FILENAME_EXTENSION = "resources";
    public static final String METAINF_DIRECTORY_NAME = "META-INF";
    @Deprecated
    public static final FeatureIdentifier FEATURE_ID = new FeatureIdentifier(KualiUtilProjectConstants.PROJECT_ID, "metainf");
    public static final String PROPERTY_PREFIX = "metainf";

    public static File getOutputFile(Project project, Build build, MetaInfGroup group) {
        return MetaInfUtils.getOutputFile(project, build, group.name().toLowerCase());
    }

    public static File getOutputFile(Project project, Build build, String filename) {
        return MetaInfUtils.getOutputFile(project, build, (Optional<String>)Optional.absent(), filename);
    }

    public static File getOutputFile(Project project, Build build, String qualifier, MetaInfGroup group) {
        return MetaInfUtils.getOutputFile(project, build, (Optional<String>)Optional.of((Object)qualifier), group.name().toLowerCase());
    }

    public static File getOutputFile(Project project, Build build, String qualifier, String filename) {
        return MetaInfUtils.getOutputFile(project, build, (Optional<String>)Optional.of((Object)qualifier), filename);
    }

    public static File getOutputFile(Project project, Build build, Optional<String> qualifier, String filename) {
        return MetaInfUtils.getOutputFile(project, build, qualifier, (Optional<MetaInfDataLocation>)Optional.absent(), (Optional<MetaInfDataType>)Optional.absent(), filename);
    }

    public static File getOutputFile(Project project, Build build, Optional<String> qualifier, Optional<MetaInfDataLocation> location, Optional<MetaInfDataType> type, String filename) {
        StringBuilder sb = new StringBuilder();
        sb.append(MetaInfUtils.getResourcePrefix(project));
        if (qualifier.isPresent()) {
            sb.append("/");
            sb.append((String)qualifier.get());
        }
        if (location.isPresent()) {
            sb.append("/");
            sb.append(((MetaInfDataLocation)((Object)location.get())).name().toLowerCase());
        }
        if (type.isPresent()) {
            sb.append("/");
            sb.append(((MetaInfDataType)((Object)type.get())).name().toLowerCase());
        }
        sb.append("/");
        sb.append(MetaInfUtils.getFilename(filename));
        return new File(build.getOutputDir(), sb.toString());
    }

    public static String getClasspathResource(ProjectIdentifier project, MetaInfGroup group) {
        return MetaInfUtils.getClasspathResource(project.getGroupId(), project.getArtifactId(), group);
    }

    public static String getClasspathResource(ProjectIdentifier project, String filename) {
        return MetaInfUtils.getClasspathResource(project.getGroupId(), project.getArtifactId(), filename);
    }

    public static String getClasspathResource(ProjectIdentifier project, String qualifier, MetaInfGroup group) {
        return MetaInfUtils.getClasspathResource(project.getGroupId(), project.getArtifactId(), (Optional<String>)Optional.of((Object)qualifier), group.name().toLowerCase());
    }

    public static String getClasspathResource(ProjectIdentifier project, String qualifier, String filename) {
        return MetaInfUtils.getClasspathResource(project.getGroupId(), project.getArtifactId(), (Optional<String>)Optional.of((Object)qualifier), filename);
    }

    public static String getClasspathResource(ProjectIdentifier project, Optional<String> qualifier, Optional<MetaInfDataLocation> location, Optional<MetaInfDataType> type, String filename) {
        return MetaInfUtils.getClasspathResource(project.getGroupId(), project.getArtifactId(), qualifier, location, type, filename);
    }

    public static String getClasspathResource(Project project, MetaInfGroup group) {
        return MetaInfUtils.getClasspathResource(project.getGroupId(), project.getArtifactId(), group);
    }

    public static String getClasspathResource(Project project, String filename) {
        return MetaInfUtils.getClasspathResource(project.getGroupId(), project.getArtifactId(), filename);
    }

    public static String getClasspathResource(Project project, String qualifier, MetaInfGroup group) {
        return MetaInfUtils.getClasspathResource(project.getGroupId(), project.getArtifactId(), (Optional<String>)Optional.of((Object)qualifier), group.name().toLowerCase());
    }

    public static String getClasspathResource(Project project, String qualifier, String filename) {
        return MetaInfUtils.getClasspathResource(project.getGroupId(), project.getArtifactId(), (Optional<String>)Optional.of((Object)qualifier), filename);
    }

    public static String getClasspathResource(Project project, Optional<String> qualifier, Optional<MetaInfDataLocation> location, Optional<MetaInfDataType> type, String filename) {
        return MetaInfUtils.getClasspathResource(project.getGroupId(), project.getArtifactId(), qualifier, location, type, filename);
    }

    public static String getClasspathResource(String groupId, String artifactId, MetaInfGroup group) {
        return MetaInfUtils.getClasspathResource(groupId, artifactId, (Optional<String>)Optional.absent(), group.name().toLowerCase());
    }

    public static String getClasspathResource(String groupId, String artifactId, String filename) {
        return MetaInfUtils.getClasspathResource(groupId, artifactId, (Optional<String>)Optional.absent(), filename);
    }

    public static String getClasspathResource(String groupId, String artifactId, Optional<String> qualifier, String filename) {
        return MetaInfUtils.getClasspathResource(groupId, artifactId, qualifier, (Optional<MetaInfDataLocation>)Optional.absent(), (Optional<MetaInfDataType>)Optional.absent(), filename);
    }

    public static String getClasspathResource(String groupId, String artifactId, Optional<String> qualifier, Optional<MetaInfDataLocation> location, Optional<MetaInfDataType> type, String filename) {
        StringBuilder sb = new StringBuilder();
        sb.append("classpath:");
        sb.append(MetaInfUtils.getResourcePrefix(groupId, artifactId));
        if (qualifier.isPresent()) {
            sb.append("/");
            sb.append((String)qualifier.get());
        }
        if (location.isPresent()) {
            sb.append("/");
            sb.append(((MetaInfDataLocation)((Object)location.get())).name().toLowerCase());
        }
        if (type.isPresent()) {
            sb.append("/");
            sb.append(((MetaInfDataType)((Object)type.get())).name().toLowerCase());
        }
        sb.append("/");
        sb.append(MetaInfUtils.getFilename(filename));
        return sb.toString();
    }

    public static List<String> getPatternedClasspathResources(ProjectIdentifier project, String filename) {
        return MetaInfUtils.getPatternedClasspathResources(project.getGroupId(), project.getArtifactId(), filename);
    }

    public static List<String> getPatternedClasspathResources(ProjectIdentifier project, String qualifier, MetaInfGroup group) {
        return MetaInfUtils.getPatternedClasspathResources(project.getGroupId(), project.getArtifactId(), (Optional<String>)Optional.of((Object)qualifier), group.name().toLowerCase());
    }

    public static List<String> getPatternedClasspathResources(ProjectIdentifier project, String qualifier, String filename) {
        return MetaInfUtils.getPatternedClasspathResources(project.getGroupId(), project.getArtifactId(), (Optional<String>)Optional.of((Object)qualifier), filename);
    }

    public static List<String> getPatternedClasspathResources(ProjectIdentifier project, Optional<String> qualifier, Optional<MetaInfDataLocation> location, Optional<MetaInfDataType> type, String filename) {
        return MetaInfUtils.getPatternedClasspathResources(project.getGroupId(), project.getArtifactId(), qualifier, location, type, filename);
    }

    public static List<String> getPatternedClasspathResources(Project project, String filename) {
        return MetaInfUtils.getPatternedClasspathResources(project.getGroupId(), project.getArtifactId(), filename);
    }

    public static List<String> getPatternedClasspathResources(Project project, String qualifier, MetaInfGroup group) {
        return MetaInfUtils.getPatternedClasspathResources(project.getGroupId(), project.getArtifactId(), (Optional<String>)Optional.of((Object)qualifier), group.name().toLowerCase());
    }

    public static List<String> getPatternedClasspathResources(Project project, String qualifier, String filename) {
        return MetaInfUtils.getPatternedClasspathResources(project.getGroupId(), project.getArtifactId(), (Optional<String>)Optional.of((Object)qualifier), filename);
    }

    public static List<String> getPatternedClasspathResources(Project project, Optional<String> qualifier, Optional<MetaInfDataLocation> location, Optional<MetaInfDataType> type, String filename) {
        return MetaInfUtils.getPatternedClasspathResources(project.getGroupId(), project.getArtifactId(), qualifier, location, type, filename);
    }

    public static List<String> getPatternedClasspathResources(String groupId, String artifactId, String filename) {
        return MetaInfUtils.getPatternedClasspathResources(groupId, artifactId, (Optional<String>)Optional.absent(), filename);
    }

    public static List<String> getPatternedClasspathResources(String groupId, String artifactId, Optional<String> qualifier, String filename) {
        return MetaInfUtils.getPatternedClasspathResources(groupId, artifactId, qualifier, (Optional<MetaInfDataLocation>)Optional.absent(), (Optional<MetaInfDataType>)Optional.absent(), filename);
    }

    public static List<String> getPatternedClasspathResources(String groupId, String artifactId, Optional<String> qualifier, Optional<MetaInfDataLocation> location, Optional<MetaInfDataType> type, String filename) {
        ArrayList<String> patterenedClasspathResources = new ArrayList<String>();
        String classpathResource = MetaInfUtils.getClasspathResource(groupId, artifactId, qualifier, location, type, filename);
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Object[] resources = resolver.getResources(classpathResource);
            if (ArrayUtils.isNotEmpty((Object[])resources)) {
                for (Object resource : resources) {
                    if (!(resource instanceof ClassPathResource)) continue;
                    ClassPathResource classPathResource = (ClassPathResource)resource;
                    patterenedClasspathResources.add("classpath:" + classPathResource.getPath());
                }
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unexpected IO error", ioe);
        }
        return patterenedClasspathResources;
    }

    public static String getFilename(MetaInfGroup group) {
        return MetaInfUtils.getFilename(group.name().toLowerCase());
    }

    public static String getFilename(String filename) {
        return filename + "." + RESOURCES_FILENAME_EXTENSION;
    }

    public static String getGroupPrefix(Project project) {
        return MetaInfUtils.getGroupPrefix(project.getGroupId());
    }

    public static String getGroupPrefix(String groupId) {
        return "META-INF/" + Str.getPath(groupId);
    }

    public static String getClasspathPrefix() {
        return "classpath:META-INF";
    }

    public static String getResourcePrefix(Project project) {
        return MetaInfUtils.getResourcePrefix(project.getGroupId(), project.getArtifactId());
    }

    public static String getResourcePrefix(String groupId, String artifactId) {
        return MetaInfUtils.getGroupPrefix(groupId) + "/" + artifactId;
    }

    public static String getResourcePrefix(ProjectIdentifier project) {
        return MetaInfUtils.getResourcePrefix(project.getGroupId(), project.getArtifactId());
    }

    public static String getClasspathResourcePrefix(ProjectIdentifier project) {
        StringBuilder sb = new StringBuilder();
        sb.append("classpath:");
        sb.append(MetaInfUtils.getResourcePrefix(project.getGroupId(), project.getArtifactId()));
        return sb.toString();
    }

    public static String getClasspathResourcePrefix(Project project) {
        StringBuilder sb = new StringBuilder();
        sb.append("classpath:");
        sb.append(MetaInfUtils.getResourcePrefix(project.getGroupId(), project.getArtifactId()));
        return sb.toString();
    }

    public static List<String> getQualifiers(File baseDirectory, ProjectIdentifier project, List<String> includes, List<String> excludes) {
        String resourcePath = ProjectUtils.getResourcePath(project.getGroupId(), project.getArtifactId());
        File resourceDirectory = FileUtils.getFile((File)baseDirectory, (String[])new String[]{resourcePath});
        return MetaInfUtils.getQualifiers(resourceDirectory, includes, excludes);
    }

    public static List<String> getQualifiers(File baseDirectory, Project project, List<String> includes, List<String> excludes) {
        String resourcePath = ProjectUtils.getResourcePath(project.getGroupId(), project.getArtifactId());
        File resourceDirectory = FileUtils.getFile((File)baseDirectory, (String[])new String[]{resourcePath});
        return MetaInfUtils.getQualifiers(resourceDirectory, includes, excludes);
    }

    public static List<String> getQualifiers(File baseDirectory, List<String> includes, List<String> excludes) {
        ArrayList qualifiers = Lists.newArrayList();
        SimpleScanner scanner = new SimpleScanner(baseDirectory, includes, excludes);
        List<String> directories = scanner.getDirectories();
        Collections.sort(directories, new PathComparator());
        for (String directory : directories) {
            if (qualifiers.isEmpty()) {
                qualifiers.add(directory);
                continue;
            }
            boolean matches = false;
            for (String qualifier : qualifiers) {
                matches |= StringUtils.startsWith((CharSequence)directory, (CharSequence)qualifier);
            }
            if (matches) continue;
            qualifiers.add(directory);
        }
        return qualifiers;
    }
}

