/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.metainf.spring;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.common.util.metainf.model.MetaInfContext;
import org.kuali.common.util.metainf.model.MetaInfResource;
import org.kuali.common.util.metainf.model.MetaInfResourceFilenameComparator;
import org.kuali.common.util.metainf.model.MetaInfResourceLocationComparator;
import org.kuali.common.util.metainf.service.MetaInfUtils;
import org.kuali.common.util.metainf.spring.MetaInfConfigUtils;
import org.kuali.common.util.metainf.spring.MetaInfContextsConfig;
import org.kuali.common.util.metainf.spring.MetaInfExecutableConfig;
import org.kuali.common.util.metainf.spring.MetaInfGroup;
import org.kuali.common.util.project.ProjectUtils;
import org.kuali.common.util.project.model.Build;
import org.kuali.common.util.project.model.Project;
import org.kuali.common.util.project.spring.AutowiredProjectConfig;
import org.kuali.common.util.spring.SpringUtils;
import org.kuali.common.util.spring.env.EnvironmentService;
import org.kuali.common.util.spring.service.SpringServiceConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={AutowiredProjectConfig.class, MetaInfExecutableConfig.class, SpringServiceConfig.class})
public class RiceSqlConfig
implements MetaInfContextsConfig {
    private static final boolean DEFAULT_GENERATE_RELATIVE_PATHS = true;
    private static final String RELATIVE_KEY = "metainf.sql.relative";
    private static final String PREFIX = "sql";
    private static final String DEFAULT_VENDORS = "mysql,oracle";
    private static final String VENDORS_KEY = "metainf.db.vendors";
    private static final String IMPEX_ARTIFACT_ID = "rice-impex-master";
    @Autowired
    EnvironmentService env;
    @Autowired
    Project project;
    @Autowired
    Build build;

    @Override
    @Bean
    public List<MetaInfContext> metaInfContexts() {
        List<String> vendors = SpringUtils.getNoneSensitiveListFromCSV(this.env, VENDORS_KEY, DEFAULT_VENDORS);
        ArrayList<MetaInfContext> contexts = new ArrayList<MetaInfContext>();
        for (String vendor : vendors) {
            for (MetaInfGroup group : MetaInfGroup.values()) {
                MetaInfContext context = this.getMetaInfContext(group, vendor);
                contexts.add(context);
            }
        }
        return contexts;
    }

    protected MetaInfContext getMetaInfContext(MetaInfGroup group, String vendor) {
        Map<MetaInfGroup, String> defaultIncludes = this.getDefaultIncludes(this.project, IMPEX_ARTIFACT_ID, vendor);
        Map<MetaInfGroup, String> defaultExcludes = this.getDefaultExcludes(defaultIncludes);
        boolean relativePaths = this.env.getBoolean(RELATIVE_KEY, true);
        File outputFile = MetaInfUtils.getOutputFile(this.project, this.build, vendor, group);
        String includesKey = MetaInfConfigUtils.getIncludesKey(group, PREFIX) + "." + vendor;
        String excludesKey = MetaInfConfigUtils.getExcludesKey(group, PREFIX) + "." + vendor;
        List<String> includes = SpringUtils.getNoneSensitiveListFromCSV(this.env, includesKey, defaultIncludes.get((Object)group));
        List<String> excludes = SpringUtils.getNoneSensitiveListFromCSV(this.env, excludesKey, defaultExcludes.get((Object)group));
        File scanDir = this.build.getOutputDir();
        String encoding = this.build.getEncoding();
        Comparator<MetaInfResource> comparator = this.getComparator(group);
        return new MetaInfContext.Builder(outputFile, encoding, scanDir).comparator(comparator).includes(includes).excludes(excludes).relativePaths(relativePaths).build();
    }

    protected Comparator<MetaInfResource> getComparator(MetaInfGroup group) {
        if (MetaInfGroup.OTHER.equals((Object)group)) {
            return new MetaInfResourceFilenameComparator();
        }
        return new MetaInfResourceLocationComparator();
    }

    protected Map<MetaInfGroup, String> getDefaultIncludes(Project project, String impexArtifactId, String vendor) {
        String resourcePath = ProjectUtils.getResourcePath(project.getGroupId(), project.getArtifactId());
        HashMap<MetaInfGroup, String> map = new HashMap<MetaInfGroup, String>();
        map.put(MetaInfGroup.SCHEMA, resourcePath + "/initial-db/sql/" + vendor + "/" + impexArtifactId + ".sql");
        map.put(MetaInfGroup.DATA, resourcePath + "/initial-db/sql/" + vendor + "/*.sql");
        map.put(MetaInfGroup.CONSTRAINTS, resourcePath + "/initial-db/sql/" + vendor + "/" + impexArtifactId + "-constraints.sql");
        map.put(MetaInfGroup.OTHER, resourcePath + "/upgrades/**/" + vendor + "/**/*.sql");
        return map;
    }

    protected Map<MetaInfGroup, String> getDefaultExcludes(Map<MetaInfGroup, String> defaultIncludes) {
        HashMap<MetaInfGroup, String> map = new HashMap<MetaInfGroup, String>();
        map.put(MetaInfGroup.SCHEMA, "NONE");
        map.put(MetaInfGroup.DATA, defaultIncludes.get((Object)MetaInfGroup.SCHEMA) + "," + defaultIncludes.get((Object)MetaInfGroup.CONSTRAINTS));
        map.put(MetaInfGroup.CONSTRAINTS, "NONE");
        map.put(MetaInfGroup.OTHER, "NONE");
        return map;
    }
}

