/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.nullify;

import com.google.common.base.Optional;
import org.apache.commons.lang3.StringUtils;

public class NullUtils {
    public static final String NONE = "NONE";
    public static final String NULL = "NULL";

    public static boolean isBlank(Object object) {
        return object instanceof CharSequence && StringUtils.isBlank((CharSequence)((CharSequence)object));
    }

    public static boolean isNullOrBlank(Object object) {
        if (object == null) {
            return true;
        }
        return NullUtils.isBlank(object);
    }

    public static final boolean isNull(String s) {
        return s == null || StringUtils.equalsIgnoreCase((CharSequence)NULL, (CharSequence)s);
    }

    public static final boolean isNone(String s) {
        return StringUtils.equalsIgnoreCase((CharSequence)NONE, (CharSequence)s);
    }

    public static final boolean isNullOrNone(String s) {
        return NullUtils.isNull(s) || NullUtils.isNone(s);
    }

    public static final Optional<String> toAbsent(String s) {
        return Optional.fromNullable((Object)NullUtils.trimToNull(s));
    }

    public static final String toNone(Optional<String> optional) {
        return NullUtils.trimToNone((String)optional.orNull());
    }

    public static final String trimToNull(String s) {
        String trimmed = StringUtils.trimToNull((String)s);
        return NullUtils.isNullOrNone(trimmed) ? null : trimmed;
    }

    public static final String trimToNone(String s) {
        if (NullUtils.trimToNull(s) == null) {
            return NONE;
        }
        return NullUtils.trimToNull(s);
    }
}

