/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.project.model;

import org.kuali.common.util.Assert;
import org.kuali.common.util.ObjectUtils;
import org.kuali.common.util.identify.Identifiable;

public final class ProjectIdentifier
implements Identifiable {
    private final String groupId;
    private final String artifactId;
    private final String identifier;
    private final int hashCode;

    public ProjectIdentifier(String groupId, String artifactId) {
        Assert.noBlanks(groupId, artifactId);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.identifier = groupId + ":" + artifactId;
        this.hashCode = this.identifier.hashCode();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return this.identifier;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        return ObjectUtils.equalsByToString(this, object);
    }
}

