/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.property.processor;

import java.io.File;
import java.util.Properties;
import org.kuali.common.util.Mode;
import org.kuali.common.util.OrgUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.property.Constants;
import org.kuali.common.util.property.processor.PropertyProcessor;
import org.springframework.util.Assert;

public class HomeProcessor
implements PropertyProcessor {
    Mode propertyOverwriteMode = Constants.DEFAULT_PROPERTY_OVERWRITE_MODE;
    String userHomeProperty = "user.home";
    String fileSeparator = File.separator;
    String hiddenDirectoryIndicator = ".";
    String organizationGroupId;
    String groupId;

    public HomeProcessor() {
        this(null, null);
    }

    public HomeProcessor(String organizationGroupId, String groupId) {
        this.organizationGroupId = organizationGroupId;
        this.groupId = groupId;
    }

    @Override
    public void process(Properties properties) {
        Assert.notNull((Object)this.organizationGroupId);
        Assert.notNull((Object)this.groupId);
        String organizationCode = OrgUtils.getOrgCode(this.organizationGroupId);
        String groupCode = OrgUtils.getGroupCode(this.organizationGroupId, this.groupId);
        String organizationHomeProperty = organizationCode + "." + "home";
        String groupHomeProperty = organizationCode + "." + "group" + "." + "home";
        String organizationHome = System.getProperty(this.userHomeProperty) + this.fileSeparator + this.hiddenDirectoryIndicator + organizationCode;
        String groupHome = organizationHome + this.fileSeparator + groupCode;
        PropertyUtils.addOrOverrideProperty(properties, organizationHomeProperty, organizationHome, this.propertyOverwriteMode);
        PropertyUtils.addOrOverrideProperty(properties, groupHomeProperty, groupHome, this.propertyOverwriteMode);
    }

    public Mode getPropertyOverwriteMode() {
        return this.propertyOverwriteMode;
    }

    public void setPropertyOverwriteMode(Mode propertyOverwriteMode) {
        this.propertyOverwriteMode = propertyOverwriteMode;
    }

    public String getUserHomeProperty() {
        return this.userHomeProperty;
    }

    public void setUserHomeProperty(String userHomeProperty) {
        this.userHomeProperty = userHomeProperty;
    }

    public String getFileSeparator() {
        return this.fileSeparator;
    }

    public void setFileSeparator(String fileSeparator) {
        this.fileSeparator = fileSeparator;
    }

    public String getHiddenDirectoryIndicator() {
        return this.hiddenDirectoryIndicator;
    }

    public void setHiddenDirectoryIndicator(String hiddenDirectoryIndicator) {
        this.hiddenDirectoryIndicator = hiddenDirectoryIndicator;
    }

    public String getOrganizationGroupId() {
        return this.organizationGroupId;
    }

    public void setOrganizationGroupId(String organizationGroupId) {
        this.organizationGroupId = organizationGroupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }
}

