/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.property.processor;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.kuali.common.util.Mode;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.property.ImmutableProperties;
import org.kuali.common.util.property.processor.PropertyProcessor;

public final class OverridingProcessor
implements PropertyProcessor {
    public static final int DEFAULT_INDENT = 2;
    public static final Mode DEFAULT_OVERRIDE_MODE = Mode.INFORM;
    public static final List<String> DEFAULT_INCLUDES = Collections.emptyList();
    public static final List<String> DEFAULT_EXCLUDES = Collections.emptyList();
    private final Mode overrideMode;
    private final Properties overrides;
    private final List<String> includes;
    private final List<String> excludes;
    private final int indent;

    public OverridingProcessor(Properties overrides) {
        this(overrides, DEFAULT_OVERRIDE_MODE, DEFAULT_INCLUDES, DEFAULT_EXCLUDES, 2);
    }

    public OverridingProcessor(Properties overrides, List<String> includes) {
        this(overrides, DEFAULT_OVERRIDE_MODE, includes, DEFAULT_EXCLUDES, 2);
    }

    public OverridingProcessor(Properties overrides, List<String> includes, List<String> excludes) {
        this(overrides, DEFAULT_OVERRIDE_MODE, includes, excludes, 2);
    }

    public OverridingProcessor(Properties overrides, Mode overrideMode, List<String> includes, List<String> excludes, int indent) {
        this.overrides = PropertyUtils.toImmutable(overrides);
        this.overrideMode = overrideMode;
        this.includes = ImmutableList.copyOf(includes);
        this.excludes = ImmutableList.copyOf(excludes);
        this.indent = indent;
        Builder.validate(this);
    }

    @Override
    public void process(Properties properties) {
        List<String> keys = PropertyUtils.getSortedKeys(this.overrides, this.includes, this.excludes);
        for (String key : keys) {
            String newValue = this.overrides.getProperty(key);
            PropertyUtils.addOrOverrideProperty(properties, key, newValue, this.overrideMode, this.indent);
        }
    }

    public Mode getOverrideMode() {
        return this.overrideMode;
    }

    public Properties getOverrides() {
        return this.overrides;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public int getIndent() {
        return this.indent;
    }

    private OverridingProcessor(Builder builder) {
        this.overrideMode = builder.overrideMode;
        this.overrides = builder.overrides;
        this.includes = builder.includes;
        this.excludes = builder.excludes;
        this.indent = builder.indent;
    }

    public static Builder builder(Properties overrides) {
        return new Builder(overrides);
    }

    public static class Builder {
        private final Properties overrides;
        private Mode overrideMode = DEFAULT_OVERRIDE_MODE;
        private List<String> includes = ImmutableList.of();
        private List<String> excludes = ImmutableList.of();
        private int indent = 2;

        public Builder(Properties overrides) {
            this.overrides = ImmutableProperties.copyOf(overrides);
        }

        public Builder overrideMode(Mode overrideMode) {
            this.overrideMode = overrideMode;
            return this;
        }

        public Builder includes(List<String> includes) {
            this.includes = includes;
            return this;
        }

        public Builder excludes(List<String> excludes) {
            this.excludes = excludes;
            return this;
        }

        public Builder indent(int indent) {
            this.indent = indent;
            return this;
        }

        public OverridingProcessor build() {
            OverridingProcessor instance = new OverridingProcessor(this);
            Builder.validate(instance);
            return instance;
        }

        private static void validate(OverridingProcessor instance) {
            Preconditions.checkNotNull((Object)instance.overrides, (Object)"overrides cannot be null");
            Preconditions.checkArgument((instance.indent >= 0 ? 1 : 0) != 0, (Object)"indent cannot be negative");
            Preconditions.checkNotNull((Object)instance.includes, (Object)"includes cannot be null");
            Preconditions.checkNotNull((Object)instance.excludes, (Object)"excludes cannot be null");
            Preconditions.checkNotNull((Object)((Object)instance.overrideMode), (Object)"overrideMode cannot be null");
        }
    }
}

