/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.property.processor;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.kuali.common.util.Mode;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.Str;
import org.kuali.common.util.property.Constants;
import org.kuali.common.util.property.processor.PropertyProcessor;

public class PathProcessor
implements PropertyProcessor {
    Mode propertyOverwriteMode = Constants.DEFAULT_PROPERTY_OVERWRITE_MODE;
    String suffix = "path";
    List<String> includes;
    List<String> excludes;

    public PathProcessor() {
        this(Collections.emptyList());
    }

    public PathProcessor(String include) {
        this(Collections.singletonList(include));
    }

    public PathProcessor(List<String> includes) {
        this.includes = includes;
    }

    @Override
    public void process(Properties properties) {
        List<String> keys = PropertyUtils.getSortedKeys(properties, this.includes, this.excludes);
        for (String key : keys) {
            String oldValue = properties.getProperty(key);
            String newValue = Str.getPath(oldValue);
            String newKey = key + "." + this.suffix;
            PropertyUtils.addOrOverrideProperty(properties, newKey, newValue, this.propertyOverwriteMode);
        }
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public Mode getPropertyOverwriteMode() {
        return this.propertyOverwriteMode;
    }

    public void setPropertyOverwriteMode(Mode propertyOverwriteMode) {
        this.propertyOverwriteMode = propertyOverwriteMode;
    }
}

