/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.property.processor;

import java.util.Properties;
import org.kuali.common.util.Assert;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.log.LoggerUtils;
import org.kuali.common.util.property.processor.PropertyProcessor;
import org.slf4j.Logger;
import org.springframework.util.PropertyPlaceholderHelper;

public class ResolvingProcessor
implements PropertyProcessor {
    private static final Logger logger = LoggerUtils.make();
    public static final boolean DEFAULT_IGNORE_UNRESOLVABLE = false;
    public static final String DEFAULT_RESOLVE_KEY = "properties.resolve";
    private final boolean ignoreUnresolvable;
    private final String resolveKey;
    private final PropertyPlaceholderHelper helper;

    public ResolvingProcessor() {
        this(false, DEFAULT_RESOLVE_KEY);
    }

    public ResolvingProcessor(boolean ignoreUnresolvable, String resolveKey) {
        Assert.noBlanks(resolveKey);
        this.ignoreUnresolvable = ignoreUnresolvable;
        this.resolveKey = resolveKey;
        this.helper = new PropertyPlaceholderHelper("${", "}", ":", ignoreUnresolvable);
    }

    @Override
    public void process(Properties properties) {
        boolean resolve = PropertyUtils.getBoolean(this.resolveKey, properties, true);
        if (resolve) {
            logger.info("Performing placeholder resolution on {} properties", (Object)properties.size());
            PropertyUtils.resolve(properties, this.helper);
        } else {
            logger.info("Skipping placeholder resolution for {} properties", (Object)properties.size());
        }
    }

    public boolean isIgnoreUnresolvable() {
        return this.ignoreUnresolvable;
    }

    public String getResolveKey() {
        return this.resolveKey;
    }

    public PropertyPlaceholderHelper getHelper() {
        return this.helper;
    }
}

