/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.property.processor;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.common.util.Mode;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.Version;
import org.kuali.common.util.VersionUtils;
import org.kuali.common.util.property.Constants;
import org.kuali.common.util.property.processor.PropertyProcessor;

public class VersionProcessor
implements PropertyProcessor {
    public static final String SANITIZED_QUALIFIER = "qualifier.sanitized";
    public static final String SANITIZED_VERSION_KEY = "project.version.sanitized";
    String majorSuffix = "major";
    String minorSuffix = "minor";
    String incrementalSuffix = "incremental";
    String qualifierSuffix = "qualifier";
    String sanitizedQualifierSuffix = "qualifier.sanitized";
    String trimmedSuffix = "trimmed";
    String snapshotSuffix = "snapshot";
    boolean alwaysAddOrOverride;
    List<String> includes;
    List<String> excludes;
    Mode propertyOverwriteMode = Constants.DEFAULT_PROPERTY_OVERWRITE_MODE;

    public VersionProcessor() {
        this(Collections.emptyList());
    }

    public VersionProcessor(String include) {
        this(Collections.singletonList(include));
    }

    public VersionProcessor(List<String> includes) {
        this(includes, false);
    }

    public VersionProcessor(List<String> includes, boolean alwaysAddOrOverride) {
        this.includes = includes;
        this.alwaysAddOrOverride = alwaysAddOrOverride;
    }

    @Override
    public void process(Properties properties) {
        List<String> keys = PropertyUtils.getSortedKeys(properties, this.includes, this.excludes);
        Properties versionProperties = new Properties();
        for (String key : keys) {
            String version = properties.getProperty(key);
            Version v = VersionUtils.getVersion(version);
            versionProperties.putAll((Map<?, ?>)this.getVersionProperties(key, v));
        }
        List<String> versionKeys = PropertyUtils.getSortedKeys(versionProperties);
        for (String versionKey : versionKeys) {
            String versionValue = versionProperties.getProperty(versionKey);
            if (this.alwaysAddOrOverride) {
                properties.setProperty(versionKey, versionValue);
                continue;
            }
            PropertyUtils.addOrOverrideProperty(properties, versionKey, versionValue, this.propertyOverwriteMode);
        }
    }

    public Properties getVersionProperties(String key, Version v) {
        String newKey;
        Properties properties = new Properties();
        if (v.getMajor() != null) {
            newKey = key + "." + this.majorSuffix;
            properties.setProperty(newKey, v.getMajor());
        }
        if (v.getMinor() != null) {
            newKey = key + "." + this.minorSuffix;
            properties.setProperty(newKey, v.getMinor());
        }
        if (v.getIncremental() != null) {
            newKey = key + "." + this.incrementalSuffix;
            properties.setProperty(newKey, v.getIncremental());
        }
        if (v.getQualifier() != null) {
            newKey = key + "." + this.qualifierSuffix;
            properties.setProperty(newKey, v.getQualifier());
            String sanitizedKey = key + "." + this.sanitizedQualifierSuffix;
            String sanitizedValue = VersionUtils.getSanitizedQualifier(v.getQualifier());
            properties.setProperty(sanitizedKey, sanitizedValue);
        }
        if (v.getTrimmed() != null) {
            newKey = key + "." + this.trimmedSuffix;
            properties.setProperty(newKey, v.getTrimmed());
        }
        newKey = key + "." + this.snapshotSuffix;
        properties.setProperty(newKey, Boolean.toString(v.isSnapshot()));
        properties.setProperty(SANITIZED_VERSION_KEY, VersionUtils.asSanitizedString(v));
        return properties;
    }

    public String getMajorSuffix() {
        return this.majorSuffix;
    }

    public void setMajorSuffix(String majorSuffix) {
        this.majorSuffix = majorSuffix;
    }

    public String getMinorSuffix() {
        return this.minorSuffix;
    }

    public void setMinorSuffix(String minorSuffix) {
        this.minorSuffix = minorSuffix;
    }

    public String getIncrementalSuffix() {
        return this.incrementalSuffix;
    }

    public void setIncrementalSuffix(String incrementalSuffix) {
        this.incrementalSuffix = incrementalSuffix;
    }

    public String getQualifierSuffix() {
        return this.qualifierSuffix;
    }

    public void setQualifierSuffix(String qualifierSuffix) {
        this.qualifierSuffix = qualifierSuffix;
    }

    public String getTrimmedSuffix() {
        return this.trimmedSuffix;
    }

    public void setTrimmedSuffix(String trimmedSuffix) {
        this.trimmedSuffix = trimmedSuffix;
    }

    public String getSnapshotSuffix() {
        return this.snapshotSuffix;
    }

    public void setSnapshotSuffix(String snapshotSuffix) {
        this.snapshotSuffix = snapshotSuffix;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public Mode getPropertyOverwriteMode() {
        return this.propertyOverwriteMode;
    }

    public void setPropertyOverwriteMode(Mode propertyOverwriteMode) {
        this.propertyOverwriteMode = propertyOverwriteMode;
    }

    public boolean isAlwaysAddOrOverride() {
        return this.alwaysAddOrOverride;
    }

    public void setAlwaysAddOrOverride(boolean alwaysAddOrOverride) {
        this.alwaysAddOrOverride = alwaysAddOrOverride;
    }

    public String getSanitizedQualifierSuffix() {
        return this.sanitizedQualifierSuffix;
    }

    public void setSanitizedQualifierSuffix(String sanitizedQualifierSuffix) {
        this.sanitizedQualifierSuffix = sanitizedQualifierSuffix;
    }
}

