/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.scm;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.scm.ScmService;
import org.kuali.common.util.service.DefaultExecService;

public class SvnService
extends DefaultExecService
implements ScmService {
    private static final String SVN = "svn";

    @Override
    public void version() {
        this.executeAndValidate(SVN, Arrays.asList("--version"));
    }

    @Override
    public void add(List<File> paths) {
        if (CollectionUtils.isEmpty(paths)) {
            return;
        }
        String command = "add";
        List<String> cpaths = LocationUtils.getCanonicalPaths(paths);
        List<String> options = Arrays.asList("--force", "--parents", "--depth", "infinity");
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(command);
        arguments.addAll(cpaths);
        arguments.addAll(options);
        this.executeAndValidate(SVN, arguments);
    }

    @Override
    public void delete(List<File> paths) {
        if (CollectionUtils.isEmpty(paths)) {
            return;
        }
        String command = "delete";
        List<String> cpaths = LocationUtils.getCanonicalPaths(paths);
        List<String> options = Arrays.asList("--force");
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(command);
        arguments.addAll(cpaths);
        arguments.addAll(options);
        this.executeAndValidate(SVN, arguments);
    }

    @Override
    public void commit(List<File> paths, String message) {
        if (CollectionUtils.isEmpty(paths)) {
            return;
        }
        Assert.noBlanks("Commit message is blank", message);
        String command = "commit";
        List<String> cpaths = LocationUtils.getCanonicalPaths(paths);
        List<String> options = Arrays.asList("--depth", "infinity", "--message", message);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(command);
        arguments.addAll(cpaths);
        arguments.addAll(options);
        this.executeAndValidate(SVN, arguments);
    }
}

