/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.scm;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.SyncResult;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.file.DirRequest;
import org.kuali.common.util.scm.ScmRequest;
import org.kuali.common.util.scm.ScmService;
import org.kuali.common.util.sync.DefaultSyncService;
import org.kuali.common.util.sync.SyncService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateScmExecutable
implements Executable {
    private static final Logger logger = LoggerFactory.getLogger(UpdateScmExecutable.class);
    public static final boolean DEFAULT_SKIP_VALUE = false;
    public static final boolean DEFAULT_SKIP_COMMIT_VALUE = true;
    boolean skip = false;
    boolean skipCommit = true;
    ScmService scmService;
    SyncService syncService = new DefaultSyncService();
    List<DirRequest> requests;
    String message = "Automated update";
    List<File> commitPaths;

    @Override
    public void execute() {
        if (this.skip) {
            return;
        }
        Assert.notNull((Object)this.scmService);
        Assert.notNull((Object)this.syncService);
        List<SyncResult> results = this.syncService.sync(this.requests);
        ScmRequest request = this.getScmRequest(this.requests, results, this.commitPaths);
        logger.info("---------- Sync results ----------");
        logger.info("Files added - {}", (Object)request.getAdds().size());
        logger.info("Files updated - {}", (Object)request.getUpdates().size());
        logger.info("Files deleted - {}", (Object)request.getDeletes().size());
        logger.info("---------- Sync results ----------");
        if (this.skipCommit) {
            logger.info("Skipping SCM commit");
        } else {
            this.scmService.add(request.getAdds());
            this.scmService.delete(request.getDeletes());
            this.scmService.commit(request.getCommits(), this.message);
        }
    }

    protected ScmRequest getScmRequest(List<DirRequest> requests, List<SyncResult> results, List<File> commitPaths) {
        ArrayList<File> adds = new ArrayList<File>();
        ArrayList<File> deletes = new ArrayList<File>();
        ArrayList<File> updates = new ArrayList<File>();
        for (SyncResult result : results) {
            adds.addAll(result.getAdds());
            deletes.addAll(result.getDeletes());
            updates.addAll(result.getUpdates());
        }
        ArrayList<File> commits = new ArrayList<File>(CollectionUtils.toEmptyList(commitPaths));
        for (DirRequest request : CollectionUtils.toEmptyList(requests)) {
            commits.add(request.getTargetDir());
        }
        ScmRequest scmRequest = new ScmRequest();
        scmRequest.setAdds(adds);
        scmRequest.setUpdates(updates);
        scmRequest.setDeletes(deletes);
        scmRequest.setCommits(commits);
        return scmRequest;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public boolean isSkipCommit() {
        return this.skipCommit;
    }

    public void setSkipCommit(boolean commitChanges) {
        this.skipCommit = commitChanges;
    }

    public ScmService getScmService() {
        return this.scmService;
    }

    public void setScmService(ScmService scmService) {
        this.scmService = scmService;
    }

    public SyncService getSyncService() {
        return this.syncService;
    }

    public void setSyncService(SyncService syncService) {
        this.syncService = syncService;
    }

    public List<DirRequest> getRequests() {
        return this.requests;
    }

    public void setRequests(List<DirRequest> requests) {
        this.requests = requests;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<File> getCommitPaths() {
        return this.commitPaths;
    }

    public void setCommitPaths(List<File> commitPaths) {
        this.commitPaths = commitPaths;
    }
}

