/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.secure;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

@Deprecated
public class SSHUtils {
    private static final Logger logger = LoggerFactory.getLogger(SSHUtils.class);
    private static final String FS = File.separator;
    private static final String IDENTITY_FILE = "IdentityFile";
    private static final String TILDE = "~";
    private static final String USER_HOME = FileUtils.getUserDirectoryPath();
    private static final String SSHDIR = USER_HOME + FS + ".ssh";
    private static final String IDENTITY = SSHDIR + FS + "identity";
    private static final String ID_DSA = SSHDIR + FS + "id_dsa";
    private static final String ID_RSA = SSHDIR + FS + "id_rsa";
    private static final String ID_ECDSA = SSHDIR + FS + "id_ecdsa";
    private static final int PORT_NUMBER_LOWEST = 1;
    private static final int PORT_NUMBER_HIGHEST = 65535;
    public static final String STRICT_HOST_KEY_CHECKING = "StrictHostKeyChecking";
    public static final String NO = "no";
    public static final List<String> PRIVATE_KEY_DEFAULTS = Arrays.asList(IDENTITY, ID_DSA, ID_RSA, ID_ECDSA);
    public static final File DEFAULT_CONFIG_FILE = new File(SSHDIR + FS + "config");
    public static final int DEFAULT_PORT = 22;
    public static final File DEFAULT_KNOWN_HOSTS = new File(SSHDIR + FS + "known_hosts");

    public static final boolean isValidPort(int port) {
        return port >= 1 && port <= 65535;
    }

    public static final void addPort(List<String> args, String portOption, int port, int defaultPort) {
        if (port != defaultPort) {
            Assert.isTrue((boolean)SSHUtils.isValidPort(port));
            logger.debug("port={}", (Object)port);
            args.add(portOption);
            args.add(Integer.toString(port));
        }
    }

    public static final void addOptions(List<String> args, Properties options) {
        if (options == null) {
            return;
        }
        List<String> keys = PropertyUtils.getSortedKeys(options);
        for (String key : keys) {
            String value = options.getProperty(key);
            logger.debug("Adding option [-o {}={}]", (Object)key, (Object)value);
            args.add("-o");
            args.add(key + "=" + value);
        }
    }

    public static final void addConfigFile(List<String> args, File configFile, File defaultConfigFile) {
        String configFilePath;
        if (configFile == null) {
            return;
        }
        String defaultPath = LocationUtils.getCanonicalPath(defaultConfigFile);
        if (!StringUtils.equals((CharSequence)defaultPath, (CharSequence)(configFilePath = LocationUtils.getCanonicalPath(configFile)))) {
            logger.debug("SSH config=[{}]", (Object)configFilePath);
            args.add("-F");
            args.add(configFilePath);
        }
    }

    public static final void addIdentityFile(List<String> args, File identityFile) {
        if (identityFile != null) {
            String path = LocationUtils.getCanonicalPath(identityFile);
            logger.debug("Private key=[{}]", (Object)path);
            args.add("-i");
            args.add(path);
        }
    }

    public static final List<File> getPrivateKeys(File config) {
        List<String> paths = SSHUtils.getFilenames(config);
        return SSHUtils.getExistingAndReadable(paths);
    }

    public static final List<File> getDefaultPrivateKeys() {
        return SSHUtils.getPrivateKeys(DEFAULT_CONFIG_FILE);
    }

    public static final Properties getDefaultOptions() {
        Properties options = new Properties();
        options.setProperty(STRICT_HOST_KEY_CHECKING, NO);
        return options;
    }

    public static final List<File> getExistingAndReadable(List<String> filenames) {
        ArrayList<File> files = new ArrayList<File>();
        for (String filename : filenames) {
            File file = new File(filename);
            if (!file.exists() || !file.canRead()) continue;
            files.add(file);
        }
        return files;
    }

    public static final List<String> getFilenames(File config) {
        if (config.exists() && config.canRead()) {
            List<String> lines = LocationUtils.readLines(config);
            List<String> identityFileLines = SSHUtils.getIdentityFileLines(lines);
            return SSHUtils.getFilenames(identityFileLines);
        }
        return Collections.emptyList();
    }

    public static final List<String> getIdentityFileLines(List<String> lines) {
        ArrayList<String> identityFileLines = new ArrayList<String>();
        for (String line : lines) {
            String trimmed = StringUtils.trim((String)line);
            if (!StringUtils.startsWith((CharSequence)trimmed, (CharSequence)IDENTITY_FILE)) continue;
            identityFileLines.add(trimmed);
        }
        return identityFileLines;
    }

    public static final List<String> getFilenames(List<String> identityFileLines) {
        ArrayList<String> filenames = new ArrayList<String>();
        for (String identityFileLine : identityFileLines) {
            String originalFilename = StringUtils.substring((String)identityFileLine, (int)IDENTITY_FILE.length());
            String resolvedFilename = StringUtils.replace((String)originalFilename, (String)TILDE, (String)USER_HOME);
            String trimmed = StringUtils.trim((String)resolvedFilename);
            filenames.add(trimmed);
        }
        return filenames;
    }
}

