/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.plexus.util.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.Mode;
import org.kuali.common.util.Project;
import org.kuali.common.util.ProjectContext;
import org.kuali.common.util.ProjectUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.ReflectionUtils;
import org.kuali.common.util.config.supplier.PropertiesSupplier;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.execute.SpringExecutable;
import org.kuali.common.util.log.LoggerLevel;
import org.kuali.common.util.log.LoggerUtils;
import org.kuali.common.util.nullify.NullUtils;
import org.kuali.common.util.property.ProjectProperties;
import org.kuali.common.util.property.PropertiesContext;
import org.kuali.common.util.service.DefaultSpringService;
import org.kuali.common.util.service.PropertySourceContext;
import org.kuali.common.util.service.SpringContext;
import org.kuali.common.util.service.SpringService;
import org.kuali.common.util.spring.ConfigUtils;
import org.kuali.common.util.spring.PropertySourceConversionResult;
import org.kuali.common.util.spring.PropertySourceUtils;
import org.kuali.common.util.spring.env.EnvironmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class SpringUtils {
    private static final Logger logger = LoggerFactory.getLogger(SpringUtils.class);
    private static final String GLOBAL_SPRING_PROPERTY_SOURCE_NAME = "springPropertySource";

    public static <T> T getProperty(Optional<EnvironmentService> env, List<String> keys, Class<T> type, T provided) {
        return (T)SpringUtils.getProperty(env, keys, type, Optional.fromNullable(provided)).orNull();
    }

    public static <T> Optional<T> getProperty(Optional<EnvironmentService> env, String key, Class<T> type, Optional<T> provided) {
        return SpringUtils.getProperty(env, (List<String>)ImmutableList.of((Object)key), type, provided);
    }

    public static <T> Optional<T> getProperty(Optional<EnvironmentService> env, List<String> keys, Class<T> type, Optional<T> provided) {
        if (!env.isPresent()) {
            return provided;
        }
        for (String key : keys) {
            Optional<T> value = SpringUtils.getOptionalProperty((EnvironmentService)env.get(), key, type);
            if (!value.isPresent()) continue;
            return value;
        }
        return provided;
    }

    public static Optional<String> getString(Optional<EnvironmentService> env, List<String> keys, Optional<String> provided) {
        if (!env.isPresent()) {
            return provided;
        }
        for (String key : keys) {
            Optional<String> value = SpringUtils.getOptionalString((EnvironmentService)env.get(), key);
            if (!value.isPresent()) continue;
            return value;
        }
        return provided;
    }

    public static String getString(EnvironmentService env, List<String> keys) {
        return (String)SpringUtils.getString((Optional<EnvironmentService>)Optional.of((Object)env), keys, (Optional<String>)Optional.absent()).get();
    }

    public static Optional<String> getString(EnvironmentService env, List<String> keys, Optional<String> provided) {
        return SpringUtils.getString((Optional<EnvironmentService>)Optional.of((Object)env), keys, provided);
    }

    public static Optional<String> getString(EnvironmentService env, String key, Optional<String> provided) {
        return SpringUtils.getString(env, (List<String>)ImmutableList.of((Object)key), provided);
    }

    public static Optional<Boolean> getBoolean(EnvironmentService env, String key, Optional<Boolean> provided) {
        Optional<Boolean> value = SpringUtils.getOptionalBoolean(env, key);
        if (value.isPresent()) {
            return value;
        }
        return provided;
    }

    public static Optional<Integer> getInteger(EnvironmentService env, String key, Optional<Integer> provided) {
        Optional<Integer> value = SpringUtils.getOptionalInteger(env, key);
        if (value.isPresent()) {
            return value;
        }
        return provided;
    }

    public static Optional<Integer> getOptionalInteger(EnvironmentService env, String key) {
        if (!env.containsProperty(key)) {
            return Optional.absent();
        }
        return Optional.of((Object)env.getInteger(key));
    }

    public static <T> Optional<T> getOptionalProperty(EnvironmentService env, List<String> keys, Class<T> type) {
        for (String key : keys) {
            Optional<T> value = SpringUtils.getOptionalProperty(env, key, type);
            if (!value.isPresent()) continue;
            return value;
        }
        return Optional.absent();
    }

    public static <T> Optional<T> getOptionalProperty(EnvironmentService env, String key, Class<T> type) {
        if (!env.containsProperty(key)) {
            return Optional.absent();
        }
        T value = env.getProperty(key, type);
        return Optional.of(value);
    }

    public static Optional<String> getOptionalString(EnvironmentService env, String key) {
        if (!env.containsProperty(key)) {
            return Optional.absent();
        }
        return NullUtils.toAbsent(env.getString(key));
    }

    public static Optional<Boolean> getOptionalBoolean(EnvironmentService env, String key) {
        if (!env.containsProperty(key)) {
            return Optional.absent();
        }
        return Optional.of((Object)env.getBoolean(key));
    }

    @Deprecated
    public static SpringContext getSpringContext(List<Class<?>> annotatedClasses, ProjectContext project, List<ProjectContext> others) {
        PropertySource<?> source = SpringUtils.getGlobalPropertySource(project, others);
        PropertySourceContext psc = new PropertySourceContext(source, true);
        SpringContext context = new SpringContext();
        context.setPropertySourceContext(psc);
        context.setAnnotatedClasses(annotatedClasses);
        return context;
    }

    @Deprecated
    public static SpringContext getSpringContext(Class<?> annotatedClass, ProjectContext project, List<ProjectContext> others) {
        return SpringUtils.getSpringContext(CollectionUtils.asList(annotatedClass), project, others);
    }

    @Deprecated
    public static PropertySource<?> getGlobalPropertySource(ProjectContext project, ProjectContext other) {
        return SpringUtils.getGlobalPropertySource(project, Arrays.asList(other));
    }

    @Deprecated
    public static PropertySource<?> getGlobalPropertySource(ProjectContext project, List<ProjectContext> others) {
        return SpringUtils.getGlobalPropertySource(project, others, null);
    }

    @Deprecated
    public static PropertySource<?> getGlobalPropertySource(ProjectContext project, Mode missingLocationsMode) {
        return SpringUtils.getGlobalPropertySource(project, missingLocationsMode, Collections.<ProjectContext>emptyList());
    }

    @Deprecated
    public static PropertySource<?> getGlobalPropertySource(ProjectContext project, Mode missingLocationsMode, ProjectContext ... others) {
        return SpringUtils.getGlobalPropertySource(project, missingLocationsMode, Arrays.asList(others));
    }

    @Deprecated
    public static PropertySource<?> getGlobalPropertySource(ProjectContext project, Mode missingLocationsMode, List<ProjectContext> others) {
        ProjectProperties pp = ConfigUtils.getProjectProperties(project);
        pp.getPropertiesContext().setMissingLocationsMode(missingLocationsMode);
        return SpringUtils.getGlobalPropertySource(pp, others, null);
    }

    @Deprecated
    public static PropertySource<?> getGlobalPropertySource(ProjectProperties projectProperties, List<ProjectContext> others, Properties properties) {
        ConfigUtils.combine(projectProperties, properties);
        List<ProjectProperties> otherProjectProperties = ConfigUtils.getProjectProperties(others);
        return SpringUtils.getGlobalPropertySource(projectProperties, otherProjectProperties);
    }

    @Deprecated
    public static PropertySource<?> getGlobalPropertySource(ProjectContext project, List<ProjectContext> others, Properties properties) {
        ProjectProperties projectProperties = ConfigUtils.getProjectProperties(project, properties);
        List<ProjectProperties> otherProjectProperties = ConfigUtils.getProjectProperties(others);
        return SpringUtils.getGlobalPropertySource(projectProperties, otherProjectProperties);
    }

    @Deprecated
    public static PropertySource<?> getGlobalPropertySource(ProjectProperties project) {
        return SpringUtils.getGlobalPropertySource(project, null);
    }

    @Deprecated
    public static PropertySource<?> getGlobalPropertySource(ProjectProperties project, List<ProjectProperties> others) {
        ArrayList<ProjectProperties> list = new ArrayList<ProjectProperties>();
        list.add(project);
        if (!CollectionUtils.isEmpty(others)) {
            list.addAll(others);
            list.add(project);
        }
        return SpringUtils.getGlobalPropertySource(GLOBAL_SPRING_PROPERTY_SOURCE_NAME, list);
    }

    public static List<String> getIncludes(Environment env, String key, String defaultValue) {
        String includes = SpringUtils.getProperty(env, key, defaultValue);
        if (NullUtils.isNull(includes) || StringUtils.equals((String)includes, (String)"*")) {
            return new ArrayList<String>();
        }
        return CollectionUtils.getTrimmedListFromCSV(includes);
    }

    public static List<String> getIncludes(Environment env, String key) {
        return SpringUtils.getIncludes(env, key, null);
    }

    public static List<String> getExcludes(Environment env, String key, String defaultValue) {
        String excludes = SpringUtils.getProperty(env, key, defaultValue);
        if (NullUtils.isNullOrNone(excludes)) {
            return new ArrayList<String>();
        }
        return CollectionUtils.getTrimmedListFromCSV(excludes);
    }

    public static List<String> getExcludes(Environment env, String key) {
        return SpringUtils.getExcludes(env, key, null);
    }

    public static <T> T getInstance(Environment env, String key, Class<T> defaultValue) {
        String className = SpringUtils.getProperty(env, key, defaultValue.getCanonicalName());
        return ReflectionUtils.newInstance(className);
    }

    public static <T> T getInstance(Environment env, String key) {
        String className = SpringUtils.getProperty(env, key, null);
        return ReflectionUtils.newInstance(className);
    }

    public static List<String> getListFromCSV(Environment env, String key, String defaultValue) {
        String csv = SpringUtils.getProperty(env, key, defaultValue);
        return CollectionUtils.getTrimmedListFromCSV(csv);
    }

    public static List<String> getListFromCSV(Environment env, String key) {
        String csv = SpringUtils.getProperty(env, key);
        return CollectionUtils.getTrimmedListFromCSV(csv);
    }

    public static List<String> getNoneSensitiveListFromCSV(Environment env, String key) {
        String csv = SpringUtils.getProperty(env, key);
        return CollectionUtils.getNoneSensitiveListFromCSV(csv);
    }

    public static List<String> getNoneSensitiveListFromCSV(EnvironmentService env, String key, String defaultValue) {
        String csv = env.getString(key, defaultValue);
        return CollectionUtils.getNoneSensitiveListFromCSV(csv);
    }

    public static List<String> getNoneSensitiveListFromCSV(EnvironmentService env, String key) {
        return SpringUtils.getNoneSensitiveListFromCSV(env, key, null);
    }

    public static List<String> getStrings(EnvironmentService env, String key, List<String> defaults) {
        if (env.containsProperty(key)) {
            return SpringUtils.getNoneSensitiveListFromCSV(env, key);
        }
        return defaults;
    }

    public static Optional<List<String>> getOptionalStrings(EnvironmentService env, List<String> keys) {
        for (String key : keys) {
            if (!env.containsProperty(key)) continue;
            return Optional.of(SpringUtils.getNoneSensitiveListFromCSV(env, key));
        }
        return Optional.absent();
    }

    public static List<String> getNoneSensitiveListFromCSV(Environment env, String key, String defaultValue) {
        String csv = SpringUtils.getProperty(env, key, defaultValue);
        return CollectionUtils.getNoneSensitiveListFromCSV(csv);
    }

    @Deprecated
    public static List<PropertySource<?>> getPropertySources(SpringService service, Class<?> annotatedClass, String propertiesBeanName, Properties properties) {
        return SpringUtils.getPropertySources(annotatedClass, propertiesBeanName, properties);
    }

    @Deprecated
    public static PropertySource<?> getSinglePropertySource(Class<?> annotatedClass) {
        return SpringUtils.getSinglePropertySource(annotatedClass, null, null);
    }

    @Deprecated
    public static PropertySource<?> getSinglePropertySource(Class<?> annotatedClass, String propertiesBeanName, Properties properties) {
        List<PropertySource<?>> sources = SpringUtils.getPropertySources(annotatedClass, propertiesBeanName, properties);
        Assert.isTrue((sources.size() == 1 ? 1 : 0) != 0, (String)"Must be exactly one PropertySource registered in the context");
        return sources.get(0);
    }

    @Deprecated
    public static List<PropertySource<?>> getPropertySources(Class<?> annotatedClass, String propertiesBeanName, Properties properties) {
        return SpringUtils.getPropertySources(annotatedClass, propertiesBeanName, properties, null, null);
    }

    public static void setupProfiles(ConfigurableApplicationContext ctx, List<String> activeProfiles, List<String> defaultProfiles) {
        ConfigurableEnvironment env;
        if (!CollectionUtils.isEmpty(activeProfiles)) {
            env = ctx.getEnvironment();
            env.setActiveProfiles(CollectionUtils.toStringArray(activeProfiles));
        }
        if (!CollectionUtils.isEmpty(defaultProfiles)) {
            env = ctx.getEnvironment();
            env.setDefaultProfiles(CollectionUtils.toStringArray(defaultProfiles));
        }
    }

    @Deprecated
    public static List<PropertySource<?>> getPropertySources(Class<?> annotatedClass, String propertiesBeanName, Properties properties, List<String> activeProfiles, List<String> defaultProfiles) {
        ConfigurableApplicationContext parent = null;
        parent = properties == null ? SpringUtils.getConfigurableApplicationContext() : SpringUtils.getContextWithPreRegisteredBean(propertiesBeanName, properties);
        AnnotationConfigApplicationContext child = new AnnotationConfigApplicationContext();
        child.setParent((ApplicationContext)parent);
        SpringUtils.setupProfiles((ConfigurableApplicationContext)child, activeProfiles, defaultProfiles);
        child.register(new Class[]{annotatedClass});
        child.refresh();
        return SpringUtils.getPropertySources((ConfigurableApplicationContext)child);
    }

    @Deprecated
    public static List<PropertySource<?>> getPropertySources(SpringService service, String location, String mavenPropertiesBeanName, Properties mavenProperties) {
        return SpringUtils.getPropertySources(location, mavenPropertiesBeanName, mavenProperties);
    }

    @Deprecated
    public static List<PropertySource<?>> getPropertySources(String location, String propertiesBeanName, Properties properties) {
        return SpringUtils.getPropertySources(location, propertiesBeanName, properties, null, null);
    }

    @Deprecated
    public static List<PropertySource<?>> getPropertySources(String location, String propertiesBeanName, Properties properties, List<String> activeProfiles, List<String> defaultProfiles) {
        String[] locationsArray = new String[]{location};
        ConfigurableApplicationContext parent = SpringUtils.getContextWithPreRegisteredBean(propertiesBeanName, properties);
        ClassPathXmlApplicationContext child = new ClassPathXmlApplicationContext(locationsArray, false, (ApplicationContext)parent);
        SpringUtils.setupProfiles((ConfigurableApplicationContext)child, activeProfiles, defaultProfiles);
        child.refresh();
        return SpringUtils.getPropertySources((ConfigurableApplicationContext)child);
    }

    @Deprecated
    public static Executable getSpringExecutable(Environment env, boolean skip, PropertySource<?> ps, List<Class<?>> annotatedClasses) {
        PropertySourceContext psc = new PropertySourceContext(ps, true);
        SpringContext context = new SpringContext();
        context.setAnnotatedClasses(annotatedClasses);
        context.setPropertySourceContext(psc);
        SpringExecutable se = new SpringExecutable();
        se.setService(new DefaultSpringService());
        se.setContext(context);
        se.setSkip(skip);
        return se;
    }

    public static int getInteger(Environment env, String key) {
        String value = SpringUtils.getProperty(env, key);
        return Integer.parseInt(value);
    }

    public static int getInteger(Environment env, String key, int defaultValue) {
        String value = SpringUtils.getProperty(env, key, Integer.toString(defaultValue));
        return Integer.parseInt(value);
    }

    public static long getLong(Environment env, String key) {
        String value = SpringUtils.getProperty(env, key);
        return Long.parseLong(value);
    }

    public static long getLong(Environment env, String key, long defaultValue) {
        String value = SpringUtils.getProperty(env, key, Long.toString(defaultValue));
        return Long.parseLong(value);
    }

    public static double getDouble(Environment env, String key) {
        String value = SpringUtils.getProperty(env, key);
        return Double.parseDouble(value);
    }

    public static double getDouble(Environment env, String key, double defaultValue) {
        String value = SpringUtils.getProperty(env, key, Double.toString(defaultValue));
        return Double.parseDouble(value);
    }

    public static long getMillis(EnvironmentService env, String key, String defaultValue) {
        String value = env.getString(key, defaultValue);
        return FormatUtils.getMillis(value);
    }

    public static Optional<Integer> getMillisAsInt(EnvironmentService env, String key, Optional<Integer> provided) {
        if (env.containsProperty(key)) {
            String defaultValue = FormatUtils.getTime(((Integer)provided.get()).intValue());
            Long millis = SpringUtils.getMillis(env, key, defaultValue);
            return Optional.of((Object)millis.intValue());
        }
        return provided;
    }

    public static int getMillisAsInt(EnvironmentService env, String key, String defaultValue) {
        return new Long(SpringUtils.getMillis(env, key, defaultValue)).intValue();
    }

    public static int getMillisAsInt(EnvironmentService env, String key, int defaultValue) {
        return SpringUtils.getMillisAsInt(env, key, FormatUtils.getTime(defaultValue));
    }

    public static long getMillis(Environment env, String key, String defaultValue) {
        String value = SpringUtils.getProperty(env, key, defaultValue);
        return FormatUtils.getMillis(value);
    }

    public static int getBytesInteger(Environment env, String key, String defaultValue) {
        Long value = SpringUtils.getBytes(env, key, defaultValue);
        return SpringUtils.getValidatedIntValue(value);
    }

    public static int getBytesInteger(Environment env, String key) {
        Long value = SpringUtils.getBytes(env, key);
        return SpringUtils.getValidatedIntValue(value);
    }

    public static int getValidatedIntValue(Long value) {
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw new IllegalArgumentException(value + " is outside the range of an integer");
        }
        return value.intValue();
    }

    public static long getBytes(Environment env, String key, String defaultValue) {
        String value = SpringUtils.getProperty(env, key, defaultValue);
        return FormatUtils.getBytes(value);
    }

    public static long getBytes(Environment env, String key) {
        String value = SpringUtils.getProperty(env, key);
        return FormatUtils.getBytes(value);
    }

    public static File getFile(Environment env, String key) {
        String value = SpringUtils.getProperty(env, key);
        return new File(value);
    }

    public static List<File> getFilesFromCSV(Environment env, String key, String defaultValue) {
        List<String> strings = SpringUtils.getNoneSensitiveListFromCSV(env, key, defaultValue);
        ArrayList<File> files = new ArrayList<File>();
        for (String string : strings) {
            File file = new File(string);
            files.add(file);
        }
        return files;
    }

    public static List<File> getFilesFromCSV(Environment env, String key) {
        return SpringUtils.getFilesFromCSV(env, key, null);
    }

    public static File getFile(Environment env, String key, File defaultValue) {
        String value = SpringUtils.getProperty(env, key, LocationUtils.getCanonicalPath(defaultValue));
        return new File(value);
    }

    public static boolean getBoolean(Environment env, String key, boolean defaultValue) {
        String value = SpringUtils.getProperty(env, key, Boolean.toString(defaultValue));
        return Boolean.parseBoolean(value);
    }

    public static boolean getBoolean(Environment env, String key) {
        String value = SpringUtils.getProperty(env, key);
        return Boolean.parseBoolean(value);
    }

    @Deprecated
    public static PropertySource<?> getGlobalPropertySource(String name, List<ProjectProperties> pps) {
        Properties source = PropertyUtils.load(pps);
        Properties globalSource = PropertyUtils.getGlobalProperties(source);
        logger.debug("Before prepareContextProperties()");
        PropertyUtils.debug(globalSource);
        PropertyUtils.prepareContextProperties(globalSource);
        logger.debug("After prepareContextProperties()");
        PropertyUtils.debug(globalSource);
        return new PropertiesPropertySource(name, globalSource);
    }

    @Deprecated
    public static PropertySource<?> getGlobalPropertySource(Properties properties) {
        return new PropertiesPropertySource(GLOBAL_SPRING_PROPERTY_SOURCE_NAME, properties);
    }

    @Deprecated
    public static PropertySource<?> getGlobalPropertySource(List<String> locations, String encoding) {
        Properties loaded = PropertyUtils.load(locations, encoding);
        Properties global = PropertyUtils.getGlobalProperties(loaded);
        PropertyUtils.prepareContextProperties(global);
        return SpringUtils.getGlobalPropertySource(global);
    }

    @Deprecated
    public static SpringContext getSinglePropertySourceContext(ProjectContext context, String location) {
        PropertySource<?> source = SpringUtils.getGlobalPropertySource(context, location);
        return SpringUtils.getSinglePropertySourceContext(source);
    }

    @Deprecated
    public static SpringExecutable getSpringExecutable(ProjectContext project, String location, List<Class<?>> annotatedClasses) {
        SpringContext context = SpringUtils.getSinglePropertySourceContext(project, location);
        context.setAnnotatedClasses(annotatedClasses);
        SpringExecutable executable = new SpringExecutable();
        executable.setContext(context);
        return executable;
    }

    @Deprecated
    public static SpringExecutable getSpringExecutable(PropertiesSupplier supplier, Class<?> annotatedClass) {
        return SpringUtils.getSpringExecutable(supplier, CollectionUtils.asList(annotatedClass));
    }

    @Deprecated
    public static SpringExecutable getSpringExecutable(PropertiesSupplier supplier, List<Class<?>> annotatedClasses) {
        Properties properties = supplier.getProperties();
        PropertySource<?> source = SpringUtils.getGlobalPropertySource(properties);
        SpringContext context = SpringUtils.getSinglePropertySourceContext(source);
        context.setAnnotatedClasses(annotatedClasses);
        return new SpringExecutable(context);
    }

    @Deprecated
    public static SpringExecutable getSpringExecutable(PropertySource<?> source, Class<?> annotatedClass) {
        SpringContext context = SpringUtils.getSinglePropertySourceContext(source);
        context.setAnnotatedClasses(CollectionUtils.asList(annotatedClass));
        return new SpringExecutable(context);
    }

    @Deprecated
    public static SpringExecutable getSpringExecutable(ProjectContext project, String location, Class<?> annotatedClass) {
        return SpringUtils.getSpringExecutable(project, location, CollectionUtils.asList(annotatedClass));
    }

    @Deprecated
    public static SpringExecutable getSpringExecutable(Class<?> annotatedClass, String location, ProjectContext ... projects) {
        List<ProjectProperties> list = ConfigUtils.getProjectProperties(projects);
        ProjectProperties last = list.get(list.size() - 1);
        PropertiesContext pc = last.getPropertiesContext();
        if (!StringUtils.isBlank((String)location)) {
            ArrayList<String> locations = new ArrayList<String>(CollectionUtils.toEmptyList(pc.getLocations()));
            locations.add(location);
            pc.setLocations(locations);
        }
        PropertySource<?> source = SpringUtils.getGlobalPropertySource(GLOBAL_SPRING_PROPERTY_SOURCE_NAME, list);
        SpringContext context = SpringUtils.getSinglePropertySourceContext(source);
        context.setAnnotatedClasses(CollectionUtils.asList(annotatedClass));
        return new SpringExecutable(context);
    }

    @Deprecated
    public static SpringContext getSinglePropertySourceContext(List<String> locations, String encoding) {
        PropertySource<?> source = SpringUtils.getGlobalPropertySource(locations, encoding);
        return SpringUtils.getSinglePropertySourceContext(source);
    }

    @Deprecated
    public static SpringContext getSinglePropertySourceContext(PropertySource<?> source) {
        PropertySourceContext psc = new PropertySourceContext(source, true);
        SpringContext context = new SpringContext();
        context.setPropertySourceContext(psc);
        return context;
    }

    @Deprecated
    public static PropertySource<?> getGlobalPropertySource(ProjectContext context, String ... locations) {
        ProjectProperties pp = ProjectUtils.getProjectProperties(context);
        PropertiesContext pc = pp.getPropertiesContext();
        List<String> existingLocations = CollectionUtils.toEmptyList(pc.getLocations());
        if (locations != null) {
            for (String location : locations) {
                existingLocations.add(location);
            }
        }
        pc.setLocations(existingLocations);
        return SpringUtils.getGlobalPropertySource(pp);
    }

    @Deprecated
    public static PropertySource<?> getPropertySource(String name, List<ProjectProperties> pps) {
        Properties source = PropertyUtils.load(pps);
        PropertyUtils.prepareContextProperties(source);
        return new PropertiesPropertySource(name, source);
    }

    @Deprecated
    public static String getDefaultPropertyContextLocation(String gav) {
        Assert.hasText((String)gav, (String)"gav has no text");
        Project p = ProjectUtils.getProject(gav);
        return ProjectUtils.getClassPathPrefix(p) + "/properties-context.xml";
    }

    @Deprecated
    public static void validateExists(List<String> locations) {
        LocationUtils.validateExists(locations);
    }

    public static AbstractApplicationContext getContextWithPreRegisteredBeans(String id, String displayName, Map<String, ?> beans) {
        GenericXmlApplicationContext appContext = new GenericXmlApplicationContext();
        if (!StringUtils.isBlank((String)id)) {
            appContext.setId(id);
        }
        if (!StringUtils.isBlank((String)displayName)) {
            appContext.setDisplayName(displayName);
        }
        appContext.refresh();
        ConfigurableListableBeanFactory factory = appContext.getBeanFactory();
        for (String beanName : beans.keySet()) {
            Object bean = beans.get(beanName);
            logger.debug("Registering bean - [{}] -> [{}]", (Object)beanName, (Object)bean.getClass().getName());
            factory.registerSingleton(beanName, bean);
        }
        return appContext;
    }

    @Deprecated
    public static ConfigurableApplicationContext getContextWithPreRegisteredBeans(String id, String displayName, List<String> beanNames, List<Object> beans) {
        HashMap contextBeans = new HashMap();
        CollectionUtils.combine(contextBeans, beanNames, beans);
        return SpringUtils.getContextWithPreRegisteredBeans(id, displayName, contextBeans);
    }

    @Deprecated
    public static ConfigurableApplicationContext getContextWithPreRegisteredBeans(List<String> beanNames, List<Object> beans) {
        return SpringUtils.getContextWithPreRegisteredBeans(null, null, beanNames, beans);
    }

    @Deprecated
    public static ConfigurableApplicationContext getConfigurableApplicationContext() {
        return new GenericXmlApplicationContext();
    }

    public static void refreshQuietly(ConfigurableApplicationContext context) {
        if (context != null) {
            context.refresh();
        }
    }

    public static void closeQuietly(ConfigurableApplicationContext context) {
        if (context != null) {
            context.close();
        }
    }

    @Deprecated
    public static ConfigurableApplicationContext getContextWithPreRegisteredBean(String beanName, Object bean) {
        return SpringUtils.getContextWithPreRegisteredBeans(Arrays.asList(beanName), Arrays.asList(bean));
    }

    @Deprecated
    public static List<PropertySource<?>> getPropertySourcesFromAnnotatedClass(String annotatedClassName) {
        Class<?> annotatedClass = ReflectionUtils.getClass(annotatedClassName);
        return SpringUtils.getPropertySources(annotatedClass);
    }

    @Deprecated
    public static List<PropertySource<?>> getPropertySources(Class<?> annotatedClass) {
        return PropertySourceUtils.getPropertySources(annotatedClass);
    }

    @Deprecated
    public static List<PropertySource<?>> extractPropertySourcesAndClose(ConfigurableApplicationContext context) {
        return PropertySourceUtils.extractPropertySourcesAndClose(context);
    }

    @Deprecated
    public static List<PropertySource<?>> getPropertySources(String location) {
        GenericXmlApplicationContext context = new GenericXmlApplicationContext(new String[]{location});
        return SpringUtils.extractPropertySourcesAndClose((ConfigurableApplicationContext)context);
    }

    @Deprecated
    public static List<PropertySource<?>> getPropertySources(ConfigurableApplicationContext context) {
        return PropertySourceUtils.getPropertySources(context);
    }

    public static <T> Map<String, T> getAllBeans(List<String> locations, Class<T> type) {
        String[] locationsArray = locations.toArray(new String[locations.size()]);
        GenericXmlApplicationContext ctx = new GenericXmlApplicationContext(locationsArray);
        Map map = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)ctx, type);
        ctx.close();
        return map;
    }

    public static <T> Map<String, T> getAllBeans(String location, Class<T> type) {
        GenericXmlApplicationContext ctx = new GenericXmlApplicationContext(new String[]{location});
        Map map = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)ctx, type);
        ctx.close();
        return map;
    }

    public static <T> Map<String, T> getAllBeans(ConfigurableApplicationContext ctx, Class<T> type) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)ctx, type);
    }

    @Deprecated
    public static List<PropertySource<?>> getPropertySources(ConfigurableApplicationContext context, Comparator<PropertySource<?>> comparator) {
        return PropertySourceUtils.getPropertySources(context, comparator);
    }

    @Deprecated
    public static List<PropertySource<?>> asList(PropertySource<?> ... sources) {
        return PropertySourceUtils.asList(sources);
    }

    public static void debugQuietly(ApplicationContext ctx) {
        if (!logger.isDebugEnabled() || ctx == null) {
            return;
        }
        if (ctx.getParent() != null) {
            SpringUtils.debug(ctx.getParent());
        }
        SpringUtils.debug(ctx);
    }

    public static void debug(ApplicationContext ctx) {
        logger.debug("------------------------ Spring Context ------------------------------");
        logger.debug("Id: [{}]", (Object)ctx.getId());
        logger.debug("Display Name: [{}]", (Object)ctx.getDisplayName());
        logger.debug("Application Name: [{}]", (Object)ctx.getApplicationName());
        logger.debug("----------------------------------------------------------------------");
        List<String> names = Arrays.asList(BeanFactoryUtils.beanNamesIncludingAncestors((ListableBeanFactory)ctx));
        List<String> columns = Arrays.asList("Name", "Type", "Hashcode");
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Collections.sort(names);
        for (String name : names) {
            Object bean = ctx.getBean(name);
            String instance = bean == null ? "NULL" : bean.getClass().getSimpleName();
            String hashcode = bean == null ? "NULL" : Integer.toHexString(bean.hashCode());
            Object[] row = new Object[]{name, instance, hashcode};
            rows.add(row);
        }
        LoggerUtils.logTable(columns, rows, LoggerLevel.DEBUG, logger, true);
        logger.debug("----------------------------------------------------------------------");
    }

    @Deprecated
    public static void showPropertySources(List<PropertySource<?>> propertySources) {
        List<String> columns = Arrays.asList("Name", "Impl", "Source");
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        for (PropertySource<?> propertySource : propertySources) {
            String name = propertySource.getName();
            String impl = propertySource.getClass().getName();
            String source = propertySource.getSource().getClass().getName();
            Object[] row = new Object[]{name, impl, source};
            rows.add(row);
        }
        LoggerUtils.logTable(columns, rows, LoggerLevel.INFO, logger, true);
    }

    @Deprecated
    public static void showPropertySources(ConfigurableEnvironment env) {
        SpringUtils.showPropertySources(SpringUtils.getPropertySources(env));
    }

    public static String getProperty(Environment env, String key) {
        String value = env.getRequiredProperty(key);
        return env.resolveRequiredPlaceholders(value);
    }

    public static boolean exists(Environment env, String key) {
        return env.getProperty(key) != null;
    }

    public static String getProperty(Environment env, String key, String defaultValue) {
        if (defaultValue == null) {
            return SpringUtils.getProperty(env, key);
        }
        String value = env.getProperty(key);
        if (value == null) {
            return env.resolveRequiredPlaceholders(defaultValue);
        }
        return env.resolveRequiredPlaceholders(value);
    }

    @Deprecated
    public static Properties getAllEnumerableProperties(ConfigurableEnvironment env) {
        List<PropertySource<?>> sources = SpringUtils.getPropertySources(env);
        Collections.reverse(sources);
        PropertySourceConversionResult result = SpringUtils.convertEnumerablePropertySources(sources);
        return PropertyUtils.combine(result.getPropertiesList());
    }

    @Deprecated
    public static void reconfigurePropertySources(ConfigurableEnvironment env, String name, Properties properties) {
        PropertySourceUtils.reconfigurePropertySources(env, name, properties);
    }

    @Deprecated
    public static void removeAllPropertySources(ConfigurableEnvironment env) {
        PropertySourceUtils.removeAllPropertySources(env);
    }

    @Deprecated
    public static List<PropertySource<?>> getPropertySources(ConfigurableEnvironment env) {
        return PropertySourceUtils.getPropertySources(env);
    }

    @Deprecated
    public static PropertySourceConversionResult convertEnumerablePropertySources(List<PropertySource<?>> sources) {
        PropertySourceConversionResult result = new PropertySourceConversionResult();
        ArrayList<Properties> list = new ArrayList<Properties>();
        ArrayList converted = new ArrayList();
        ArrayList skipped = new ArrayList();
        for (PropertySource<?> source : sources) {
            Assert.isTrue((boolean)(source instanceof EnumerablePropertySource), (String)("[" + source + "] is not enumerable"));
            EnumerablePropertySource eps = (EnumerablePropertySource)source;
            Properties sourceProperties = SpringUtils.convert(eps);
            list.add(sourceProperties);
            converted.add(source);
        }
        result.setConverted(converted);
        result.setSkipped(skipped);
        result.setPropertiesList(list);
        return result;
    }

    @Deprecated
    public static Properties convert(EnumerablePropertySource<?> source) {
        String[] names;
        Properties properties = new Properties();
        for (String name : names = source.getPropertyNames()) {
            Object object = source.getProperty(name);
            if (object != null) {
                String value = object.toString();
                properties.setProperty(name, value);
                continue;
            }
            logger.warn("Property [{}] is null", (Object)name);
        }
        return properties;
    }

    public static boolean isTrue(Environment env, String property) {
        String value = env.getProperty(property);
        if (StringUtils.isBlank((String)value)) {
            return false;
        }
        return new Boolean(value);
    }
}

