/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring.env;

import java.io.File;
import org.kuali.common.util.Assert;
import org.kuali.common.util.Mode;
import org.kuali.common.util.ModeUtils;
import org.kuali.common.util.spring.env.EnvContext;
import org.kuali.common.util.spring.env.EnvUtils;
import org.kuali.common.util.spring.env.EnvironmentService;
import org.springframework.core.env.Environment;

@Deprecated
public class DefaultEnvironmentService
implements EnvironmentService {
    public static final boolean DEFAULT_CHECK_ENVIRONMENT_VARIABLES = true;
    public static final boolean DEFAULT_RESOLVE_STRINGS = true;
    public static final Mode DEFAULT_MISSING_PROPERTY_MODE = Mode.ERROR;
    public static final String ENV_PREFIX = "env";
    private final boolean checkEnvironmentVariables;
    private final boolean resolveStrings;
    private final Environment env;
    private final Mode missingPropertyMode;

    public DefaultEnvironmentService(Environment env) {
        this(env, true, true, DEFAULT_MISSING_PROPERTY_MODE);
    }

    public DefaultEnvironmentService(Environment env, boolean checkEnvironmentVariables) {
        this(env, checkEnvironmentVariables, true, DEFAULT_MISSING_PROPERTY_MODE);
    }

    public DefaultEnvironmentService(Environment env, boolean checkEnvironmentVariables, boolean resolveStrings, Mode missingPropertyMode) {
        Assert.noNulls(new Object[]{env, missingPropertyMode});
        this.env = env;
        this.missingPropertyMode = missingPropertyMode;
        this.checkEnvironmentVariables = checkEnvironmentVariables;
        this.resolveStrings = resolveStrings;
    }

    @Override
    public boolean containsProperty(String key) {
        Assert.noBlanks(key);
        return this.env.containsProperty(key);
    }

    @Override
    public <T> T getProperty(EnvContext<T> context) {
        T returnValue;
        Assert.noNulls(context);
        T springValue = this.getSpringValue(context.getKey(), context.getType());
        T t = returnValue = springValue == null ? context.getDefaultValue() : springValue;
        if (returnValue == null) {
            ModeUtils.validate(this.missingPropertyMode, this.getMissingPropertyMessage(context.getKey()));
        }
        return returnValue;
    }

    protected String getMissingPropertyMessage(String key) {
        if (this.checkEnvironmentVariables) {
            String envKey = EnvUtils.getEnvironmentVariableKey(key);
            return "No value for [" + key + "] or [" + envKey + "]";
        }
        return "No value for [" + key + "]";
    }

    protected <T> T getSpringValue(String key, Class<T> type) {
        Object value = this.env.getProperty(key, type);
        if (value == null && this.checkEnvironmentVariables) {
            String envKey = EnvUtils.getEnvironmentVariableKey(key);
            return (T)this.env.getProperty(envKey, type);
        }
        return (T)value;
    }

    protected <T> Class<T> getSpringValueAsClass(String key, Class<T> type) {
        Class value = this.env.getPropertyAsClass(key, type);
        if (value == null && this.checkEnvironmentVariables) {
            String envKey = EnvUtils.getEnvironmentVariableKey(key);
            return this.env.getPropertyAsClass(envKey, type);
        }
        return value;
    }

    @Override
    public <T> Class<T> getClass(String key, Class<T> type) {
        return this.getClass(key, type, null);
    }

    @Override
    public <T> Class<T> getClass(String key, Class<T> type, Class<T> defaultValue) {
        Class<T> returnValue;
        Class<T> springValue = this.getSpringValueAsClass(key, type);
        Class<T> clazz = returnValue = springValue == null ? defaultValue : springValue;
        if (returnValue == null) {
            ModeUtils.validate(this.missingPropertyMode, this.getMissingPropertyMessage(key));
        }
        return returnValue;
    }

    @Override
    public String getString(String key) {
        return this.getString(key, null);
    }

    @Override
    public String getString(String key, String defaultValue) {
        String string = this.getProperty(EnvContext.newString(key, defaultValue));
        if (this.resolveStrings) {
            return this.env.resolveRequiredPlaceholders(string);
        }
        return string;
    }

    @Override
    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    @Override
    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.getProperty(EnvContext.newBoolean(key, defaultValue));
    }

    @Override
    public File getFile(String key) {
        return this.getFile(key, null);
    }

    @Override
    public File getFile(String key, File defaultValue) {
        return this.getProperty(EnvContext.newFile(key, defaultValue));
    }

    @Override
    public Integer getInteger(String key, Integer defaultValue) {
        return this.getProperty(EnvContext.newInteger(key, defaultValue));
    }

    @Override
    public Integer getInteger(String key) {
        return this.getInteger(key, null);
    }

    public boolean isCheckEnvironmentVariables() {
        return this.checkEnvironmentVariables;
    }

    public boolean isResolveStrings() {
        return this.resolveStrings;
    }

    public Environment getEnv() {
        return this.env;
    }

    public Mode getMissingPropertyMode() {
        return this.missingPropertyMode;
    }

    @Override
    public <T> T getProperty(String key, Class<T> type, T provided) {
        return this.getProperty(EnvContext.newCtx(key, type, provided));
    }

    @Override
    public <T> T getProperty(String key, Class<T> type) {
        return this.getProperty(EnvContext.newCtx(key, type, null));
    }
}

