/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring.env.model;

import java.util.Properties;
import org.kuali.common.util.Assert;
import org.kuali.common.util.Mode;
import org.kuali.common.util.spring.env.EnvUtils;
import org.kuali.common.util.spring.env.PropertiesEnvironment;
import org.springframework.core.env.Environment;

public final class EnvironmentServiceContext {
    private final Environment env;
    private final boolean checkEnvironmentVariables;
    private final boolean resolveStrings;
    private final Mode missingPropertyMode;

    public Environment getEnv() {
        return this.env;
    }

    public boolean isCheckEnvironmentVariables() {
        return this.checkEnvironmentVariables;
    }

    public boolean isResolveStrings() {
        return this.resolveStrings;
    }

    public Mode getMissingPropertyMode() {
        return this.missingPropertyMode;
    }

    private EnvironmentServiceContext(Builder builder) {
        this.env = builder.env;
        this.checkEnvironmentVariables = builder.checkEnvironmentVariables;
        this.resolveStrings = builder.resolveStrings;
        this.missingPropertyMode = builder.missingPropertyMode;
    }

    public static class Builder {
        private Environment env = EnvUtils.getDefaultEnvironment();
        private boolean checkEnvironmentVariables = true;
        private boolean resolveStrings = true;
        private Mode missingPropertyMode = Mode.ERROR;
        private static final String CHECK_ENVIRONMENT_VARIABLES_KEY = "env.checkEnvironmentVariables";
        private static final String RESOLVE_STRINGS_KEY = "env.resolveStrings";
        private static final String MISSING_PROPERTY_MODE_KEY = "env.missingPropertyMode";

        public Builder env(Properties properties) {
            return this.env((Environment)new PropertiesEnvironment(properties));
        }

        public Builder env(Environment env) {
            this.env = env;
            return this;
        }

        public Builder checkEnvironmentVariables(boolean checkEnvironmentVariables) {
            this.checkEnvironmentVariables = checkEnvironmentVariables;
            return this;
        }

        public Builder resolveStrings(boolean resolveStrings) {
            this.resolveStrings = resolveStrings;
            return this;
        }

        public Builder missingPropertyMode(Mode missingPropertyMode) {
            this.missingPropertyMode = missingPropertyMode;
            return this;
        }

        private void override() {
            Assert.noNulls(this.env);
            this.checkEnvironmentVariables((Boolean)this.env.getProperty(CHECK_ENVIRONMENT_VARIABLES_KEY, Boolean.class, (Object)this.checkEnvironmentVariables));
            this.resolveStrings((Boolean)this.env.getProperty(RESOLVE_STRINGS_KEY, Boolean.class, (Object)this.resolveStrings));
            this.missingPropertyMode((Mode)((Object)this.env.getProperty(MISSING_PROPERTY_MODE_KEY, Mode.class, (Object)this.missingPropertyMode)));
        }

        protected void validate(EnvironmentServiceContext ctx) {
            Assert.notNull((Object)ctx.getEnv(), (String)"'env' cannot be null");
            Assert.notNull((Object)((Object)ctx.getMissingPropertyMode()), (String)"'missingPropertyMode' cannot be null");
        }

        protected EnvironmentServiceContext getInstance() {
            return new EnvironmentServiceContext(this);
        }

        public EnvironmentServiceContext build() {
            this.override();
            EnvironmentServiceContext ctx = new EnvironmentServiceContext(this);
            this.validate(ctx);
            return ctx;
        }
    }
}

