/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring.service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.spring.PropertySourceUtils;
import org.kuali.common.util.spring.service.PropertySourceConfig;
import org.kuali.common.util.spring.service.PropertySourceService;
import org.kuali.common.util.spring.service.SpringContext;
import org.kuali.common.util.spring.service.SpringService;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.PropertySource;

public final class DefaultPropertySourceService
implements PropertySourceService {
    private final SpringService springService;

    public DefaultPropertySourceService(SpringService springService) {
        Assert.noNulls(springService);
        this.springService = springService;
    }

    @Override
    public PropertySource<?> getPropertySource(Class<? extends PropertySourceConfig> config) {
        return this.getPropertySource(null, null, null, config);
    }

    @Override
    public PropertySource<?> getPropertySource(Map<String, Object> beans, List<String> defaultProfiles, List<String> activeProfiles, Class<? extends PropertySourceConfig> config) {
        return this.getPropertySource(beans, defaultProfiles, activeProfiles, config, null);
    }

    @Override
    public List<PropertySource<?>> getPropertySources(Map<String, Object> beans, List<String> defaultProfiles, List<String> activeProfiles, Class<?> config) {
        return this.getPropertySources(beans, defaultProfiles, activeProfiles, config, null);
    }

    @Override
    public List<PropertySource<?>> getPropertySources(Map<String, Object> beans, List<String> defaultProfiles, List<String> activeProfiles, String location) {
        return this.getPropertySources(beans, defaultProfiles, activeProfiles, null, location);
    }

    protected PropertySource<?> getPropertySource(Map<String, Object> beans, List<String> defaultProfiles, List<String> activeProfiles, Class<?> config, String location) {
        List<PropertySource<?>> sources = this.getPropertySources(beans, defaultProfiles, activeProfiles, config, location);
        Assert.isTrue((sources.size() == 1 ? 1 : 0) != 0, (String)"sizes != 1");
        return sources.get(0);
    }

    protected List<PropertySource<?>> getPropertySources(Map<String, Object> beans, List<String> defaultProfiles, List<String> activeProfiles, Class<?> config, String location) {
        Assert.notNull((Object)this.springService, (String)"springService is null");
        SpringContext context = new SpringContext();
        context.setContextBeans(beans);
        if (!StringUtils.isBlank((CharSequence)location)) {
            context.setLocations(Arrays.asList(location));
        } else if (config != null) {
            context.setAnnotatedClasses(CollectionUtils.asList(config));
        } else {
            throw new IllegalArgumentException("Must supply either a location or annotated config");
        }
        context.setActiveProfiles(activeProfiles);
        context.setDefaultProfiles(defaultProfiles);
        ConfigurableApplicationContext ctx = this.springService.getApplicationContext(context);
        ctx.refresh();
        return PropertySourceUtils.getPropertySources(ctx);
    }

    public SpringService getSpringService() {
        return this.springService;
    }
}

