/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.ssh.model;

import com.google.common.base.Optional;
import org.kuali.common.util.Assert;
import org.kuali.common.util.spring.env.EnvUtils;
import org.kuali.common.util.spring.env.EnvironmentService;
import org.kuali.common.util.ssh.model.Algorithm;

public final class GenerateKeyPairContext {
    private final String name;
    private final Algorithm algorithm;
    private final int size;

    private GenerateKeyPairContext(Builder builder) {
        this.name = builder.name;
        this.algorithm = builder.algorithm;
        this.size = builder.size;
    }

    public String getName() {
        return this.name;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public int getSize() {
        return this.size;
    }

    public static class Builder {
        private final String name;
        private Algorithm algorithm = Algorithm.RSA;
        private int size = 2048;
        private Optional<EnvironmentService> env = EnvUtils.ABSENT;
        private static final String NAME_KEY = "ssh.keyName";
        private static final String ALGORITHM_KEY = "ssh.algorithm";
        private static final String SIZE_KEY = "ssh.keySize";

        public Builder(String name) {
            this(EnvUtils.ABSENT, name);
        }

        public Builder(EnvironmentService env, String name) {
            this((Optional<EnvironmentService>)Optional.of((Object)env), name);
        }

        private Builder(Optional<EnvironmentService> env, String name) {
            this.env = env;
            this.name = env.isPresent() ? ((EnvironmentService)env.get()).getString(NAME_KEY, name) : name;
        }

        public Builder algorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        private void validate(GenerateKeyPairContext context) {
            Assert.noBlanks(context.getName());
            Assert.positive(context.getSize());
        }

        private void override() {
            if (this.env.isPresent()) {
                this.algorithm(((EnvironmentService)this.env.get()).getProperty(ALGORITHM_KEY, Algorithm.class, this.algorithm));
                this.size(((EnvironmentService)this.env.get()).getInteger(SIZE_KEY, this.size));
            }
        }

        public GenerateKeyPairContext build() {
            this.override();
            GenerateKeyPairContext context = new GenerateKeyPairContext(this);
            this.validate(context);
            return context;
        }
    }
}

