/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.wait;

import org.kuali.common.util.Assert;
import org.kuali.common.util.FormatUtils;

public final class WaitContext {
    private final long timeoutMillis;
    private final long sleepMillis;
    private final long initialPauseMillis;

    private WaitContext(Builder builder) {
        this.timeoutMillis = builder.timeoutMillis;
        this.sleepMillis = builder.sleepMillis;
        this.initialPauseMillis = builder.initialPauseMillis;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public long getSleepMillis() {
        return this.sleepMillis;
    }

    public long getInitialPauseMillis() {
        return this.initialPauseMillis;
    }

    public static class Builder {
        private final long timeoutMillis;
        private long sleepMillis = FormatUtils.getMillis("1s");
        private long initialPauseMillis = 0L;

        public Builder(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
        }

        public Builder initialPauseMillis(long initialPauseMillis) {
            this.initialPauseMillis = initialPauseMillis;
            return this;
        }

        public Builder sleepMillis(long sleepMillis) {
            this.sleepMillis = sleepMillis;
            return this;
        }

        public WaitContext build() {
            Assert.noNegatives(this.timeoutMillis, this.sleepMillis, this.initialPauseMillis);
            return new WaitContext(this);
        }
    }
}

