/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.xml.jaxb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.xml.jaxb.XmlClassBindings;
import org.kuali.common.util.xml.service.XmlService;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JAXBXmlService
implements XmlService {
    private final boolean formatOutput;
    private final boolean useNamespaceAwareParser;
    private final Map<String, ?> properties;
    private final boolean useEclipseLinkMoxyProvider;

    @Override
    public void write(File file, Object object) {
        Assert.noNulls(file, object);
        FileOutputStream out = null;
        try {
            out = FileUtils.openOutputStream((File)file);
            this.write(out, object);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO error", e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    @Override
    public void write(OutputStream out, Object object) {
        Assert.noNulls(out, object);
        try {
            JAXBContext context = this.getJAXBContext(object.getClass());
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)this.formatOutput);
            marshaller.marshal(object, out);
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Unexpected JAXB error", e);
        }
    }

    @Override
    public <T> T getObjectFromXml(String xml, String encoding, Class<T> type) {
        T t;
        Assert.noBlanks(xml, encoding);
        Assert.noNulls(type);
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(xml.getBytes(encoding));
            t = this.getObject(in, type);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Unexpected IO error", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return t;
    }

    @Override
    public <T> T getObject(InputStream in, Class<T> type) {
        Assert.noNulls(in, type);
        try {
            Unmarshaller unmarshaller = this.getUnmarshaller(type);
            if (this.useNamespaceAwareParser) {
                return (T)unmarshaller.unmarshal(in);
            }
            UnmarshallerHandler unmarshallerHandler = unmarshaller.getUnmarshallerHandler();
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            XMLReader xr = sp.getXMLReader();
            xr.setContentHandler((ContentHandler)unmarshallerHandler);
            InputSource xmlSource = new InputSource(in);
            xr.parse(xmlSource);
            return (T)unmarshallerHandler.getResult();
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Unexpected JAXB error", e);
        }
        catch (SAXException e) {
            throw new IllegalStateException("Unexpected SAX error", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO error", e);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unexpected parser configuration error", e);
        }
    }

    @Override
    public <T> T getObject(File file, Class<T> type) {
        Assert.exists(file);
        Assert.noNulls(type);
        return this.getObject(LocationUtils.getCanonicalPath(file), type);
    }

    @Override
    public <T> T getObject(String location, Class<T> type) {
        Assert.noBlanks(location);
        Assert.noNulls(type);
        InputStream in = null;
        try {
            in = LocationUtils.getInputStream(location);
            T t = this.getObject(in, type);
            return t;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO error", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    @Override
    public String toXml(Object object, String encoding) {
        Assert.noNulls(object);
        Assert.noBlanks(encoding);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.write(out, object);
        try {
            return out.toString(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    @Deprecated
    public String toString(Object object, String encoding) {
        return this.toXml(object, encoding);
    }

    protected Unmarshaller getUnmarshaller(Class<?> clazz) throws JAXBException {
        Class[] classes = this.getClassesToBeBound(clazz);
        JAXBContext jc = JAXBContext.newInstance((Class[])classes);
        return jc.createUnmarshaller();
    }

    protected JAXBContext getJAXBContext(Class<?> clazz) throws JAXBException {
        Class[] classes = this.getClassesToBeBound(clazz);
        if (this.properties.size() == 0) {
            return JAXBContext.newInstance((Class[])classes);
        }
        return JAXBContext.newInstance((Class[])classes, this.properties);
    }

    protected Class<?>[] getClassesToBeBound(Class<?> clazz) {
        List<Class<?>> classes = this.getClassesList(clazz);
        if (this.useEclipseLinkMoxyProvider) {
            classes.add(0, UseEclipseLinkMoxyProvider.class);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    protected List<Class<?>> getClassesList(Class<?> clazz) {
        XmlClassBindings bindings = clazz.getAnnotation(XmlClassBindings.class);
        ArrayList classes = new ArrayList(CollectionUtils.singletonList(clazz));
        if (bindings == null) {
            return classes;
        }
        for (Class<?> binding : bindings.classes()) {
            classes.addAll(this.getClassesList(binding));
        }
        return classes;
    }

    public boolean isFormatOutput() {
        return this.formatOutput;
    }

    public boolean isUseNamespaceAwareParser() {
        return this.useNamespaceAwareParser;
    }

    public static Builder builder() {
        return new Builder();
    }

    private JAXBXmlService(Builder builder) {
        this.formatOutput = builder.formatOutput;
        this.useNamespaceAwareParser = builder.useNamespaceAwareParser;
        this.useEclipseLinkMoxyProvider = builder.useEclipseLinkMoxyProvider;
        this.properties = builder.properties;
    }

    public Map<String, ?> getProperties() {
        return this.properties;
    }

    public boolean isUseEclipseLinkMoxyProvider() {
        return this.useEclipseLinkMoxyProvider;
    }

    private static class UseEclipseLinkMoxyProvider {
        private UseEclipseLinkMoxyProvider() {
        }
    }

    public static class Builder {
        private static final Map<String, ?> EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
        public static final boolean FORMAT_OUTPUT = true;
        public static final boolean USE_NAMESPACE_AWARE_PARSER = true;
        public static final boolean USE_ECLIPSE_LINK_MOXY_PROVIDER = true;
        private boolean formatOutput = true;
        private Map<String, ?> properties = EMPTY_MAP;
        private boolean useNamespaceAwareParser = true;
        private boolean useEclipseLinkMoxyProvider = true;

        public Builder useEclipseLinkMoxyProvider(boolean useEclipseLinkMoxyProvider) {
            this.useEclipseLinkMoxyProvider = useEclipseLinkMoxyProvider;
            return this;
        }

        public Builder formatOutput(boolean formatOutput) {
            this.formatOutput = formatOutput;
            return this;
        }

        public Builder useNamespaceAwareParser(boolean useNamespaceAwareParser) {
            this.useNamespaceAwareParser = useNamespaceAwareParser;
            return this;
        }

        public Builder properties(Map<String, ?> properties) {
            this.properties = properties;
            return this;
        }

        public JAXBXmlService build() {
            Assert.noNulls(this.properties);
            this.properties = Collections.unmodifiableMap(new HashMap(this.properties));
            return new JAXBXmlService(this);
        }
    }
}

