/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.xml.jaxb.adapter;

import com.google.common.base.Optional;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.kuali.common.util.Assert;
import org.kuali.common.util.Str;

public final class FlattenOptionalStringAdapter
extends XmlAdapter<String, Optional<String>> {
    private final String carriageReturnReplacement;
    private final String linefeedReplacement;

    public FlattenOptionalStringAdapter() {
        this("${jaxb.cr}", "${jaxb.lf}");
    }

    public FlattenOptionalStringAdapter(String carriageReturnReplacement, String linefeedReplacement) {
        Assert.noBlanks(carriageReturnReplacement, linefeedReplacement);
        this.carriageReturnReplacement = carriageReturnReplacement;
        this.linefeedReplacement = linefeedReplacement;
    }

    public String marshal(Optional<String> optional) {
        if (optional.isPresent()) {
            return Str.flatten((String)optional.get(), this.carriageReturnReplacement, this.linefeedReplacement);
        }
        return null;
    }

    public Optional<String> unmarshal(String value) {
        if (value == null) {
            return Optional.absent();
        }
        return Optional.of((Object)Str.inflate(value, this.carriageReturnReplacement, this.linefeedReplacement));
    }

    public String getCarriageReturnReplacement() {
        return this.carriageReturnReplacement;
    }

    public String getLinefeedReplacement() {
        return this.linefeedReplacement;
    }
}

