/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.xml.jaxb.adapter;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;

public class TrimmingCSVStringAdapter
extends XmlAdapter<String, List<String>> {
    private static final String DELIMITER = ",";

    public final String marshal(List<String> strings) {
        if (strings.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.size(); ++i) {
            if (i != 0) {
                sb.append(DELIMITER);
            }
            String trimmed = strings.get(i).trim();
            Assert.isFalse(StringUtils.contains((CharSequence)trimmed, (CharSequence)DELIMITER), "[" + trimmed + "] contains '" + DELIMITER + "'");
            sb.append(trimmed);
        }
        return sb.toString();
    }

    public final List<String> unmarshal(String string) {
        if (string == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(CollectionUtils.getTrimmedListFromCSV(string));
    }
}

