/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2016 The Kuali Foundation
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.kuali.kfs.fp.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;

import java.util.LinkedHashMap;

/**
 * This class represents the different types of credit card types
 */
public class CreditCardType extends PersistableBusinessObjectBase implements MutableInactivatable {

    private String financialDocumentCreditCardTypeCode;
    private String financialDocumentCreditCardCompanyName;
    private boolean active;

    /**
     * Default constructor.
     */
    public CreditCardType() {

    }

    /**
     * Gets the financialDocumentCreditCardTypeCode attribute.
     *
     * @return Returns the financialDocumentCreditCardTypeCode
     */
    public String getFinancialDocumentCreditCardTypeCode() {
        return financialDocumentCreditCardTypeCode;
    }

    /**
     * Sets the financialDocumentCreditCardTypeCode attribute.
     *
     * @param financialDocumentCreditCardTypeCode The financialDocumentCreditCardTypeCode to set.
     */
    public void setFinancialDocumentCreditCardTypeCode(String financialDocumentCreditCardTypeCode) {
        this.financialDocumentCreditCardTypeCode = financialDocumentCreditCardTypeCode;
    }


    /**
     * Gets the financialDocumentCreditCardCompanyName attribute.
     *
     * @return Returns the financialDocumentCreditCardCompanyName
     */
    public String getFinancialDocumentCreditCardCompanyName() {
        return financialDocumentCreditCardCompanyName;
    }

    /**
     * Sets the financialDocumentCreditCardCompanyName attribute.
     *
     * @param financialDocumentCreditCardCompanyName The financialDocumentCreditCardCompanyName to set.
     */
    public void setFinancialDocumentCreditCardCompanyName(String financialDocumentCreditCardCompanyName) {
        this.financialDocumentCreditCardCompanyName = financialDocumentCreditCardCompanyName;
    }


    /**
     * @see org.kuali.rice.krad.bo.BusinessObjectBase#toStringMapper()
     */
    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap m = new LinkedHashMap();
        m.put("financialDocumentCreditCardTypeCode", this.financialDocumentCreditCardTypeCode);
        return m;
    }

    /**
     * Gets the active attribute.
     *
     * @return Returns the active.
     */
    public boolean isActive() {
        return active;
    }

    /**
     * Sets the active attribute value.
     *
     * @param active The active to set.
     */
    public void setActive(boolean active) {
        this.active = active;
    }
}
