/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2016 The Kuali Foundation
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.fp.document;

import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.rice.core.api.util.type.KualiDecimal;

/**
 * Interface for voucher type documents that require debit/credit support
 */
public interface VoucherDocument extends AccountingDocument {

    /**
     * This method retrieves the reversal date associated with this document.
     *
     * @return java.sql.Date
     */
    public java.sql.Date getReversalDate();

    /**
     * This method sets the reversal date associated with this document.
     *
     * @param reversalDate
     */
    public void setReversalDate(java.sql.Date reversalDate);

    /**
     * This method calculates the debit total for a voucher document keying off of the debit/debit code, only summing the accounting
     * lines with a debitDebitCode that matched the debit constant, and returns the results.
     *
     * @return KualiDecimal
     */
    public KualiDecimal getDebitTotal();

    /**
     * This method calculates the credit total for a voucher document keying off of the debit/credit code, only summing the
     * accounting lines with a debitCreditCode that matched the debit constant, and returns the results.
     *
     * @return KualiDecimal
     */
    public KualiDecimal getCreditTotal();
}
