/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2016 The Kuali Foundation
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.gl.batch.service;

import java.util.Map;

/**
 * An interface declaring the methods needed to run the organization reversion process
 */
public interface OrganizationReversionProcessService {

    /**
     * Runs the Organization Reversion Year End Process for the end of a fiscal year (ie, a process that
     * runs before the fiscal year end, and thus uses current account, etc.)
     *
     * @param jobParameters               the parameters used in the process
     * @param organizationReversionCounts a Map of named statistics generated by running the process
     */
    public void organizationReversionPriorYearAccountProcess(Map jobParameters, Map<String, Integer> organizationReversionCounts);

    /**
     * Organization Reversion Year End Process for the beginning of a fiscal year (ie, the process as it runs
     * after the fiscal year end, thus using prior year account, etc.)
     *
     * @param jobParameters               the parameters used in the process
     * @param organizationReversionCounts a Map of named statistics generated by running the process
     */
    public void organizationReversionCurrentYearAccountProcess(Map jobParameters, Map<String, Integer> organizationReversionCounts);

    /**
     * Returns the parameters for this organization reversion job
     *
     * @return a Map of standard parameters for the job
     */
    public Map getJobParameters();
}
