/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2016 The Kuali Foundation
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.gl.businessobject;

import org.kuali.kfs.sys.KFSPropertyConstants;
import org.kuali.kfs.sys.businessobject.BusinessObjectStringParserFieldUtils;
import org.kuali.rice.krad.bo.BusinessObject;

import java.util.Map;

/**
 * This class has utility methods for parsing OriginEntries from Strings
 */
public class CollectorDetailFieldUtil extends BusinessObjectStringParserFieldUtils {

    /**
     * Returns the class to parse into - OriginEntryFull
     *
     * @see org.kuali.kfs.sys.businessobject.BusinessObjectStringParserFieldUtils#getBusinessObjectClass()
     */
    @Override
    public Class<? extends BusinessObject> getBusinessObjectClass() {
        return CollectorDetail.class;
    }

    /**
     * Returns the fields to be parsed from a String, in order, to form an OriginEntryFull
     *
     * @see org.kuali.kfs.sys.businessobject.BusinessObjectStringParserFieldUtils#getOrderedProperties()
     */
    @Override
    public String[] getOrderedProperties() {
        return new String[]{
            KFSPropertyConstants.UNIVERSITY_FISCAL_YEAR,
            KFSPropertyConstants.CHART_OF_ACCOUNTS_CODE,
            KFSPropertyConstants.ACCOUNT_NUMBER,
            KFSPropertyConstants.SUB_ACCOUNT_NUMBER,
            KFSPropertyConstants.FINANCIAL_OBJECT_CODE,
            KFSPropertyConstants.FINANCIAL_SUB_OBJECT_CODE,
            KFSPropertyConstants.FINANCIAL_BALANCE_TYPE_CODE,
            KFSPropertyConstants.FINANCIAL_OBJECT_TYPE_CODE,
            KFSPropertyConstants.COLLECTOR_DETAIL_SEQUENCE_NUMBER,
            KFSPropertyConstants.FINANCIAL_DOCUMENT_TYPE_CODE,
            KFSPropertyConstants.FINANCIAL_SYSTEM_ORIGINATION_CODE,
            KFSPropertyConstants.DOCUMENT_NUMBER,
            KFSPropertyConstants.COLLECTOR_DETAIL_AMOUNT,
            KFSPropertyConstants.COLLECTOR_DETAIL_GL_CREDIT_CODE,
            KFSPropertyConstants.COLLECTOR_DETAIL_NOTE_TEXT
        };
    }


    public int getDetailLineTotalLength() {
        int totalLength = 0;
        Map<String, Integer> lengthMap = getFieldLengthMap();
        for (String property : getOrderedProperties()) {
            totalLength += lengthMap.get(property).intValue();
        }
        return totalLength;
    }
}
