/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2016 The Kuali Foundation
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.gl.dataaccess;

import org.kuali.kfs.gl.businessobject.CorrectionCriteria;

import java.util.List;

/**
 * A DAO interface that
 */
public interface CorrectionCriteriaDao {

    /**
     * Deletes a correction criterion
     *
     * @param criterion the criterion to delete
     */
    void delete(CorrectionCriteria criterion);

    /**
     * Returns a list of all the correction criteria associated with the given GLCP document and correction group
     *
     * @param documentNumber            the GLCP document number of correction criteria to find
     * @param correctionGroupLineNumber the correction group of correction criteria to find
     * @return a List of collection criteria
     */
    List findByDocumentNumberAndCorrectionGroupNumber(String documentNumber, Integer correctionGroupLineNumber);
}
