/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2016 The Kuali Foundation
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.gl.service;

import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.gl.batch.service.AccountingCycleCachingService;
import org.kuali.kfs.gl.businessobject.OriginEntryInformation;
import org.kuali.kfs.sys.Message;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.UniversityDate;

import java.util.List;

/**
 * An interface that declares methods that would be needed to validate origin entries and transactions run through the scrubber
 */
public interface ScrubberValidator {
    /**
     * Validate a transaction in the scrubber
     *
     * @param originEntry       Input transaction (never changed)
     * @param scrubbedEntry     Output transaction (scrubbed version of input transaction)
     * @param universityRunDate Date of scrubber run
     * @return List of Message objects based for warnings or errors that happened when validating the transaction
     */
    public List<Message> validateTransaction(OriginEntryInformation originEntry, OriginEntryInformation scrubbedEntry, UniversityDate universityRunDate, boolean laborIndicator, AccountingCycleCachingService accountingCycleCachingService);

    /**
     * Validate a transaction for use in balance inquiry
     *
     * @param entry Input transaction
     */
    public void validateForInquiry(GeneralLedgerPendingEntry entry);

    /**
     * Performs logic to determine whether an account is expired
     *
     * @param account           Account to validate
     * @param universityRunDate Run date of process
     * @return true if account is expired, false if not
     */
    public boolean isAccountExpired(Account account, UniversityDate universityRunDate);
}
