/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2016 The Kuali Foundation
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.sec;

/**
 * Constants for Property Names
 */
public class SecPropertyConstants {
    public static final String ATTRIBUTE_ID = "attributeId";
    public static final String ATTRIBUTE_NAME = "attributeName";
    public static final String ATTRIBUTE_VALUE = "attributeValue";
    public static final String DEFINITION_ID = "definitionId";
    public static final String INQUIRY_NAMESPACE_CODE = "inquiryNamespaceCode";
    public static final String FINANCIAL_SYSTEM_DOCUMENT_TYPE_CODE = "financialSystemDocumentTypeCode";
    public static final String MEMBER_ID = "memberId";
    public static final String MODEL_DEFINITIONS = "modelDefinitions";
    public static final String MODEL_MEMBERS = "modelMembers";
    public static final String MODEL_ID = "modelId";
    public static final String MEMBER_TYPE_CODE = "memberTypeCode";
    public static final String OPERATOR_CODE = "operatorCode";
    public static final String PRINCIPAL_DEFINITIONS = "principalDefinitions";
    public static final String SCREEN_TYPE = "screenType";
    public static final String SECURITY_ATTRIBUTE_NAME = "securityAttributeName";
    public static final String SECURITY_ATTRIBUTE_NAME_NESTED = "securityAttribute.name";
    public static final String SECURITY_PERSON_PRINCIPAL_NAME = "securityPerson.principalName";
    public static final String TEMPLATE_ID = "templateId";
    public final static String ROLE_ID = "roleId";
    public final static String ROLE_NAME = "roleName";
    public final static String GROUP_ID = "groupId";
    public final static String GROUP_NAME = "groupName";
    public final static String PRINCIPAL_ID = "principalId";
    public final static String PRINCIPAL_NAME = "principalName";
    public static final String FIRST_NAME = "firstName";
    public static final String MIDDLE_NAME = "middleName";
    public static final String LAST_NAME = "lastName";
    public static final String ENTITY_ID = "entityId";
    public static final String EMPLOYEE_ID = "employeeId";
    public final static String EMAIL_ADDRESS = "emailAddress";
}
