/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2016 The Kuali Foundation
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.sys;

import org.kuali.kfs.krad.util.KRADPropertyConstants;
import org.kuali.rice.kim.impl.KIMPropertyConstants;


/**
 * Property name constants.
 */
public class KFSPropertyConstants {
    public static final String A21_SUB_ACCOUNT = "a21SubAccount";
    public static final String ACCOUNT = "account";
    public static final String ACCOUNT_CHANGE_DETAILS = "accountGlobalDetails";
    public static final String ACCOUNT_CITY_NAME = "accountCityName";
    public static final String ACCOUNT_ACTIVE_INDICATOR = "active";
    public static final String ACCOUNT_CREATE_DATE = "accountCreateDate";
    public static final String ACCOUNT_DELEGATE = "accountDelegate";
    public static final String ACCOUNT_DELEGATE_ACTIVE_INDICATOR = "active";
    public static final String ACCOUNT_DELEGATE_START_DATE = "accountDelegateStartDate";
    public static final String ACCOUNT_DELEGATE_SYSTEM_ID = "accountDelegateSystemId";
    public static final String ACCOUNT_DESCRIPTION = "accountDescription";
    public static final String ACCOUNT_EFFECTIVE_DATE = "accountEffectiveDate";
    public static final String ACCOUNT_EXPENSE_GUIDELINE_TEXT = "accountExpenseGuidelineText";
    public static final String ACCOUNT_EXPIRATION_DATE = "accountExpirationDate";
    public static final String ACCOUNT_EXPIRED_OVERRIDE = "accountExpiredOverride";
    public static final String ACCOUNT_EXPIRED_OVERRIDE_NEEDED = "accountExpiredOverrideNeeded";
    public static final String ACCOUNT_FINANCIAL_OBJECT_TYPE_CODE = "accountFinancialObjectTypeCode";
    public static final String ACCOUNT_FISCAL_OFFICER_SYSTEM_IDENTIFIER = "accountFiscalOfficerSystemIdentifier";
    public static final String ACCOUNT_FISCAL_OFFICER_USER = "accountFiscalOfficerUser";
    public static final String ACCOUNT_GUIDELINE = "accountGuideline";
    public static final String ACCOUNT_IN_FINANCIAL_PROCESSING_INDICATOR = "accountInFinancialProcessingIndicator";
    public static final String ACCOUNT_INCOME_GUIDELINE_TEXT = "accountIncomeGuidelineText";
    public static final String ACCOUNT_INDIRECT_COST_RECOVERY_TYPE_CODE = "accountIndirectCostRecoveryTypeCode";
    public static final String ACCOUNT_KEY = "accountKey";
    public static final String ACCOUNT_LINE_ACTUALS_BALANCE_AMOUNT = "accountLineActualsBalanceAmount";
    public static final String ACCOUNT_LINE_ANNUAL_BALANCE_AMOUNT = "accountLineAnnualBalanceAmount";
    public static final String ACCOUNT_LINE_ENCUMBRANCE_AMOUNT = "accountLineEncumbranceAmount";
    public static final String ACCOUNT_LINE_ENCUMBRANCE_BALANCE_AMOUNT = "accountLineEncumbranceBalanceAmount";
    public static final String ACCOUNT_LINE_ENCUMBRANCE_CLOSED_AMOUNT = "accountLineEncumbranceClosedAmount";
    public static final String ACCOUNT_LINE_ENCUMBRANCE_OUTSTANDING_AMOUNT = "accountLineEncumbranceOutstandingAmount";
    public static final String ACCOUNT_LINE_ENCUMBRANCE_PURGE_CODE = "accountLineEncumbrancePurgeCode";
    public static final String ACCOUNT_MANAGER_SYSTEM_IDENTIFIER = "accountManagerSystemIdentifier";
    public static final String ACCOUNT_MANAGER_USER = "accountManagerUser";
    public static final String ACCOUNT_NAME = "accountName";
    public static final String ACCOUNT_NUMBER = "accountNumber";
    public static final String ACCOUNT_NUMBER_FINANCIAL_OBJECT_CODE = "accountNumberFinancialObjectCode";
    public static final String ACCOUNT_OFF_CAMPUS_INDICATOR = "accountOffCampusIndicator";
    public static final String ACCOUNT_PHYSICAL_CAMPUS = "accountPhysicalCampus";
    public static final String ACCOUNT_PHYSICAL_CAMPUS_CODE = "accountPhysicalCampusCode";
    public static final String ACCOUNT_PURPOSE_TEXT = "accountPurposeText";
    public static final String ACCOUNT_RESPONSIBILITIES = "accountResponsibilities";
    public static final String ACCOUNT_RESTRICTED_STATUS = "accountRestrictedStatus";
    public static final String ACCOUNT_RESTRICTED_STATUS_CODE = "accountRestrictedStatusCode";
    public static final String ACCOUNT_RESTRICTED_STATUS_DATE = "accountRestrictedStatusDate";
    public static final String ACCOUNT_RESTRICTED_STATUS_NAME = "accountRestrictedStatusName";
    public static final String ACCOUNT_STATE = "accountState";
    public static final String ACCOUNT_STATE_CODE = "accountStateCode";
    public static final String ACCOUNT_STREET_ADDRESS = "accountStreetAddress";
    public static final String ACCOUNT_SUFFICIENT_FUNDS_CODE = "accountSufficientFundsCode";
    public static final String ACCOUNT_SUPERVISORY_USER = "accountSupervisoryUser";
    public static final String ACCOUNT_TYPE = "accountType";
    public static final String ACCOUNT_TYPE_CODE = "accountTypeCode";
    public static final String ACCOUNT_TYPE_NAME = "accountTypeName";
    public static final String ACCOUNT_ZIP_CODE = "accountZipCode";
    public static final String ACCOUNTING_LINE_ANNUAL_BALANCE_AMOUNT = "accountLineAnnualBalanceAmount";
    public static final String ACCOUNTING_LINE_PARSER = "accountingLineParser";
    public static final String ACCOUNTING_PERIOD = "accountingPeriod";
    public static final String ACCOUNTS_DELEGATE_PRMRT_INDICATOR = "accountsDelegatePrmrtIndicator";
    public static final String ACCOUNTS_FRINGES_BNFT_INDICATOR = "accountsFringesBnftIndicator";
    public static final String ACCOUNTS_RECIEVABLE_SUPERVISOR_USER = "accountsRecievableSupervisorUser";
    public static final String ACCOUNTS_SUPERVISORY_SYSTEMS_IDENTIFIER = "accountsSupervisorySystemsIdentifier";
    public static final String ACCT_CUSTOM_IND_CST_RCVY_EXCL_CD = "acctCustomIndCstRcvyExclCd";
    public static final String ACCT_INDIRECT_COST_RCVY_TYPE_CD = "acctIndirectCostRcvyTypeCd";
    public static final String ACCT_RCVB_NEXT_CUSTOMER_NUMBER = "acctRcvbNextCustomerNumber";
    public static final String ACCT_RCVB_PRINT_INVOICE_IND = "acctRcvbPrintInvoiceInd";
    public static final String ACCT_RECEIVABLE_AUTO_PAY_IND = "acctReceivableAutoPayInd";
    public static final String ACCT_SUFFICIENT_FUNDS_FIN_OBJ_CD = "acctSufficientFundsFinObjCd";
    public static final String ACCTING_PERIOD_UNIV_FISCAL_PERIOD_END_DATE = "universityFiscalPeriodEndDate";
    public static final String ACTION_REQUESTED = KRADPropertyConstants.ACTION_REQUESTED;
    public static final String ACTION_REQUESTED_VALUE = "actionRequestedValue";
    public static final String ACTIVE = KRADPropertyConstants.ACTIVE;
    public static final String ACTIVE_INDICATOR = KRADPropertyConstants.ACTIVE_INDICATOR;
    public static final String AD_HOC_ROUTE_PERSONS = KRADPropertyConstants.AD_HOC_ROUTE_PERSONS;
    public static final String AD_HOC_ROUTE_WORKGROUPS = KRADPropertyConstants.AD_HOC_ROUTE_WORKGROUPS;
    public static final String ADDRESS_LINE1 = "addressLine1";
    public static final String ADDRESS_LINE2 = "addressLine2";
    public static final String ADMINISTRATOR_USER = "administratorUser";
    public static final String ADVANCE_DEPOSIT_AMOUNT = "financialDocumentAdvanceDepositAmount";
    public static final String ADVANCE_DEPOSIT_DETAIL = "advanceDepositDetail";
    public static final String AGENCY = "agency";
    public static final String AGENCY_COPY_INDICATOR = "agencyCopyIndicator";
    public static final String AGENCY_EXTENSION = "agencyExtension";
    public static final String AGENCY_FRINGE_BENEFIT_TOTAL_AMOUNT = "agencyFringeBenefitTotalAmount";
    public static final String AGENCY_FRINGE_BENEFIT_TOTAL_AMOUNT_TASK = "agencyFringeBenefitTotalAmountTask";
    public static final String AGENCY_MODULAR_INDICATOR = "agencyModularIndicator";
    public static final String AGENCY_NUMBER = "agencyNumber";
    public static final String AGENCY_PERCENT_EFFORT_AMOUNT = "agencyPercentEffortAmount";
    public static final String AGENCY_REQUEST_AMOUNT = "agencyRequestAmount";
    public static final String AGENCY_REQUEST_TOTAL_AMOUNT = "agencyRequestTotalAmount";
    public static final String AGENCY_REQUEST_TOTAL_AMOUNT_TASK = "agencyRequestTotalAmountTask";
    public static final String AGENCY_TO_BE_NAMED_INDICATOR = "agencyToBeNamedIndicator";
    public static final String AGENCY_ADDRESSES = "agencyAddresses";
    public static final String AGENCY_TYPE = "agencyType";
    public static final String AGENCY_TYPE_CODE = "agencyTypeCode";
    public static final String ALIEN_PAYMENT_CODE = "alienPaymentCode";
    public static final String ALL_USER_APPOINTMENT_TASK_PERIODS = "allUserAppointmentTaskPeriods";
    public static final String ALL_USER_APPOINTMENT_TASKS = "allUserAppointmentTasks";
    public static final String ALLOWS_COPY = "allowsCopy";
    public static final String ALLOWS_ERROR_CORRECTION = "allowsErrorCorrection";
    public static final String AMOUNT = "amount";
    public static final String AMOUNT_VIEW_OPTION = "amountViewOption";
    public static final String APPOINTMENT_TYPE = "appointmentType";
    public static final String APPOINTMENT_TYPE_ABBRIEVIATION = "appointmentTypeAbbrieviation";
    public static final String APPOINTMENT_TYPE_CODE = "appointmentTypeCode";
    public static final String APPOINTMENT_TYPE_COST_SHARE_FRINGE_RATE_AMOUNT = "appointmentTypeCostShareFringeRateAmount";
    public static final String APPOINTMENT_TYPE_DESCRIPTION = "appointmentTypeDescription";
    public static final String APPOINTMENT_TYPE_FRINGE_RATE_AMOUNT = "appointmentTypeFringeRateAmount";
    public static final String APPROVAL_OBJECT_CODE_BALANCES = "approvalObjectCodeBalances";
    public static final String ATTACHMENT = KRADPropertyConstants.ATTACHMENT;
    public static final String ATTRIBUTE_CONTROL_TYPE = KRADPropertyConstants.ATTRIBUTE_CONTROL_TYPE;
    public static final String ATTRIBUTE_DESCRIPTION = KRADPropertyConstants.ATTRIBUTE_DESCRIPTION;
    public static final String ATTRIBUTE_FORMATTER_CLASS_NAME = KRADPropertyConstants.ATTRIBUTE_FORMATTER_CLASS_NAME;
    public static final String ATTRIBUTE_ID = "attributeId";
    public static final String ATTRIBUTE_LABEL = KRADPropertyConstants.ATTRIBUTE_LABEL;
    public static final String ATTRIBUTE_MAX_LENGTH = KRADPropertyConstants.ATTRIBUTE_MAX_LENGTH;
    public static final String ATTRIBUTE_NAME = KRADPropertyConstants.ATTRIBUTE_NAME;
    public static final String ATTRIBUTE_SHORT_LABEL = KRADPropertyConstants.ATTRIBUTE_SHORT_LABEL;
    public static final String ATTRIBUTE_SUMMARY = KRADPropertyConstants.ATTRIBUTE_SUMMARY;
    public static final String ATTRIBUTE_VALIDATING_EXPRESSION = KRADPropertyConstants.ATTRIBUTE_VALIDATING_EXPRESSION;
    public static final String AUTHENTICATION_USER_ID = "authenticationUserId";
    public static final String AWARD = "award";
    public static final String AWARD_ACCOUNTS = "awardAccounts";
    public static final String AWARD_ACCUMULATED_TO_DATE_DIRECT_COST_AMOUNT = "awardAccumulatedToDateDirectCostAmount";
    public static final String AWARD_BEGINNING_DATE = "awardBeginningDate";
    public static final String AWARD_DOCUMENT_NUMBER = "awardDocumentNumber";
    public static final String AWARD_ENDING_DATE = "awardEndingDate";
    public static final String AWARD_ENTRY_DATE = "awardEntryDate";
    public static final String AWARD_FEDERAL_PASS_THROUGH_INDICATOR = "awardFederalPassThroughIndicator";
    public static final String AWARD_INDR_COST_RCVY_ENTRY_NBR = "awardIndrCostRcvyEntryNbr";
    public static final String AWARD_INDR_COST_RCVY_RATE_PCT = "awardIndrCostRcvyRatePct";
    public static final String AWARD_NUMBER = "awardNumber";
    public static final String AWARD_ORGRANIZATIONS = "awardOrganizations";
    public static final String AWARD_PERIOD_BEGIN_MONTH = "awardPeriodBeginMonth";
    public static final String AWARD_PERIOD_BEGIN_YEAR = "awardPeriodBeginYear";
    public static final String AWARD_PERIOD_END_MONTH = "awardPeriodEndMonth";
    public static final String AWARD_PERIOD_END_YEAR = "awardPeriodEndYear";
    public static final String AWARD_PROJECT_DIRECTORS = "awardProjectDirectors";
    public static final String AWARD_PROJECT_TITLE = "awardProjectTitle";
    public static final String AWARD_FUND_MANAGERS = "awardFundManagers";
    public static final String AWARD_STATUS_CODE = "awardStatusCode";
    public static final String AWARD_SUBCONTRACTORS = "awardSubcontractors";
    public static final String AWARD_THRESHOLD_AMOUNT = "awardThresholdAmount";
    public static final String AWARD_TOTAL_AMOUNT = "awardTotalAmount";
    public static final String BALANCE_TYP = "balanceTyp";
    public static final String BALANCE_TYPE = "balanceType";
    public static final String BALANCE_TYPE_CODE = "balanceTypeCode";
    public static final String BANK = "bank";
    public static final String BANK_ACCOUNT_DESCRIPTION = "bankAccountDescription";
    public static final String BANK_ACCOUNT_NUMBER = "bankAccountNumber";
    public static final String BANK_ACCOUNTS = "bankAccounts";
    public static final String BANK_ACH_INDICATOR = "bankAchIndicator";
    public static final String BANK_CHECK_INDICATOR = "bankCheckIndicator";
    public static final String BANK_DEPOSIT_INDICATOR = "bankDepositIndicator";
    public static final String BANK_DISBURSEMENT_INDICATOR = "bankDisbursementIndicator";
    public static final String BANK_NAME = "bankName";
    public static final String BANK_ROUTING_NUMBER = "bankRoutingNumber";
    public static final String BANK_SHORT_NAME = "bankShortName";
    public static final String BASIC_ACCOUNTING_CATEGORY_CODE = "basicAccountingCategoryCode";
    public static final String BASE_BUDGET_ADJUSTMENT_AMOUNT = "baseBudgetAdjustmentAmount";
    public static final String BASE_SALARY = "baseSalary";
    public static final String BATCH_SEQUENCE_NUMBER = "batchSequenceNumber";
    public static final String BEGINNING_BALANCE_LINE_AMOUNT = "beginningBalanceLineAmount";
    public static final String BUDGET = "budget";
    public static final String BUDGET_AGENCY = "budgetAgency";
    public static final String BUDGET_AGENCY_NUMBER = "budgetAgencyNumber";
    public static final String BUDGET_BASE_CODE = "budgetBaseCode";
    public static final String BUDGET_FRINGE_RATE = "budgetFringeRate";
    public static final String BUDGET_FRINGE_RATE_DESCRIPTION = "budgetFringeRateDescription";
    public static final String BUDGET_INDIRECT_COST_COST_SHARE_INDICATOR = "budgetIndirectCostCostShareIndicator";
    public static final String BUDGET_INDIRECT_COST_JUSTIFICATION_TEXT = "budgetIndirectCostJustificationText";
    public static final String BUDGET_LAST_UPDATE_TIMESTAMP = "budgetLastUpdateTimestamp";
    public static final String BUDGET_MANUAL_INDIRECT_COST_RATE = "budgetManualIndirectCostRate";
    public static final String BUDGET_MANUAL_MTDC_AMOUNT = "budgetManualMtdcAmount";
    public static final String BUDGET_MANUAL_MTDC_INDICATOR = "budgetManualMtdcIndicator";
    public static final String BUDGET_MANUAL_RATE_INDICATOR = "budgetManualRateIndicator";
    public static final String BUDGET_MODULAR_CONSORTIUM_DESCRIPTION = "budgetModularConsortiumDescription";
    public static final String BUDGET_MODULAR_DIRECT_COST_AMOUNT = "budgetModularDirectCostAmount";
    public static final String BUDGET_MODULAR_INCREMENT_AMOUNT = "budgetModularIncrementAmount";
    public static final String BUDGET_MODULAR_PERIODS = "budgetModularPeriods";
    public static final String BUDGET_MODULAR_PERSONNEL_DESCRIPTION = "budgetModularPersonnelDescription";
    public static final String BUDGET_MODULAR_TASK_NUMBER = "budgetModularTaskNumber";
    public static final String BUDGET_MODULAR_VARIABLE_ADJUSTMENT_DESCRIPTION = "budgetModularVariableAdjustmentDescription";
    public static final String BUDGET_NAME = "budgetName";
    public static final String BUDGET_NONPERSONNEL_CATEGORY_CODE = "budgetNonpersonnelCategoryCode";
    public static final String BUDGET_NONPERSONNEL_DESCRIPTION = "budgetNonpersonnelDescription";
    public static final String BUDGET_NONPERSONNEL_INFLATION_RATE = "budgetNonpersonnelInflationRate";
    public static final String BUDGET_NONPERSONNEL_OBJECT_CODE = "budgetNonpersonnelObjectCode";
    public static final String BUDGET_NONPERSONNEL_SEQUENCE_NUMBER = "budgetNonpersonnelSequenceNumber";
    public static final String BUDGET_NONPERSONNEL_SUB_CATEGORY_CODE = "budgetNonpersonnelSubCategoryCode";
    public static final String BUDGET_ORIGIN_AGENCY_AMOUNT = "budgetOriginAgencyAmount";
    public static final String BUDGET_ORIGIN_SEQUENCE_NUMBER = "budgetOriginSequenceNumber";
    public static final String BUDGET_ORIGIN_THIRD_PARTY_COST_SHARE_AMOUNT = "budgetOriginThirdPartyCostShareAmount";
    public static final String BUDGET_ORIGIN_UNIVERSITY_COST_SHARE_AMOUNT = "budgetOriginUniversityCostShareAmount";
    public static final String BUDGET_PARENT_TRACK_NUMBER = "budgetParentTrackNumber";
    public static final String BUDGET_PERIOD = "budgetPeriod";
    public static final String BUDGET_PERIOD_BEGIN_DATE = "budgetPeriodBeginDate";
    public static final String BUDGET_PERIOD_END_DATE = "budgetPeriodEndDate";
    public static final String BUDGET_PERIOD_LABEL = "budgetPeriodLabel";
    public static final String BUDGET_PERIOD_MAXIMUM_AMOUNT = "budgetPeriodMaximumAmount";
    public static final String BUDGET_PERIOD_NEXT_SEQUENCE_NUMBER = "budgetPeriodNextSequenceNumber";
    public static final String BUDGET_PERIOD_PARTICIPANTS_NUMBER = "budgetPeriodParticipantsNumber";
    public static final String BUDGET_PERIOD_SEQUENCE = "budgetPeriodSequence";
    public static final String BUDGET_PERIOD_SEQUENCE_NUMBER = "budgetPeriodSequenceNumber";
    public static final String BUDGET_PERIOD_THIRD_PARTY_COST_SHARE = "budgetPeriodThirdPartyCostShare";
    public static final String BUDGET_PERIOD_UNIVERSITY_COST_SHARE = "budgetPeriodUniversityCostShare";
    public static final String BUDGET_PERMISSION_CODE = "budgetPermissionCode";
    public static final String BUDGET_PERSONNEL_INFLATION_RATE = "budgetPersonnelInflationRate";
    public static final String BUDGET_PERSONNEL_SERVICE = "budgetPersonnelService";
    public static final String BUDGET_PROGRAM_ANNOUNCEMENT_NAME = "budgetProgramAnnouncementName";
    public static final String BUDGET_PROGRAM_ANNOUNCEMENT_NUMBER = "budgetProgramAnnouncementNumber";
    public static final String BUDGET_PROJECT_DIRECTOR_UNIVERSAL_ID = "budgetProjectDirectorUniversalIdentifier";
    public static final String BUDGET_PURPOSE_CODE = "budgetPurposeCode";
    public static final String BUDGET_RECORDING_LEVEL = "budgetRecordingLevel";
    public static final String BUDGET_RECORDING_LEVEL_CODE = "budgetRecordingLevelCode";
    public static final String BUDGET_ROLLOVER_INDICATOR = "budgetRolloverIndicator";
    public static final String BUDGET_TASK_NAME = "budgetTaskName";
    public static final String BUDGET_TASK_NEXT_SEQUENCE_NUMBER = "budgetTaskNextSequenceNumber";
    public static final String BUDGET_TASK_ON_CAMPUS = "budgetTaskOnCampus";
    public static final String BUDGET_TASK_PERIOD_INDIRECT_COST_ITEMS = "budgetTaskPeriodIndirectCostItems";
    public static final String BUDGET_TASK_SEQUENCE_NUMBER = "budgetTaskSequenceNumber";
    public static final String BUDGET_THIRD_PARTY_COST_SHARE_AMOUNT = "budgetThirdPartyCostShareAmount";
    public static final String BUDGET_THIRD_PARTY_COST_SHARE_COPY_INDICATOR = "budgetThirdPartyCostShareCopyIndicator";
    public static final String BUDGET_THIRD_PARTY_COST_SHARE_DESCRIPTION = "budgetThirdPartyCostShareDescription";
    public static final String BUDGET_THIRD_PARTY_COST_SHARE_INDICATOR = "budgetThirdPartyCostShareIndicator";
    public static final String BUDGET_THIRD_PARTY_COST_SHARE_SEQUENCE_NUMBER = "budgetThirdPartyCostShareSequenceNumber";
    public static final String BUDGET_THIRD_PARTY_COST_SHARE_SOURCE_NAME = "budgetThirdPartyCostShareSourceName";
    public static final String BUDGET_TYPE_CODE_TEXT = "budgetTypeCodeText";
    public static final String BUDGET_UNIVERSITY_COST_SHARE_AMOUNT = "budgetUniversityCostShareAmount";
    public static final String BUDGET_UNIVERSITY_COST_SHARE_COPY_INDICATOR = "budgetUniversityCostShareCopyIndicator";
    public static final String BUDGET_UNIVERSITY_COST_SHARE_DESCRIPTION = "budgetUniversityCostShareDescription";
    public static final String BUDGET_UNIVERSITY_COST_SHARE_NEXT_SEQUENCE_NUMBER = "budgetUniversityCostShareNextSequenceNumber";
    public static final String BUDGET_UNIVERSITY_COST_SHARE_SEQUENCE = "budgetUniversityCostShareSequence";
    public static final String BUDGET_UNIVERSITY_COST_SHARE_SEQUENCE_NUMBER = "budgetUniversityCostShareSequenceNumber";
    public static final String BUDGET_UNRECOVERED_INDIRECT_COST_INDICATOR = "budgetUnrecoveredIndirectCostIndicator";
    public static final String BUDGET_USER_SEQUENCE_NUMBER = "budgetUserSequenceNumber";
    public static final String BUDGET_YEAR = "budgetYear";
    public static final String BUILDING = "building";
    public static final String BUILDING_CODE = "buildingCode";
    public static final String BUILDING_NAME = "buildingName";
    public static final String BUILDING_ROOM_NUMBER = "buildingRoomNumber";
    public static final String BURSAR_USER = "bursarUser";
    public static final String BUSINESS_OBJECT_FOR_VALIDATION = "businessObjectForValidation";
    public static final String CAB_USER = "cabUser";
    public static final String CAMPUS = KRADPropertyConstants.CAMPUS;
    public static final String CAMPUS_CODE = "campusCode";
    public static final String CAMPUS_DESCRIPTION = "campusDescription";
    public static final String CAMPUS_LOCATION_CODE = "campusLocationCode";
    public static final String CAMPUS_MAXIMUM_PERIOD1_RATE = "campusMaximumPeriod1Rate";
    public static final String CAMPUS_MAXIMUM_PERIOD2_RATE = "campusMaximumPeriod2Rate";
    public static final String CAMPUS_MAXIMUM_PERIOD3_RATE = "campusMaximumPeriod3Rate";
    public static final String CAMPUS_MAXIMUM_PERIOD4_RATE = "campusMaximumPeriod4Rate";
    public static final String CAMPUS_MAXIMUM_PERIOD5_RATE = "campusMaximumPeriod5Rate";
    public static final String CAMPUS_MAXIMUM_PERIOD6_RATE = "campusMaximumPeriod6Rate";
    public static final String CAMPUS_NAME = KRADPropertyConstants.CAMPUS_NAME;
    public static final String CAMPUS_PLANT_ACCOUNT = "campusPlantAccount";
    public static final String CAMPUS_PLANT_ACCOUNT_NUMBER = "campusPlantAccountNumber";
    public static final String CAMPUS_PLANT_CHART = "campusPlantChart";
    public static final String CAMPUS_PLANT_CHART_CODE = "campusPlantChartCode";
    public static final String CAMPUS_SHORT_NAME = KRADPropertyConstants.CAMPUS_SHORT_NAME;
    public static final String CAMPUS_TYPE_CODE = KRADPropertyConstants.CAMPUS_TYPE_CODE;
    public static final String CAMS_ADMIN_USER = "camsAdminUser";
    public static final String CAPITAL_ASSET_NUMBER = "capitalAssetNumber";
    public static final String CAPITAL_ASSET_TAG_NUMBER = "capitalAssetTagNumber";
    public static final String CAPITAL_ASSET_QUANTITY = "capitalAssetQuantity";
    public static final String CAPITAL_ASSET_PROCESSED_IND = "capitalAssetActionIndicator";
    public static final String CPTLAST_DST_AMT_CD = "distributionAmountCode";
    public static final String CAPITAL_ASSET_TYPE_CODE = "capitalAssetTypeCode";
    public static final String CAPITAL_ASSET_MANUFACTURE_NAME = "capitalAssetManufacturerName";
    public static final String CASH_OFFSET_ACCOUNT = "cashOffsetAccount";
    public static final String CASH_OFFSET_ACCOUNT_NUMBER = "cashOffsetAccountNumber";
    public static final String CASH_OFFSET_FINANCIAL_CHART_OF_ACCOUNT = "cashOffsetFinancialChartOfAccount";
    public static final String CASH_OFFSET_FINANCIAL_CHART_OF_ACCOUNTS_CODE = "cashOffsetFinancialChartOfAccountCode";
    public static final String CASH_OFFSET_OBJECT_CODE = "cashOffsetObjectCode";
    public static final String CASH_OFFSET_SUB_ACCOUNT_NUMBER = "cashOffsetSubAccountNumber";
    public static final String CASH_OFFSET_SUB_OBJECT_CODE = "cashOffsetSubObjectCode";
    public static final String CASH_OFFSET_OBJECT = "cashOffsetObject";
    public static final String CASH_OFFSET_SUB_OBJECT = "cashOffsetSubObject";
    public static final String CASH_OFFSET_SUB_ACCOUNT = "cashOffsetSubAccount";
    public static final String CASH_RECEIPT = "cashReceipt";
    public static final String CATALOG_OF_DOMESTIC_ASSISTANCE_NUMBER = "accountCfdaNumber";
    public static final String CENTRAL_PROCESSOR_USER = "centralProcessorUser";
    public static final String CFDA_NUMBER = "cfdaNumber";
    public static final String CHART = "chart";
    public static final String CHART_OF_ACCOUNTS = "chartOfAccounts";
    public static final String CHART_OF_ACCOUNTS_CODE = "chartOfAccountsCode";
    public static final String CHART_RESPONSIBILITIES = "chartResponsibilities";
    public static final String CHECK = "check";
    public static final String CHECK_AMOUNT = "amount";
    public static final String CHECK_DATE = "checkDate";
    public static final String CHECK_ENTRY_MODE = "checkEntryMode";
    public static final String CHECK_NUMBER = "checkNumber";
    public static final String CHECKS = "checks";
    public static final String CITY = "city";
    public static final String CLASS = "class";
    public static final String CLASS_NAME = "className";
    public static final String CODE = "code";
    public static final String CODE_RETRIEVED = "codeRetrieved";
    public static final String COLLECTOR_DETAIL_SEQUENCE_NUMBER = "collectorDetailSequenceNumber";
    public static final String COLLECTOR_DETAIL_GL_CREDIT_CODE = "glCreditCode";
    public static final String COLLECTOR_DETAIL_AMOUNT = "collectorDetailItemAmount";
    public static final String COLLECTOR_DETAIL_NOTE_TEXT = "collectorDetailNoteText";
    public static final String COLLECTOR_BATCH_PERSON_USER_ID = "personUserID";
    public static final String COMPLETE = "complete";
    public static final String COMPONENT_CLASS = "componentClass";
    public static final String COMPONENT_LABEL = "componentLabel";
    public static final String CUSTOMER_ADDRESS_IDENTIFIER = "customerAddressIdentifier";
    public static final String CUSTOMER_NUMBER = "customerNumber";
    public static final String CUSTOMER_ADDRESS_TYPE_CODE = "customerAddressTypeCode";
    public static final String CUSTOMER_NAME = "customerName";
    public static final String CUSTOMER_TAX_NUMBER = "customerTaxNbr";
    public static final String DEPARTMENT_NAME = "departmentName";
    public static final String DESCRIPTION = KRADPropertyConstants.DESCRIPTION;
    public static final String EXTENSION = "extension";
    public static final String BUSINESS_OBJECT_COMPONENT_LABEL = "businessObjectComponent." + COMPONENT_LABEL;
    public static final String BUSINESS_OBJECT_PROPERTY_COMPONENT_LABEL = "businessObjectProperty." + BUSINESS_OBJECT_COMPONENT_LABEL;
    public static final String FUNCTIONAL_FIELD_DESCRIPTION_DESCRIPTION = "functionalFieldDescription." + DESCRIPTION;
    public static final String FUNCTIONAL_FIELD_DESCRIPTION_BUSINESS_OBJECT_PROPERTY_COMPONENT_LABEL = "functionalFieldDescription." + BUSINESS_OBJECT_PROPERTY_COMPONENT_LABEL;
    public static final String CONSOLIDATED_OBJECT_CODE = "consolidatedObjectCode";
    public static final String CONSOLIDATION_OPTION = "consolidationOption";
    public static final String CONTINUATION_ACCOUNT = "continuationAccount";
    public static final String CONTINUATION_ACCOUNT_NUMBER = "continuationAccountNumber";
    public static final String CONTINUATION_CHART_OF_ACCOUNTS_CODE = "continuationFinChrtOfAcctCd";
    public static final String CONTRACT_CONTROL_ACCOUNT = "contractControlAccount";
    public static final String CONTRACT_CONTROL_ACCOUNT_NUMBER = "contractControlAccountNumber";
    public static final String CONTRACT_CONTROL_CHART_OF_ACCOUNTS_CODE = "contractControlFinCoaCode";
    public static final String CONTRACTS_AND_GRANTS_FRINGE_RATE_AMOUNT = "contractsAndGrantsFringeRateAmount";
    public static final String CONTRACTS_GRANTS_BEGINNING_BALANCE_AMOUNT = "contractsGrantsBeginningBalanceAmount";
    public static final String CORRECTED_BY_DOCUMENT_ID = "correctedByDocumentId";
    public static final String CORRECTION_GROUPS = "correctionGroups";
    public static final String COST_SHARE_SOURCE_CHART_OF_ACCOUNTS_CODE = "costShareChartOfAccountCode";
    public static final String COST_SHARE_SOURCE_ACCOUNT = "costShareAccount";
    public static final String COST_SHARE_SOURCE_ACCOUNT_NUMBER = "costShareSourceAccountNumber";
    public static final String COST_SHARE_SOURCE_SUB_ACCOUNT = "costShareSourceSubAccount";
    public static final String COST_SHARE_SOURCE_SUB_ACCOUNT_NUMBER = "costShareSourceSubAccountNumber";
    public static final String COST_SHARE_CHART_OF_ACCOUNT = "costShareChartOfAccount";
    public static final String COST_SHARE_CHART_OF_ACCOUNT_CODE = "costShareChartOfAccountCode";
    public static final String COST_SHARE_FIN_CHART_OF_ACCOUNT_CD = "costShareFinChartOfAccountCd";
    public static final String COST_SHARE_FRINGE_RATE_AMOUNT = "costShareFringeRateAmount";
    public static final String COST_SHARE_OPTION = "costShareOption";
    public static final String COST_SHARE_ORG_CD = "costShareOrgCd";
    public static final String COUNTY_CODE = "countyCode";
    public static final String CREATE_DATE = KRADPropertyConstants.CREATE_DATE;
    public static final String CREATE_SEQUENCE = "createSequence";
    public static final String CREDIT = "credit";
    public static final String CREDIT_CARD_ADVANCE_DEPOSIT_AMOUNT = "creditCardAdvanceDepositAmount";
    public static final String CREDIT_CARD_RECEIPT = "creditCardReceipt";
    public static final String CREDIT_CARD_RECEIPTS_TOTAL = "totalCreditCardAmount";
    public static final String CREDIT_CARD_TYPE = "financialDocumentCreditCardType";
    public static final String CREDIT_CARD_VENDOR = "financialDocumentCreditCardVendor";
    public static final String CREDIT_TOTAL = "creditTotal";
    public static final String CSF_AMOUNT = "csfAmount";
    public static final String CSF_DELETE_CODE = "csfDeleteCode";
    public static final String CSF_FULL_TIME_EMPLOYMENT_QUANTITY = "csfFullTimeEmploymentQuantity";
    public static final String CSF_FUNDING_STATUS_CODE = "csfFundingStatusCode";
    public static final String CSF_TIME_PERCENT = "csfTimePercent";
    public static final String CURRENT_BUDGET_ADJUSTMENT_AMOUNT = "currentBudgetAdjustmentAmount";
    public static final String CURRENT_BUDGET_LINE_BALANCE_AMOUNT = "currentBudgetLineBalanceAmount";
    public static final String CURRENT_TASK_NUMBER = "currentTaskNumber";
    public static final String DATE = "date";
    public static final String DEBIT = "debit";
    public static final String DEBIT_CREDIT_CODE = "debitCreditCode";
    public static final String DEBIT_OR_CREDIT_CODE = "debitOrCreditCode";
    public static final String DEBIT_TOTAL = "debitTotal";
    public static final String DELEGATE_GLOBALS = "delegateGlobals";
    public static final String DEPOSIT = "deposit";
    public static final String DEPOSIT_BANK_CODE = "depositBankCode";
    public static final String DEPOSIT_DATE = "depositDate";
    public static final String DEPTID = "deptid";
    public static final String DETAIL_POSITION_REQUIRED_INDICATOR = "detailPositionRequiredIndicator";
    public static final String DETAIL_TEXT = "detailText";
    public static final String DICTIONARY_BUSINESS_OBJECT_NAME = KRADPropertyConstants.DICTIONARY_BUSINESS_OBJECT_NAME;
    public static final String ADDITIONAL_WIRE_TEXT = "additionalWireText";
    public static final String DISB_VCHR_ALIEN_PAYMENT_CODE = "disbVchrAlienPaymentCode";
    public static final String DISB_VCHR_ATTACHMENT_CODE = "disbVchrAttachmentCode";
    public static final String ATTENTION_LINE_TEXT = "attentionLineText";
    public static final String DISB_VCHR_AUTO_FROM_CITY_NAME = "disbVchrAutoFromCityName";
    public static final String DISB_VCHR_AUTO_FROM_STATE_CODE = "disbVchrAutoFromStateCode";
    public static final String DISB_VCHR_AUTO_ROUND_TRIP_CODE = "disbVchrAutoRoundTripCode";
    public static final String DISB_VCHR_AUTO_TO_CITY_NAME = "disbVchrAutoToCityName";
    public static final String DISB_VCHR_AUTO_TO_STATE_CODE = "disbVchrAutoToStateCode";
    public static final String DISB_VCHR_BANK_CODE = "disbVchrBankCode";
    public static final String BANK_CITY_NAME = "bankCityName";
    public static final String BANK_COUNTRY_NAME = "bankCountryName";
    public static final String BANK_STATE_CODE = "bankStateCode";
    public static final String DISB_VCHR_CHECK_STUB_TEXT = "disbVchrCheckStubText";
    public static final String DISB_VCHR_CHECK_TOTAL_AMOUNT = "disbVchrCheckTotalAmount";
    public static final String DISB_VCHR_CONFERENCE_END_DATE = "disbVchrConferenceEndDate";
    public static final String DISB_VCHR_CONFERENCE_START_DATE = "disbVchrConferenceStartDate";
    public static final String DISB_VCHR_CONFERENCE_TOTAL_AMT = "disbVchrConferenceTotalAmt";
    public static final String DISB_VCHR_CONTACT_EMAIL_ID = "disbVchrContactEmailId";
    public static final String DISB_VCHR_CONTACT_PERSON_NAME = "disbVchrContactPersonName";
    public static final String DISB_VCHR_CONTACT_PHONE_NUMBER = "disbVchrContactPhoneNumber";
    public static final String CURRENCY_TYPE_CODE = "currencyTypeCode";
    public static final String CURRENCY_TYPE_NAME = "currencyTypeName";
    public static final String DISB_VCHR_EXCEPTION_CODE = "disbVchrExceptionCode";
    public static final String DISB_VCHR_EXPENSE = "disbVchrExpense";
    public static final String DISB_VCHR_EXPENSE_AMOUNT = "disbVchrExpenseAmount";
    public static final String DISB_VCHR_EXPENSE_CODE = "disbVchrExpenseCode";
    public static final String DISB_VCHR_EXPENSE_COMPANY = "disbVchrExpenseCompany";
    public static final String DISB_VCHR_EXPENSE_COMPANY_NAME = "disbVchrExpenseCompanyName";
    public static final String FD_CURRENCY_TYPE_CODE = "foreignCurrencyTypeCode";
    public static final String FD_CURRENCY_TYPE_NAME = "foreignCurrencyTypeName";
    public static final String DISB_VCHR_FOREIGN_CURRENCY_IND = "disbVchrForeignCurrencyInd";
    public static final String DISB_VCHR_MILEAGE_CALCULATED_AMT = "disbVchrMileageCalculatedAmt";
    public static final String DISB_VCHR_NON_EMP_TRAVELER_NAME = "disbVchrNonEmpTravelerName";
    public static final String DISB_VCHR_PAYEE_ACCOUNT = "disbVchrPayeeAccount";
    public static final String PAYEE_ACCOUNT_NUMBER = "payeeAccountNumber";
    public static final String DISB_VCHR_PAYEE_CHANGED_IND = "disbVchrPayeeChangedInd";
    public static final String DISB_VCHR_PAYEE_CITY_NAME = "disbVchrPayeeCityName";
    public static final String DISB_VCHR_PAYEE_COUNTRY_CODE = "disbVchrPayeeCountryCode";
    public static final String DISB_VCHR_PAYEE_EMPLOYEE_CODE = "disbVchrPayeeEmployeeCode";
    public static final String DISB_VCHR_PAYEE_ID_NUMBER = "disbVchrPayeeIdNumber";
    public static final String DISB_VCHR_PAYEE_LINE1_ADDR = "disbVchrPayeeLine1Addr";
    public static final String DISB_VCHR_PAYEE_LINE2_ADDR = "disbVchrPayeeLine2Addr";
    public static final String DISB_VCHR_PAYEE_PERSON_NAME = "disbVchrPayeePersonName";
    public static final String DISB_VCHR_PAYEE_STATE_CODE = "disbVchrPayeeStateCode";
    public static final String DISB_VCHR_PAYEE_TAX_CONTROL_CODE = "disbVchrPayeeTaxControlCode";
    public static final String DISB_VCHR_PAYEE_W9_COMPLETE_CODE = "disbVchrPayeeW9CompleteCode";
    public static final String DISB_VCHR_PAYEE_ZIP_CODE = "disbVchrPayeeZipCode";
    public static final String DISB_VCHR_PAYMENT_METHOD_CODE = "disbVchrPaymentMethodCode";
    public static final String DISB_VCHR_PAYMENT_REASON = "disbVchrPaymentReason";
    public static final String DISB_VCHR_PAYMENT_REASON_CODE = "disbVchrPaymentReasonCode";
    public static final String DISB_VCHR_PERDIEM_ACTUAL_AMOUNT = "disbVchrPerdiemActualAmount";
    public static final String DISB_VCHR_PERDIEM_CALCULATED_AMT = "disbVchrPerdiemCalculatedAmt";
    public static final String DISB_VCHR_PERDIEM_CATEGORY_NAME = "disbVchrPerdiemCategoryName";
    public static final String DISB_VCHR_PERDIEM_RATE = "disbVchrPerdiemRate";
    public static final String DISB_VCHR_PERSONAL_CAR_AMOUNT = "disbVchrPersonalCarAmount";
    public static final String DISB_VCHR_PERSONAL_CAR_RATE = "disbVchrPersonalCarRate";
    public static final String DISB_VCHR_PRE_CONF_DEPARTMENT_CD = "disbVchrPreConfDepartmentCd";
    public static final String DISB_VCHR_PRE_PAID_EXPENSE_CODE = "disbVchrPrePaidExpenseCode";
    public static final String DISB_VCHR_PRE_PAID_EXPENSE_COMPANY_NAME = "disbVchrPrePaidExpenseCompanyName";
    public static final String DISB_VCHR_REMIT_CITY_NAME = "disbVchrSpecialHandlingCityName";
    public static final String DISB_VCHR_REMIT_COUNTRY_CODE = "disbVchrSpecialHandlingCountryCode";
    public static final String DISB_VCHR_REMIT_LINE1_ADDR = "disbVchrSpecialHandlingLine1Addr";
    public static final String DISB_VCHR_REMIT_LINE2_ADDR = "disbVchrSpecialHandlingLine2Addr";
    public static final String DISB_VCHR_REMIT_PERSON_NAME = "disbVchrSpecialHandlingPersonName";
    public static final String DISB_VCHR_REMIT_STATE_CODE = "disbVchrSpecialHandlingStateCode";
    public static final String DISB_VCHR_REMIT_ZIP_CODE = "disbVchrSpecialHandlingZipCode";
    public static final String DISB_VCHR_SERVICE_PERFORMED_DESC = "disbVchrServicePerformedDesc";
    public static final String DISB_VCHR_SPECIAL_HANDLING_CODE = "disbVchrSpecialHandlingCode";
    public static final String DISB_VCHR_SPECIAL_HANDLING_STATE_CODE = "disbVchrSpecialHandlingStateCode";
    public static final String DISB_VCHR_TRAVEL_FROM_CITY_NAME = "disbVchrTravelFromCityName";
    public static final String DISB_VCHR_TRAVEL_FROM_STATE_CODE = "disbVchrTravelFromStateCode";
    public static final String DISB_VCHR_TRAVEL_TO_CITY_NAME = "disbVchrTravelToCityName";
    public static final String DISB_VCHR_TRAVEL_TO_COUNTRY_CODE = "disbVchrTravelToCountryCode";
    public static final String DISB_VCHR_TRAVEL_TO_STATE_CODE = "disbVchrTravelToStateCode";
    public static final String AUTOMATED_CLEARING_HOUSE_PROFILE_NUMBER = "automatedClearingHouseProfileNumber";
    public static final String DISBURSEMENT_VOUCHER_BANK_NAME = "disbursementVoucherBankName";
    public static final String DISBURSEMENT_VOUCHER_CHECK_DATE = "disbursementVoucherCheckDate";
    public static final String DISBURSEMENT_VOUCHER_CHECK_NBR = "disbursementVoucherCheckNbr";
    public static final String DISBURSEMENT_VOUCHER_DOCUMENTATION_LOCATION_ADDRESS = "disbursementVoucherDocumentationLocationAddress";
    public static final String DISBURSEMENT_VOUCHER_DOCUMENTATION_LOCATION_CODE = "paymentDocumentationLocationCode";
    public static final String DISBURSEMENT_VOUCHER_DOCUMENTATION_LOCATION_NAME = "disbursementVoucherDocumentationLocationName";
    public static final String PAYMENT_DOCUMENTATION_LOCATION_NAME = "paymentDocumentationLocationName";
    public static final String DISBURSEMENT_VOUCHER_DUE_DATE = "disbursementVoucherDueDate";
    public static final String DISBURSEMENT_VOUCHER_PAYEE_ACCOUNT_NAME = "disbursementVoucherPayeeAccountName";
    public static final String DISBURSEMENT_VOUCHER_PAYEE_ACCOUNT_TYPE_CODE = "disbursementVoucherPayeeAccountTypeCode";
    public static final String WIRE_TRANSFER_FEE_WAIVER_INDICATOR = "wireTransferFeeWaiverIndicator";
    public static final String DISPLAY_NAME = "displayName";
    public static final String DOCUMENT = KRADPropertyConstants.DOCUMENT;
    public static final String DOCUMENT_CONTENTS = "documentContents";
    public static final String DOCUMENT_DESCRIPTION = KRADPropertyConstants.DOCUMENT_DESCRIPTION;
    public static final String DOCUMENT_EXPLANATION = KRADPropertyConstants.DOCUMENT_EXPLANATION;
    public static final String DOCUMENT_FINAL_DATE = "documentFinalDate";
    public static final String DOCUMENT_HEADER = KRADPropertyConstants.DOCUMENT_HEADER;
    public static final String DOCUMENT_HEADER_ID = "documentHeaderId";
    public static final String DOCUMENT_NUMBER = KRADPropertyConstants.DOCUMENT_NUMBER;
    public static final String DOCUMENT_REVERSAL_DATE = "documentReversalDate";
    public static final String DOCUMENT_TEMPLATE_NUMBER = KRADPropertyConstants.DOCUMENT_TEMPLATE_NUMBER;
    public static final String DOCUMENT_TITLE = "documentTitle";
    public static final String DOCUMENT_TYPE = "documentType";
    public static final String DOCUMENT_TYPE_CODE = KRADPropertyConstants.DOCUMENT_TYPE_CODE;
    public static final String DOCUMENT_TYPE_ID = "documentTypeId";
    public static final String DOCUMENT_TYPE_NAME = "documentTypeName";
    public static final String DOMESTIC_CHARGE_AMT = "domesticChargeAmt";
    public static final String DUMMY_BUSINESS_OBJECT = "dummyBusinessObject";
    public static final String DV_ADMIN_USER = "DVAdminUser";
    public static final String DV_CHECK_STUB_OVERFLOW_CODE = "dvCheckStubOverflowCode";
    public static final String DV_CONFERENCE_DESTINATION_NAME = "dvConferenceDestinationName";
    public static final String DV_CONFERENCE_REGISTRANT_NAME = "dvConferenceRegistrantName";
    public static final String DV_NON_EMPLOYEE_EXPENSES = "dvNonEmployeeExpenses";
    public static final String DV_NON_EMPLOYEE_TRAVEL = "dvNonEmployeeTravel";
    public static final String DV_NON_RESIDENT_ALIEN_TAX = "dvNonResidentAlienTax";
    public static final String DV_PAYEE_DETAIL = "dvPayeeDetail";
    public static final String DV_PAYEE_OWN_TYPE = "dvPayeeOwnType";
    public static final String DV_PAYEE_TYPE = "dvPayeeType";
    public static final String DV_PERDIEM_CHANGE_REASON_TEXT = "dvPerdiemChangeReasonText";
    public static final String DV_PERDIEM_END_DTTM_STAMP = "dvPerdiemEndDttmStamp";
    public static final String DV_PERDIEM_START_DTTM_STAMP = "dvPerdiemStartDttmStamp";
    public static final String DV_PERSONAL_CAR_AMOUNT = "disbVchrPersonalCarAmount";
    public static final String DV_PERSONAL_CAR_MILEAGE_AMOUNT = "dvPersonalCarMileageAmount";
    public static final String DV_PRE_CONFERENCE_DETAIL = "dvPreConferenceDetail";
    public static final String DV_PRE_CONFERENCE_REGISTRANTS = "dvPreConferenceRegistrants";
    public static final String DV_PRE_CONFERENCE_REQUEST_NUMBER = "dvPreConferenceRequestNumber";
    public static final String DV_PRE_PAID_EMPLOYEE_EXPENSES = "dvPrePaidEmployeeExpenses";
    public static final String DV_SERVICE_PERFORMED_LOC_NAME = "dvServicePerformedLocName";
    public static final String DV_SERVICE_REGULAR_EMPR_NAME = "dvServiceRegularEmprName";
    public static final String DV_TAX_ID_NUMBER = "dvTaxIdNumber";
    public static final String DV_TAX_PAYER_TYPE_CODE = "dvTaxPayerTypeCode";
    public static final String DV_TRAVEL_FROM_COUNTRY_CODE = "dvTravelFromCountryCode";
    public static final String DV_WIRE_ADMINISTRATOR_USER = "DVWireAdministratorUser";
    public static final String PAYMENT_SOURCE_WIRE_TRANSFER = "wireTransfer";
    public static final String EARN_CODE = "earnCode";
    public static final String EDIT = "edit";
    public static final String ELECTRONIC_RESEARCH_ADMINISTRATION_GRANT_NUMBER = "electronicResearchAdministrationGrantNumber";
    public static final String EMAIL_ADDRESS = KRADPropertyConstants.EMAIL_ADDRESS;
    public static final String EMPLID = "emplid";
    public static final String EMPLOYEE = "employee";
    public static final String EMPLOYEE_ID = "employeeId";
    public static final String EMPLOYEE_RECORD = "employeeRecord";
    public static final String EMPLOYEE_STATUS_CODE = KRADPropertyConstants.EMPLOYEE_STATUS_CODE;
    public static final String EMPLOYEE_TYPE_CODE = KRADPropertyConstants.EMPLOYEE_TYPE_CODE;
    public static final String ENCUMBRANCE_DOCUMENT_TYPE_CODE = "documentTypeCode";
    public static final String ENCUMBRANCE_UPDATE_CODE = "encumbranceUpdateCode";
    public static final String ENDOWMENT_INCOME_ACCOUNT = "endowmentIncomeAccount";
    public static final String ENDOWMENT_INCOME_ACCOUNT_NUMBER = "endowmentIncomeAccountNumber";
    public static final String ENDOWMENT_INCOME_CHART_OF_ACCOUNTS_CODE = "endowmentIncomeAcctFinCoaCd";
    public static final String ENTRY_GROUP_ID = "entryGroupId";
    public static final String ENTRY_ID = "entryId";
    public static final String EXCEPTION_INDICATOR = "exceptionIndicator";
    public static final String EXCEPTION_USER = "exceptionUser";
    public static final String EXP_BDGT_ELIMINATIONS_FIN_OBJ = "expBdgtEliminationsFinObj";
    public static final String EXP_BDGT_ELIMINATIONS_FIN_OBJ_CD = "expBdgtEliminationsFinObjCd";
    public static final String EXPENSE_FINANCIAL_OBJECT = "expenseFinancialObject";
    public static final String EXPENSE_FINANCIAL_OBJECT_CODE = "expenseFinancialObjectCode";
    public static final String EXPIRED = "expired";
    public static final String EXPLANATION = KRADPropertyConstants.EXPLANATION;
    public static final String EXTRNL_FIN_ENCUM_SUFFICNT_FND_INDICATOR = "extrnlFinEncumSufficntFndIndicator";
    public static final String FDOC_ATTACHMENT_IDENTIFIER = "fdocAttachmentIdentifier";
    public static final String FDOC_ATTACHMENT_MIME_TYPE_CODE = "fdocAttachmentMimeTypeCode";
    public static final String FDOC_ATTACHMENT_NUMBER = "fdocAttachmentNumber";
    public static final String FEDERAL_INCOME_TAX_PERCENT = "federalIncomeTaxPercent";
    public static final String FEDERAL_PASS_THROUGH_AGENCY = "federalPassThroughAgency";
    public static final String FEDERAL_PASS_THROUGH_AGENCY_NUMBER = "federalPassThroughAgencyNumber";
    public static final String FEDERAL_PASS_THROUGH_FUNDED_AMOUNT = "federalPassThroughFundedAmount";
    public static final String FEDERAL_PASS_THROUGH_INDICATOR = "federalPassThroughIndicator";
    public static final String FIELD_NAME = "fieldName";
    public static final String FILE_NAME = "fileName";
    public static final String FIN_ACCOUNTS_PAYABLE_OBJECT = "finAccountsPayableObject";
    public static final String FIN_ACCOUNTS_PAYABLE_OBJECT_CODE = "finAccountsPayableObjectCode";
    public static final String FIN_ACCOUNTS_RECEIVABLE_OBJ = "finAccountsReceivableObj";
    public static final String FIN_ACCOUNTS_RECEIVABLE_OBJ_CODE = "finAccountsReceivableObjCode";
    public static final String FIN_BALANCE_TYPE_ENCUM_INDICATOR = "finBalanceTypeEncumIndicator";
    public static final String FIN_CHART_OF_ACCOUNT_DESCRIPTION = "finChartOfAccountDescription";
    public static final String FIN_COA_MANAGER_UNIVERSAL = "finCoaManagerUniversal";
    public static final String FIN_COA_MANAGER_UNIVERSAL_ID = "finCoaManagerUniversalId";
    public static final String FIN_CONSOLIDATION_OBJ_ACTIVE_INDICATOR = "finConsolidationObjActiveIndicator";
    public static final String FIN_CONSOLIDATION_OBJ_SHORT_NAME = "finConsolidationObjShortName";
    public static final String FIN_CONSOLIDATION_OBJECT_CODE = "finConsolidationObjectCode";
    public static final String FIN_CONSOLIDATION_OBJECT_NAME = "finConsolidationObjectName";
    public static final String FIN_DOC_APPROVAL_FROM_THIS_AMT = "finDocApprovalFromThisAmt";
    public static final String FIN_DOC_APPROVAL_TO_THIS_AMOUNT = "finDocApprovalToThisAmount";
    public static final String FIN_DOC_ATTACHMENT_FILE_NAME = "finDocAttachmentFileName";
    public static final String FIN_DOC_NEXT_REGISTRANT_LINE_NBR = "finDocNextRegistrantLineNbr";
    public static final String FIN_DOC_NOTE_POSTED_DTTM_STAMP = "finDocNotePostedDttmStamp";
    public static final String FIN_DOCUMENT_AUTHOR_UNIVERSAL = "finDocumentAuthorUniversal";
    public static final String FIN_DOCUMENT_AUTHOR_UNIVERSAL_ID = "finDocumentAuthorUniversalId";
    public static final String FIN_DOCUMENT_BANK_ACCOUNT_DESC = "finDocumentBankAccountDesc";
    public static final String FIN_DOCUMENT_BANK_ACCOUNT_NUMBER = "finDocumentBankAccountNumber";
    public static final String FIN_EXTERNAL_ENCUMBRANCE_OBJ = "finExternalEncumbranceObj";
    public static final String FIN_EXTERNAL_ENCUMBRANCE_OBJ_CD = "finExternalEncumbranceObjCd";
    public static final String FIN_INTERNAL_ENCUMBRANCE_OBJ = "finInternalEncumbranceObj";
    public static final String FIN_INTERNAL_ENCUMBRANCE_OBJ_CD = "finInternalEncumbranceObjCd";
    public static final String FIN_OBJ_MANDATORY_TRNFRELIM = "finObjMandatoryTrnfrelim";
    public static final String FIN_OBJ_MANDATORY_TRNFRELIM_CD = "finObjMandatoryTrnfrelimCd";
    public static final String FIN_OBJ_RESTRICTED_COLUMN_NAME = "finObjRestrictedColumnName";
    public static final String FIN_OBJ_RESTRICTED_GROUPING_CODE = "finObjRestrictedGroupingCode";
    public static final String FIN_OBJ_RESTRICTED_GROUPING_NAME = "finObjRestrictedGroupingName";
    public static final String FIN_OBJ_RESTRICTION_OPERATOR_CD = "finObjRestrictionOperatorCd";
    public static final String FIN_OBJ_VALUE_RESTRICTED_CODE = "finObjValueRestrictedCode";
    public static final String FIN_OBJECT_TYPE_DEBITCREDIT_CD = "finObjectTypeDebitcreditCd";
    public static final String FIN_OBJECT_TYPE_ICR_SELECTION_INDICATOR = "finObjectTypeIcrSelectionIndicator";
    public static final String FIN_PRE_ENCUMBRANCE_OBJECT = "finPreEncumbranceObject";
    public static final String FIN_PRE_ENCUMBRANCE_OBJECT_CODE = "finPreEncumbranceObjectCode";
    public static final String FIN_PREENCUM_SUFFICIENT_FUND_INDICATOR = "finPreencumSufficientFundIndicator";
    public static final String FIN_REPORT_ORGANIZATION_CODE = "finReportOrganizationCode";
    public static final String FIN_SYSTEM_HOME_ORIGINATION_CODE = "finSystemHomeOriginationCode";
    public static final String FIN_SYSTEM_REF_ORIGINATION_CODE = "referenceFinancialSystemOriginationCode";
    public static final String FINANCIAL_BALANCE_TYP = "financialBalanceTyp";
    public static final String FINANCIAL_BALANCE_TYPE_CODE = "financialBalanceTypeCode";
    public static final String FINANCIAL_BALANCE_TYPE_NAME = "financialBalanceTypeName";
    public static final String FINANCIAL_BALANCE_TYPE_SHORT_NM = "financialBalanceTypeShortNm";
    public static final String FINANCIAL_BEGINNING_BALANCE_LINE_AMOUNT = "financialBeginningBalanceLineAmount";
    public static final String FINANCIAL_BUDGET_AGGREGATION = "financialBudgetAggregation";
    public static final String FINANCIAL_BUDGET_AGGREGATION_CD = "financialBudgetAggregationCd";
    public static final String FINANCIAL_CASH_OBJECT = "financialCashObject";
    public static final String FINANCIAL_CASH_OBJECT_CODE = "financialCashObjectCode";
    public static final String FINANCIAL_CONSOLIDATION_OBJECT = "financialConsolidationObject";
    public static final String FINANCIAL_CONSOLIDATION_OBJECT_CODE = "financialConsolidationObjectCode";
    public static final String FINANCIAL_CONSOLIDATION_SORT_CODE = "financialConsolidationSortCode";
    public static final String FINANCIAL_DOCUMENT = "financialDocument";
    public static final String FINANCIAL_DOCUMENT_APPROVED_CODE = "financialDocumentApprovedCode";
    public static final String FINANCIAL_DOCUMENT_ATTACHMENT_FILE_SIZE = "financialDocumentAttachmentFileSize";
    public static final String FINANCIAL_DOCUMENT_BANK_CODE = "financialDocumentBankCode";
    public static final String FINANCIAL_DOCUMENT_CREDIT_CARD_TYPE_CODE = "financialDocumentCreditCardTypeCode";
    public static final String FINANCIAL_DOCUMENT_CREDIT_CARD_VENDOR_NUMBER = "financialDocumentCreditCardVendorNumber";
    public static final String FINANCIAL_DOCUMENT_DEPOSIT_LINE_NUMBER = "financialDocumentDepositLineNumber";
    @Deprecated
    public static final String FINANCIAL_DOCUMENT_DESCRIPTION = "financialDocumentDescription";
    public static final String FINANCIAL_DOCUMENT_IN_ERROR_NUMBER = "financialDocumentInErrorNumber";
    public static final String FINANCIAL_DOCUMENT_LINE_DESCRIPTION = "financialDocumentLineDescription";
    public static final String FINANCIAL_DOCUMENT_LINE_NUMBER = "financialDocumentLineNumber";
    public static final String FINANCIAL_DOCUMENT_MONTH_1_LINE_AMOUNT = "financialDocumentMonth1LineAmount";
    public static final String FINANCIAL_DOCUMENT_MONTH_10_LINE_AMOUNT = "financialDocumentMonth10LineAmount";
    public static final String FINANCIAL_DOCUMENT_MONTH_11_LINE_AMOUNT = "financialDocumentMonth11LineAmount";
    public static final String FINANCIAL_DOCUMENT_MONTH_12_LINE_AMOUNT = "financialDocumentMonth12LineAmount";
    public static final String FINANCIAL_DOCUMENT_MONTH_2_LINE_AMOUNT = "financialDocumentMonth2LineAmount";
    public static final String FINANCIAL_DOCUMENT_MONTH_3_LINE_AMOUNT = "financialDocumentMonth3LineAmount";
    public static final String FINANCIAL_DOCUMENT_MONTH_4_LINE_AMOUNT = "financialDocumentMonth4LineAmount";
    public static final String FINANCIAL_DOCUMENT_MONTH_5_LINE_AMOUNT = "financialDocumentMonth5LineAmount";
    public static final String FINANCIAL_DOCUMENT_MONTH_6_LINE_AMOUNT = "financialDocumentMonth6LineAmount";
    public static final String FINANCIAL_DOCUMENT_MONTH_7_LINE_AMOUNT = "financialDocumentMonth7LineAmount";
    public static final String FINANCIAL_DOCUMENT_MONTH_8_LINE_AMOUNT = "financialDocumentMonth8LineAmount";
    public static final String FINANCIAL_DOCUMENT_MONTH_9_LINE_AMOUNT = "financialDocumentMonth9LineAmount";
    public static final String FINANCIAL_DOCUMENT_NEXT_ITEM_IDENTIFIER = "financialDocumentNextItemIdentifier";
    public static final String FINANCIAL_DOCUMENT_NEXT_LINE_NBR = "financialDocumentNextLineNbr";
    public static final String FINANCIAL_DOCUMENT_NOTE_PURGE_CD = "financialDocumentNotePurgeCd";
    public static final String FINANCIAL_DOCUMENT_NOTE_TEXT = "financialDocumentNoteText";
    public static final String FINANCIAL_DOCUMENT_REFERENCE_NBR = "referenceFinancialDocumentNumber";
    public static final String FINANCIAL_DOCUMENT_REVERSAL_DATE = "financialDocumentReversalDate";
    public static final String FINANCIAL_DOCUMENT_STATUS = "financialDocumentStatus";
    public static final String FINANCIAL_DOCUMENT_STATUS_CODE = "financialDocumentStatusCode";
    public static final String FINANCIAL_DOCUMENT_STATUS_NAME = "financialDocumentStatusName";
    @Deprecated
    public static final String FINANCIAL_DOCUMENT_TEMPLATE_NUMBER = "financialDocumentTemplateNumber";
    public static final String FINANCIAL_DOCUMENT_TOTAL_AMOUNT = "financialDocumentTotalAmount";
    // below field used by KFS specifically
    public static final String FINANCIAL_DOCUMENT_LINE_TYPE_CODE = "financialDocumentLineTypeCode";
    public static final String FINANCIAL_DOCUMENT_TYPE_CODE = "financialDocumentTypeCode";
    public static final String FINANCIAL_FEDERAL_FUNDED = "financialFederalFunded";
    public static final String FINANCIAL_FEDERAL_FUNDED_CODE = "financialFederalFundedCode";
    public static final String FINANCIAL_HIGHER_ED_FUNCTION = "financialHigherEdFunction";
    public static final String FINANCIAL_HIGHER_ED_FUNCTION_CD = "financialHigherEdFunctionCd";
    public static final String FINANCIAL_ICR_SERIES_IDENTIFIER = "financialIcrSeriesIdentifier";
    public static final String FINANCIAL_LEVEL_SORT_CODE = "financialLevelSortCode";
    public static final String FINANCIAL_OBJECT = "financialObject";
    public static final String FINANCIAL_OBJECT_CHART_OF_ACCOUNT = "financialObjectChartOfAccount";
    public static final String FINANCIAL_OBJECT_CHART_OF_ACCOUNT_CODE = "financialObjectChartOfAccountCode";
    public static final String FINANCIAL_OBJECT_CODE = "financialObjectCode";
    public static final String FINANCIAL_OBJECT_CODE_NAME = "financialObjectCodeName";
    public static final String FINANCIAL_OBJECT_CODE_SHORT_NAME = "financialObjectCodeShortName";
    public static final String FINANCIAL_OBJECT_FRINGE_OR_SALARY_CODE = "financialObjectFringeOrSalaryCode";
    public static final String FINANCIAL_OBJECT_LEVEL = "financialObjectLevel";
    public static final String FINANCIAL_OBJECT_LEVEL_CODE = "financialObjectLevelCode";
    public static final String FINANCIAL_OBJECT_LEVEL_NAME = "financialObjectLevelName";
    public static final String FINANCIAL_OBJECT_LEVEL_SHORT_NM = "financialObjectLevelShortNm";
    public static final String FINANCIAL_OBJECT_SUB_TYPE = "financialObjectSubType";
    public static final String FINANCIAL_OBJECT_SUB_TYPE_CODE = "financialObjectSubTypeCode";
    public static final String FINANCIAL_OBJECT_SUB_TYPE_NAME = "financialObjectSubTypeName";
    public static final String FINANCIAL_OBJECT_TYPE = "financialObjectType";
    public static final String FINANCIAL_OBJECT_TYPE_CODE = "financialObjectTypeCode";
    public static final String FINANCIAL_OBJECTIVE_PRSCTRL_INDICATOR = "financialObjectivePrsctrlIndicator";
    public static final String FINANCIAL_OFFSET_GENERATION_INDICATOR = "financialOffsetGenerationIndicator";
    public static final String FINANCIAL_OFFSET_OBJECT_CODE = "financialOffsetObjectCode";
    public static final String FINANCIAL_REPORT_CHART_CODE = "financialReportChartCode";
    public static final String FINANCIAL_REPORTING_CODE = "financialReportingCode";
    public static final String FINANCIAL_REPORTING_CODE_DESCRIPTION = "financialReportingCodeDescription";
    public static final String FINANCIAL_REPORTING_CODE_MGR_ID = "financialReportingCodeMgrId";
    public static final String FINANCIAL_REPORTING_SORT_CODE = "financialReportingSortCode";
    public static final String FINANCIAL_REPORTS_TO_REPORTING_CODE = "financialReportsToReportingCode";
    public static final String FINANCIAL_SUB_OBJECT = "financialSubObject";
    public static final String FINANCIAL_SUB_OBJECT_ACTIVE_INDICATOR = "active";
    public static final String FINANCIAL_SUB_OBJECT_CDSHORT_NM = "financialSubObjectCdshortNm";
    public static final String FINANCIAL_SUB_OBJECT_CODE = "financialSubObjectCode";
    public static final String FINANCIAL_SUB_OBJECT_CODE_NAME = "financialSubObjectCodeName";
    public static final String FINANCIAL_SYSTEM_DATABASE_DESC = "financialSystemDatabaseDesc";
    public static final String FINANCIAL_SYSTEM_DATABASE_NAME = "financialSystemDatabaseName";
    public static final String FINANCIAL_SYSTEM_FUNCTION_ACTIVE_INDICATOR = "financialSystemFunctionActiveIndicator";
    public static final String FINANCIAL_SYSTEM_FUNCTION_CONTROL_CODE = "financialSystemFunctionControlCode";
    public static final String FINANCIAL_SYSTEM_FUNCTION_DEFAULT_INDICATOR = "financialSystemFunctionDefaultIndicator";
    public static final String FINANCIAL_SYSTEM_MULTIPLE_VALUE_INDICATOR = "financialSystemMultipleValueIndicator";
    public static final String FINANCIAL_SYSTEM_ORIGINATION_CODE = "financialSystemOriginationCode";
    public static final String FINANCIAL_SYSTEM_PARAMETER_ACTIVE_INDICATOR = "financialSystemParameterActiveIndicator";
    public static final String FINANCIAL_SYSTEM_PARAMETER_DESCRIPTION = "financialSystemParameterDescription";
    public static final String FINANCIAL_SYSTEM_PARAMETER_NAME = "financialSystemParameterName";
    public static final String FINANCIAL_SYSTEM_PARAMETER_OPERATOR = "financialSystemParameterOperator";
    public static final String FINANCIAL_SYSTEM_PARAMETER_SECURITY = "financialSystemParameterSecurity";
    public static final String FINANCIAL_SYSTEM_PARAMETER_TEXT = "financialSystemParameterText";
    public static final String FINANCIAL_SYSTEM_PARAMETERS = "financialSystemParameters";
    public static final String FINANCIAL_SYSTEM_SCRIPT_DESCRIPTION = "financialSystemScriptDescription";
    public static final String FINANCIAL_SYSTEM_SCRIPT_NAME = "financialSystemScriptName";
    public static final String FINANCIAL_SYSTEM_SERVER_NAME = "financialSystemServerName";
    public static final String FISCAL_CAMPUS_CODE = "fiscalCampusCode";
    public static final String FISCAL_YEAR = "fiscalYear";
    public static final String FORCE_REFRESH_OF_BO_SUB_LISTS_FOR_SAVE = "forceRefreshOfBOSubListsForSave";
    public static final String FOREIGN_CHARGE_AMT = "foreignChargeAmt";
    public static final String FOREIGN_SOURCE_INCOME_CODE = "foreignSourceIncomeCode";
    public static final String FREQUENCY = "frequency";
    public static final String FRINGE_RATE = "fringeRate";
    public static final String FRINGE_RATE_AMOUNT = "fringeRateAmount";
    public static final String FRINGE_RATES = "fringeRates";
    public static final String FROM_TEXT_FILE = "fromTextFile";
    public static final String FULL_NAME = "fullName";
    public static final String FUND_BALANCE_INDICATOR = "fundBalanceIndicator";
    public static final String FUND_GROUP = "fundGroup";
    public static final String FUND_GROUP_CODE = "fundGroupCode";
    public static final String FUND_MANAGER = "fundManager";
    public static final String GENERAL_LEDGER_PENDING_ENTRIES = "generalLedgerPendingEntries";
    public static final String GENERAL_LEDGER_PENDING_ENTRY = "generalLedgerPendingEntry";
    public static final String GENERAL_LEDGER_INPUT_TYPE_CODE = "inputTypeCode";
    public static final String GENERIC_AMOUNT = KRADPropertyConstants.GENERIC_AMOUNT;
    public static final String GENERIC_BIG_TEXT = KRADPropertyConstants.GENERIC_BIG_TEXT;
    public static final String GENERIC_BOOLEAN = KRADPropertyConstants.GENERIC_BOOLEAN;
    public static final String GENERIC_DATE = KRADPropertyConstants.GENERIC_DATE;
    public static final String GENERIC_FISCAL_YEAR = "genericFiscalYear";
    public static final String GENERIC_SYSTEM_ID = KRADPropertyConstants.GENERIC_SYSTEM_ID;
    public static final String GENERIC_TIMESTAMP = KRADPropertyConstants.GENERIC_TIMESTAMP;
    public static final String GL_CREDIT_CODE = "";
    public static final String GRADUATE_ASSISTANT_RATE = "graduateAssistantRate";
    public static final String GRADUATE_ASSISTANT_RATES = "graduateAssistantRates";
    public static final String GRANT_DESCRIPTION_CODE = "grantDescriptionCode";
    public static final String GROUP = "group";
    public static final String GROUPS = KRADPropertyConstants.GROUPS;
    public static final String COLLECTOR_BATCH_RECORD_TYPE = "recordType";
    public static final String HISTORICAL_FINANCIAL_OBJECT_CODE = "historicalFinancialObjectCode";
    public static final String AGENCY_ACTIVE_INDICATOR = "active";
    public static final String HRIS_ORGANIZATION = "hrisOrganization";
    public static final String HRIS_ORGANIZATION_CODE = "hrisOrganizationCode";
    public static final String ICR_EXPENSE_FINANCIAL_OBJECT = "icrExpenseFinancialObject";
    public static final String ICR_EXPENSE_FINANCIAL_OBJECT_CD = "icrExpenseFinancialObjectCd";
    public static final String ICR_INCOME_FINANCIAL_OBJECT = "icrIncomeFinancialObject";
    public static final String ICR_INCOME_FINANCIAL_OBJECT_CODE = "icrIncomeFinancialObjectCode";
    public static final String ICR_PERCENT = "percent";
    public static final String ICR_TYPE_CODE = "icrTypeCode";
    public static final String ID = KRADPropertyConstants.ID;
    public static final String IN_STATE_INDICATOR = "inStateIndicator";
    public static final String INC_BDGT_ELIMINATIONS_FIN_OBJ = "incBdgtEliminationsFinObj";
    public static final String INC_BDGT_ELIMINATIONS_FIN_OBJ_CD = "incBdgtEliminationsFinObjCd";
    public static final String INCOME_CLASS = "incomeClass";
    public static final String INCOME_CLASS_CODE = "incomeClassCode";
    public static final String INCOME_EXPENSE_CODE = "incomeExpenseCode";
    public static final String INCOME_FINANCIAL_OBJECT = "incomeFinancialObject";
    public static final String INCOME_FINANCIAL_OBJECT_CODE = "incomeFinancialObjectCode";
    public static final String INCOME_STREAM_ACCOUNT = "incomeStreamAccount";
    public static final String INCOME_STREAM_ACCOUNT_NUMBER = "incomeStreamAccountNumber";
    public static final String INCOME_STREAM_CHART_OF_ACCOUNTS_CODE = "incomeStreamFinancialCoaCode";
    public static final String INCOME_TAX_GROSS_UP_CODE = "incomeTaxGrossUpCode";
    public static final String INCOME_TAX_PERCENT = "incomeTaxPercent";
    public static final String INCOME_TAX_TREATY_EXEMPT_CODE = "incomeTaxTreatyExemptCode";
    public static final String INCOME_TAX_TYPE_CODE = "incomeTaxTypeCode";
    public static final String INCREMENTS = "increments";
    public static final String INDIRECT_AMOUNT = "indirectAmount";
    public static final String INDIRECT_COST = "indirectCost";
    public static final String INDIRECT_COST_RECOVERY_RATE_DETAILS = "indirectCostRecoveryRateDetails";
    public static final String INDIRECT_COST_RECOVERY_TYPE = "indirectCostRecoveryType";
    public static final String INDIRECT_COST_RECOVERY_TYPE_CODE = "indirectCostRecoveryTypeCode";

    public static final String INDIRECT_COST_RECOVERY_ACCOUNTS = "indirectCostRecoveryAccounts";
    public static final String A21INDIRECT_COST_RECOVERY_ACCOUNTS = "a21SubAccount.a21IndirectCostRecoveryAccounts";
    public static final String ICR_ACCOUNT = "indirectCostRecoveryAccount";
    public static final String ICR_ACCOUNT_NUMBER = "indirectCostRecoveryAccountNumber";
    public static final String ICR_CHART_OF_ACCOUNTS = "indirectCostRecoveryChartOfAccounts";
    public static final String ICR_CHART_OF_ACCOUNTS_CODE = "indirectCostRecoveryFinCoaCode";
    public static final String ICR_ACCOUNT_LINE_PERCENT = "accountLinePercent";

    public static final String INITIATOR_NETWORK_ID = KRADPropertyConstants.INITIATOR_NETWORK_ID;
    public static final String INITIATOR_PRINCIPAL_ID = "initiatorPrincipalId";
    public static final String INQUIRE_ONLY_USER = "inquireOnlyUser";
    public static final String INTER_DEPARTMENTAL_BILLING_SEQUENCE_NUMBER = "interDepartmentalBillingSequenceNumber";
    public static final String INTRNL_FIN_ENCUM_SUFFICNT_FND_INDICATOR = "intrnlFinEncumSufficntFndIndicator";
    public static final String ITEM = "item";
    public static final String ITEM_QUANTITY = "itemQuantity";
    public static final String ITEM_SEQUENCE_ID = "itemSequenceId";
    public static final String ITEM_SERVICE_DATE = "itemServiceDate";
    public static final String ITEM_STOCK_DESCRIPTION = "itemStockDescription";
    public static final String ITEM_STOCK_NUMBER = "itemStockNumber";
    public static final String ITEM_TOTAL = "itemTotal";
    public static final String ITEM_UNIT_AMOUNT = "itemUnitAmount";
    public static final String ITEMS = "items";
    public static final String IU_NORMAL_WORK_MONTHS = "iuNormalWorkMonths";
    public static final String JULY1_BUDGET_AMOUNT = "july1BudgetAmount";
    public static final String KUALI_USER_CHART_OF_ACCOUNTS_CODE = "chartOfAccountsCode";
    public static final String KUALI_USER_ORGANIZATION_CODE = "organizationCode";
    public static final String KUALI_USER_PERSON_ACTIVE_INDICATOR = "active";
    public static final String KUALI_USER_PERSON_CAMPUS_ADDRESS = "addressLine1";
    public static final String KUALI_USER_PERSON_EMAIL_ADDRESS = "emailAddress";
    public static final String KUALI_USER_PERSON_FIRST_NAME = "firstName";
    public static final String KUALI_USER_PERSON_LAST_NAME = "lastName";
    public static final String KUALI_USER_PERSON_NAME = "name";
    public static final String KUALI_USER_PERSON_UNIVERSAL_IDENTIFIER = "principalId";
    public static final String KUALI_USER_PERSON_USER_IDENTIFIER = "principalName";
    public static final String LABOR_OBJECT = "laborObject";
    public static final String LABOR_BENEFIT_RATE_CATEGORY_CODE = "laborBenefitRateCategoryCode";
    public static final String LAST_UPDATE = "lastUpdate";
    public static final String LAST_UPDATE_TIMESTAMP = "lastUpdateTimestamp";
    public static final String LEVEL_FINANCIAL_REPORT_SORT_CODE = "levelFinancialReportSortCode";
    public static final String LINE = "line";
    public static final String LINE_NUMBER = "lineNumber";
    public static final String LINE_TYPE = "lineType";
    public static final String LOCKING_REPRESENTATION = "lockingRepresentation";
    public static final String LOOKUP_DATE = KRADPropertyConstants.LOOKUP_DATE;
    public static final String MAINTENANCE_USER = "maintenanceUser";
    public static final String MAILING_ADDRESS = "mailingAddress";
    public static final String MILEAGE_LIMIT_AMOUNT = "mileageLimitAmount";
    public static final String MODULAR_BUDGET = "modularBudget";
    public static final String MONTH = "month";
    public static final String MONTH1_AMOUNT = "month1Amount";
    public static final String MONTH10_AMOUNT = "month10Amount";
    public static final String MONTH11_AMOUNT = "month11Amount";
    public static final String MONTH12_AMOUNT = "month12Amount";
    public static final String MONTH13_AMOUNT = "month13Amount";
    public static final String MONTH2_AMOUNT = "month2Amount";
    public static final String MONTH3_AMOUNT = "month3Amount";
    public static final String MONTH4_AMOUNT = "month4Amount";
    public static final String MONTH5_AMOUNT = "month5Amount";
    public static final String MONTH6_AMOUNT = "month6Amount";
    public static final String MONTH7_AMOUNT = "month7Amount";
    public static final String MONTH8_AMOUNT = "month8Amount";
    public static final String MONTH9_AMOUNT = "month9Amount";
    public static final String NAME = KRADPropertyConstants.NAME;
    public static final String NAMESPACE_CODE = "namespaceCode";
    public static final String NEW = "new";
    public static final String NEW_ADVANCE_DEPOSIT = "newAdvanceDeposit";
    public static final String NEW_COLLECTION_RECORD = KRADPropertyConstants.NEW_COLLECTION_RECORD;
    public static final String NEW_CREDIT_CARD_RECEIPT = "newCreditCardReceipt";
    public static final String NEW_ITEM = "newItem";
    public static final String NEW_MAINTAINABLE_OBJECT = KRADPropertyConstants.NEW_MAINTAINABLE_OBJECT;
    public static final String NEW_NON_INVOICED = "newNonInvoiced";
    public static final String NEW_NONEMPLOYEE_EXPENSE_LINE = "newNonEmployeeExpenseLine";
    public static final String NEW_PRECONF_REGISTRANT_LINE = "newPreConferenceRegistrantLine";
    public static final String NEW_PREPAID_EXPENSE_LINE = "newPrePaidNonEmployeeExpenseLine";
    public static final String NEW_SOURCE_LINE = "newSourceLine";
    public static final String NEW_TARGET = "newTarget";
    public static final String NEW_TARGET_LINE = "newTargetLine";
    public static final String NEXT_CAPITAL_ASSET_NUMBER = "nextCapitalAssetNumber";
    public static final String NEXT_CHECK_SEQUENCE_ID = "nextCheckSequenceId";
    public static final String NEXT_CONTRACTS_AND_GRANTS_AGENCY_NUMBER = "nextContractsAndGrantsAgencyNumber";
    public static final String NEXT_CONTRACTS_AND_GRANTS_SUBCONTRACTOR_NUMBER = "nextContractsAndGrantsSubcontractorNumber";
    public static final String NEXT_CORRECTION_GROUP_NUMBER = "nextCorrectionGroupNumber";
    public static final String NEXT_DISB_VCHR_PAYEE_ID_NBR = "nextDisbVchrPayeeIdNbr";
    public static final String NEXT_FDOC_ATTACHMENT_IDENTIFIER = "nextFdocAttachmentIdentifier";
    public static final String NEXT_ITEM_LINE_NUMBER = "nextItemLineNumber";
    public static final String NEXT_NON_CAPITAL_ASSET_NUMBER = "nextNonCapitalAssetNumber";
    public static final String NEXT_SOURCE_LINE_NUMBER = "nextSourceLineNumber";
    public static final String NEXT_TARGET_LINE_NUMBER = "nextTargetLineNumber";
    public static final String NEXT_YEAR_FINANCIAL_OBJECT = "nextYearFinancialObject";
    public static final String NEXT_YEAR_FINANCIAL_OBJECT_CODE = "nextYearFinancialObjectCode";
    public static final String NON_INVOICED_LINE_AMOUNT = "financialDocumentLineAmount";
    public static final String NONPERSONNEL_CATEGORY = "nonpersonnelCategory";
    public static final String NONPERSONNEL_ITEM = "nonpersonnelItem";
    public static final String NONPERSONNEL_ITEMS = "nonpersonnelItems";
    public static final String NONPERSONNEL_MODULAR_EXCLUDED_INDICATOR = "nonpersonnelModularExcludedIndicator";
    public static final String NONPERSONNEL_MTDC_EXCLUDED_INDICATOR = "nonpersonnelMtdcExcludedIndicator";
    public static final String NONPERSONNEL_NEXT_SEQUENCE_NUMBER = "nonpersonnelNextSequenceNumber";
    public static final String NONPERSONNEL_OBJECT_CODE = "nonpersonnelObjectCode";
    public static final String NONPERSONNEL_OBJECT_CODES = "nonpersonnelObjectCodes";
    public static final String NONPERSONNEL_SUB_CATEGORY = "nonpersonnelSubCategory";
    public static final String NORMAL_USER = "normalUser";
    public static final String NOTE = KRADPropertyConstants.NOTE;
    public static final String NOTES = "notes";
    public static final String NUMBER = "number";
    public static final String OBJECT_CODE = "objectCode";
    public static final String OBJECT_CODE_CURRENT = "objectCodeCurrent";
    public static final String OBJECT_CODE_GLOBAL_DETAILS = "objectCodeGlobalDetails";
    public static final String OBJECT_ID = KRADPropertyConstants.OBJECT_ID;
    public static final String OBJECT_TYPE = "objectType";
    public static final String OBJECT_TYPE_CODE = "objectTypeCode";
    public static final String OFF_CAMPUS_CODE = "offCampusCode";
    public static final String OFFSET_BALANCE_SHEET_OBJECT_CODE_NUMBER = "offsetBalanceSheetObjectCodeNumber";
    public static final String OFFSET_TYPE_CODE = "offsetTypeCode";
    public static final String OJB_CONCRETE_CLASS = "ojbConcreteClass";
    public static final String OLD_BUSINESS_OBJECT_IN_DOCUMENT = "oldBusinessObjectInDocument";
    public static final String OLD_MAINTAINABLE_OBJECT = KRADPropertyConstants.OLD_MAINTAINABLE_OBJECT;
    public static final String ONE_DIGIT_TEXT_CODE = KRADPropertyConstants.ONE_DIGIT_TEXT_CODE;
    public static final String OPTION = "option";
    public static final String ORG = "org";
    public static final String ORG_CHECK_PAYABLE_TO_NAME = "orgCheckPayableToName";
    public static final String ORG_CREDIT_CARD_OPTION_INDICATOR = "orgCreditCardOptionIndicator";
    public static final String ORG_LATE_PAYMENT_CHARGE_AMT = "orgLatePaymentChargeAmt";
    public static final String ORG_REMIT_TO_ADDRESS_NAME = "orgRemitToAddressName";
    public static final String ORG_REMIT_TO_LINE1_STREET_ADDR = "orgRemitToLine1StreetAddr";
    public static final String ORG_REMIT_TO_LINE2_STREET_ADDR = "orgRemitToLine2StreetAddr";
    public static final String ORGANIZATION = "organization";
    public static final String ORGANIZATION_ACTIVE_INDICATOR = "active";
    public static final String ORGANIZATION_BEGIN_DATE = "organizationBeginDate";
    public static final String ORGANIZATION_CHART_OF_ACCOUNTS_CODE = "organizationChartOfAccountsCode";
    public static final String ORGANIZATION_CITY_NAME = "organizationCityName";
    public static final String ORGANIZATION_CODE = "organizationCode";
    public static final String ORGANIZATION_DEFAULT_ACCOUNT = "organizationDefaultAccount";
    public static final String ORGANIZATION_DEFAULT_ACCOUNT_NUMBER = "organizationDefaultAccountNumber";
    public static final String ORGANIZATION_DESCRIPTION = "organizationDescription";
    public static final String ORGANIZATION_DOCUMENT_NUMBER = "organizationDocumentNumber";
    public static final String ORGANIZATION_END_DATE = "organizationEndDate";
    public static final String ORGANIZATION_FAX_NUMBER = "organizationFaxNumber";
    public static final String ORGANIZATION_IN_FINANCIAL_PROCESSING_INDICATOR = "organizationInFinancialProcessingIndicator";
    public static final String ORGANIZATION_LATE_FEE_INDICATOR = "organizationLateFeeIndicator";
    public static final String ORGANIZATION_MANAGER_UNIVERSAL = "organizationManagerUniversal";
    public static final String ORGANIZATION_MANAGER_UNIVERSAL_ID = "organizationManagerUniversalId";
    public static final String ORGANIZATION_MESSAGE_TEXT = "organizationMessageText";
    public static final String ORGANIZATION_NAME = "organizationName";
    public static final String ORGANIZATION_PAYMENT_TERMS_TEXT = "organizationPaymentTermsText";
    public static final String ORGANIZATION_PHONE_NUMBER = "organizationPhoneNumber";
    public static final String ORGANIZATION_PHYSICAL_CAMPUS = "organizationPhysicalCampus";
    public static final String ORGANIZATION_PHYSICAL_CAMPUS_CODE = "organizationPhysicalCampusCode";
    public static final String ORGANIZATION_PLANT_ACCOUNT = "organizationPlantAccount";
    public static final String ORGANIZATION_PLANT_ACCOUNT_NUMBER = "organizationPlantAccountNumber";
    public static final String ORGANIZATION_PLANT_CHART = "organizationPlantChart";
    public static final String ORGANIZATION_PLANT_CHART_CODE = "organizationPlantChartCode";
    public static final String ORGANIZATION_REFERENCE_ID = "organizationReferenceId";
    public static final String ORGANIZATION_REMIT_TO_CITY_NAME = "organizationRemitToCityName";
    public static final String ORGANIZATION_REMIT_TO_STATE = "organizationRemitToState";
    public static final String ORGANIZATION_REMIT_TO_STATE_CODE = "organizationRemitToStateCode";
    public static final String ORGANIZATION_REMIT_TO_ZIP_CODE = "organizationRemitToZipCode";
    public static final String ORGANIZATION_STATE_CODE = "organizationStateCode";
    public static final String ORGANIZATION_TYPE = "organizationType";
    public static final String ORGANIZATION_TYPE_CODE = "organizationTypeCode";
    public static final String ORGANIZATION_TYPE_NAME = "organizationTypeName";
    public static final String ORGANIZATION_ZIP_CODE = "organizationZipCode";
    public static final String ORGANIZATION800_PHONE_NUMBER = "organization800PhoneNumber";
    public static final String ORIGIN_CODE = "originCode";
    public static final String ORIGIN_ENTRY_GROUP = "originEntryGroup";
    public static final String ORIGIN_ENTRY_GROUP_ID = "originEntryGroupId";
    public static final String ORIGINATION = "origination";
    public static final String OVERRIDE_CODE = "overrideCode";
    public static final String PAY_GROUP = "payGroup";
    public static final String PAY_PERIOD_END_DATE = "payPeriodEndDate";
    public static final String PAYEE = "payee";
    public static final String PAYEE_ACTIVE_CODE = "payeeActiveCode";
    public static final String PAYEE_ADDRESS_IDENTIFIER = "payeeAddressIdentifier";
    public static final String PAYEE_CITY_NAME = "payeeCityName";
    public static final String PAYEE_COUNTRY_CODE = "payeeCountryCode";
    public static final String PAYEE_EMPLOYEE_CODE = "payeeEmployeeCode";
    public static final String PAYEE_ENTRY_DATE = "payeeEntryDate";
    public static final String PAYEE_ID_NUMBER = "payeeIdNumber";
    public static final String PAYEE_LAST_PAID_DATE = "payeeLastPaidDate";
    public static final String PAYEE_LINE1_ADDR = "payeeLine1Addr";
    public static final String PAYEE_LINE2_ADDR = "payeeLine2Addr";
    public static final String PAYEE_OWNERSHIP_TYP = "payeeOwnershipTyp";
    public static final String PAYEE_OWNERSHIP_TYP_CD = "payeeOwnershipTypCd";
    public static final String PAYEE_PERSON_NAME = "payeePersonName";
    public static final String PAYEE_REVOLVING_FUND_CODE = "payeeRevolvingFundCode";
    public static final String PAYEE_STATE_CODE = "payeeStateCode";
    public static final String PAYEE_TAX_CODE = "payeeTaxCode";
    public static final String PAYEE_TAX_CONTROL = "payeeTaxControl";
    public static final String PAYEE_TAX_CONTROL_CODE = "payeeTaxControlCode";
    public static final String PAYEE_TAX_CTRL_MDFY_DT = "payeeTaxCtrlMdfyDt";
    public static final String PAYEE_TYPE_CODE = "payeeTypeCode";
    public static final String PAYEE_W9_COMPLETE_CODE = "payeeW9CompleteCode";
    public static final String PAYEE_ZIP_CODE = "payeeZipCode";
    public static final String PAYROLL_END_DATE_FISCAL_YEAR = "payrollEndDateFiscalYear";
    public static final String PENDING_ACCT_SUFFICIENT_FUNDS_INDICATOR = "pendingAcctSufficientFundsIndicator";
    public static final String PENDING_ENTRY_OPTION = "pendingEntryOption";
    public static final String PER_DIEM_COUNTRY_NAME = "perDiemCountryName";
    public static final String PER_DIEM_COUNTRY_TEXT = "perDiemCountryText";
    public static final String PER_DIEM_END_DATE_TIME = "perDiemEndDateTime";
    public static final String PER_DIEM_RATE = "perDiemRate";
    public static final String PER_DIEM_START_DATE_TIME = "perDiemStartDateTime";
    public static final String PERCENT = "accountLinePercent";
    public static final String PERIOD = "period";
    public static final String PERIOD_LIST_SIZE = "periodListSize";
    public static final String PERIODS = "periods";
    public static final String PERSON = "person";
    public static final String PERSON_ACTIVE_INDICATOR = "personActiveIndicator";
    public static final String PERSON_APPROVAL_CHART_OF_ACCT = "personApprovalChartOfAcct";
    public static final String PERSON_APPROVAL_CHART_OF_ACCT_CD = "personApprovalChartOfAcctCd";
    public static final String PERSON_APPROVAL_RC = "personApprovalRc";
    public static final String PERSON_APPROVAL_RC_CODE = "personApprovalRcCode";
    public static final String PERSON_BASE_SALARY_AMOUNT = KIMPropertyConstants.Person.BASE_SALARY_AMOUNT;
    public static final String PERSON_EMAIL_ADDRESS = KRADPropertyConstants.EMAIL_ADDRESS;
    public static final String PERSON_FIRST_NAME = KIMPropertyConstants.Person.FIRST_NAME;
    public static final String PERSON_FROM_LIST = "personFromList";
    public static final String PERSON_IN_FINANCIAL_PROCESS_CODE = "personInFinancialProcessCode";
    public static final String PERSON_LAST_NAME = KIMPropertyConstants.Person.LAST_NAME;
    public static final String PERSON_LOCAL_PHONE_NUMBER = KIMPropertyConstants.Person.PHONE_NUMBER;
    public static final String PERSON_NAME = KIMPropertyConstants.Person.NAME;
    public static final String PERSON_NAME_PREFIX_TEXT = "personNamePrefixText";
    public static final String PERSON_NAME_SUFFIX_TEXT = "personNameSuffixText";
    public static final String PERSON_ORIGINATION = "personOrigination";
    public static final String PERSON_ORIGINATION_CODE = "personOriginationCode";
    public static final String PERSON_PAYROLL_IDENTIFIER = "employeeId";
    public static final String PERSON_POST_DOCTORAL_INDICATOR = "personPostDoctoralIndicator";
    public static final String PERSON_PROJECT_DIRECTORY_INDICATOR = "personProjectDirectoryIndicator";
    public static final String PERSON_ROLE_SORT_NUMBER = "personRoleSortNumber";
    public static final String PERSON_SALARY_JUSTIFICATION_TEXT = "personSalaryJustificationText";
    public static final String PERSON_SECRETARIAL_CLERICAL_INDICATOR = "personSecretarialClericalIndicator";
    public static final String PERSON_SENIOR_KEY_INDICATOR = "personSeniorKeyIndicator";
    public static final String PERSON_SOCIAL_SECURITY_NBR_ID = "personSocialSecurityNbrId";
    public static final String PERSON_UNIVERSAL_IDENTIFIER = KIMPropertyConstants.Person.PRINCIPAL_ID;
    public static final String PERSON_UPDATE_ABILITY_CODE = "personUpdateAbilityCode";
    public static final String PERSON_UPDATE_ABILITY_NUMBER = "personUpdateAbilityNumber";
    public static final String PERSON_USER_ID = KIMPropertyConstants.Person.PRINCIPAL_NAME;
    public static final String PERSON_USER_IDENTIFIER = "principalName";
    public static final String PERSON_WEEKS_AMOUNT = "personWeeksAmount";
    public static final String PERSON_WEEKS_JUSTIFICATION_TEXT = "personWeeksJustificationText";
    public static final String PERSONNEL = "personnel";
    public static final String PERSONNEL_NEXT_SEQUENCE_NUMBER = "personnelNextSequenceNumber";
    public static final String PHONE_NUMBER = "phoneNumber";
    public static final String POSITION_NUMBER = "positionNumber";
    public static final String POSITION_OBJECT_GROUP_CODE = "positionObjectGroupCode";
    public static final String POSTAL_CITY_NAME = "cityName";
    public static final String POSTAL_COUNTRY_CODE = "postalCountryCode";
    public static final String POSTAL_COUNTRY_NAME = "postalCountryName";
    public static final String POSTAL_STATE_CODE = "stateCode";
    public static final String POSTAL_STATE_NAME = "postalStateName";
    public static final String POSTAL_ZIP = "postalZip";
    public static final String POSTAL_CODE = "postalCode";
    public static final String POSTING_PERIOD_CODE = "postingPeriodCode";
    public static final String POSTING_YEAR = "postingYear";
    public static final String PREPAID_EXPENSE = "prepaidExpense";
    public static final String PRIMARY_DEPARTMENT_CODE = "primaryDepartmentCode";
    public static final String PRIOR_YEAR_ACCOUNT = "priorYearAccount";
    public static final String PROCESS = "process";
    public static final String PROCESS_BATCH_SEQUENCE_NUMBER = "processBatchSequenceNumber";
    public static final String PROCESS_TOTAL_AMOUNT = "processTotalAmount";
    public static final String PROCESS_TOTAL_RECORD_COUNT = "processTotalRecordCount";
    public static final String PROCESS_TRANSMISSION_DATE = "processTransmissionDate";
    public static final String PROCESSED_DATE = "processedDate";
    public static final String PROCESSING_FIN_CHART_OF_ACCT = "processingFinChartOfAcct";
    public static final String PROCESSING_CHART_OF_ACCT_CD = "processingChartOfAccountCode";
    public static final String PROCESSING_FIN_CHART_OF_ACCT_CD = "processingFinChartOfAcctCd";
    public static final String PROCESSING_ORG = "processingOrg";
    public static final String PROCESSING_ORGANIZATION_CODE = "processingOrganizationCode";
    public static final String CONTACT_DEPARTMENT_NAME = "contactDepartmentName";
    public static final String CONTACT_MAILING_ADDRESS = "contactMailingAddress";
    public static final String CONTACT_PERSON_PHONE_NUMBER = "contactPersonPhoneNumber";
    public static final String PROCUREMENT_CARD_HOLDER_LINE1_ADDRESS = "cardHolderLine1Address";
    public static final String PROCUREMENT_CARD_HOLDER_LINE2_ADDRESS = "cardHolderLine2Address";
    public static final String PROCUREMENT_CARD_HOLDER_CITY_NAME = "cardHolderCityName";
    public static final String PROCUREMENT_CARD_HOLDER_STATE = "cardHolderStateCode";
    public static final String PROCUREMENT_CARD_HOLDER_ZIP_CODE = "cardHolderZipCode";
    public static final String PROCUREMENT_CARD_HOLDER_WORK_PHONE_NUMBER = "cardHolderWorkPhoneNumber";
    public static final String PROCUREMENT_CARD_LIMIT = "cardLimit";
    public static final String PROCUREMENT_CARD_CYCLE_AMOUNT_LIMIT = "cardCycleAmountLimit";
    public static final String PROCUREMENT_CARD_CYCLE_VOLUME_LIMIT = "cardCycleVolumeLimit";
    public static final String PROCUREMENT_CARD_STATUS_CODE = "cardStatusCode";
    public static final String PROCUREMENT_CARD_NOTE_TEXT = "cardNoteText";
    public static final String PROJECT = "project";
    public static final String PROJECT_CODE = "projectCode";
    public static final String PROJECT_DESCRIPTION = "projectDescription";
    public static final String PROJECT_DIRECTOR = "projectDirector";
    public static final String PROJECT_DIRECTORY_TO_BE_NAMED_INDICATOR = "projectDirectoryToBeNamedIndicator";
    public static final String PROJECT_MANAGER_UNIVERSAL = "projectManagerUniversal";
    public static final String PROJECT_MANAGER_UNIVERSAL_ID = "projectManagerUniversalId";
    public static final String PROPERTY_NAME = "propertyName";
    public static final String PROPERTY_LABEL = "propertyLabel";
    public static final String BUSINESS_OBJECT_PROPERTY_LABEL = "businessObjectProperty." + KFSPropertyConstants.PROPERTY_LABEL;
    public static final String FUNCTIONAL_FIELD_DESCRIPTION_BUSINESS_OBJECT_PROPERTY_LABEL = "functionalFieldDescription." + BUSINESS_OBJECT_PROPERTY_LABEL;
    public static final String PROPOSAL = "proposal";
    public static final String PROPOSAL_ENDING_DATE = "proposalEndingDate";
    public static final String PROPOSAL_FEDERAL_PASS_THROUGH_INDICATOR = "proposalFederalPassThroughIndicator";
    public static final String PROPOSAL_NUMBER = "proposalNumber";
    public static final String PROPOSAL_ORGANIZATIONS = "proposalOrganizations";
    public static final String PROPOSAL_PROJECT_DIRECTORS = "proposalProjectDirectors";
    public static final String PROPOSAL_SUBCONTRACTORS = "proposalSubcontractors";
    public static final String REFERENCE_DOCUMENT_NUMBER = "referenceDocumentNumber";
    public static final String REFERENCE_DOCUMENT_TYPE = "referenceDocumentType";
    public static final String REFERENCE_FIN_DOCUMENT_TYPE_CODE = "referenceFinancialDocumentTypeCode";
    public static final String REFERENCE_FINANCIAL_DOCUMENT_NUMBER = "referenceFinancialDocumentNumber";
    public static final String REFERENCE_FINANCIAL_DOCUMENT_TYPE_CODE = "referenceFinancialDocumentTypeCode";
    public static final String REFERENCE_FINANCIAL_SYSTEM_ORIGINATION_CODE = "referenceFinancialSystemOriginationCode";
    public static final String REFERENCE_NUMBER = "referenceNumber";
    public static final String REFERENCE_ORIGIN = "referenceOrigin";
    public static final String REFERENCE_ORIGIN_CODE = "referenceOriginCode";
    public static final String REFERENCE_TYPE = "referenceType";
    public static final String REFERENCE_TYPE_CODE = "referenceTypeCode";
    public static final String REQUEST_SEARCH_RESULTS_ACTUAL_SIZE = "reqSearchResultsActualSize";
    public static final String REPORTING_CODE = "reportingCode";
    public static final String REPORTING_NAME = "reportingName";
    public static final String REPORTS_TO_ACCOUNT = "reportsToAccount";
    public static final String REPORTS_TO_ACCOUNT_NUMBER = "reportsToAccountNumber";
    public static final String REPORTS_TO_AGENCY = "reportsToAgency";
    public static final String REPORTS_TO_AGENCY_NUMBER = "reportsToAgencyNumber";
    public static final String REPORTS_TO_CHART_OF_ACCOUNTS = "reportsToChartOfAccounts";
    public static final String REPORTS_TO_CHART_OF_ACCOUNTS_CODE = "reportsToChartOfAccountsCode";
    public static final String REPORTS_TO_FINANCIAL_OBJECT = "reportsToFinancialObject";
    public static final String REPORTS_TO_FINANCIAL_OBJECT_CODE = "reportsToFinancialObjectCode";
    public static final String REPORTS_TO_ORGANIZATION = "reportsToOrganization";
    public static final String REPORTS_TO_ORGANIZATION_CODE = "reportsToOrganizationCode";
    public static final String RESEARCH_RISK_TYPE_DESCRIPTION = "researchRiskTypeDescription";
    public static final String RESPONSIBILITY_CENTER = "responsibilityCenter";
    public static final String RESPONSIBILITY_CENTER_CODE = "responsibilityCenterCode";
    public static final String RESPONSIBILITY_CENTER_DESCRIPTION = "responsibilityCenterDescription";
    public static final String REVERSAL_DATE = "reversalDate";
    public static final String ROLE = "role";
    public static final String ROUTE_SHEET_TRACK_NUMBER = "routeSheetTrackNumber";
    public static final String ROUTING_FORM_SUBMISSION_DETAILS = "routingFormMainPageSubmissionDetails";
    public static final String ROW_COUNT = "rowCount";
    public static final String SCRUB = "scrub";
    public static final String SELECT_FLAG = "selectFlag";
    public static final String SELECTED_ACCOUNTING_PERIOD = "selectedAccountingPeriod";
    public static final String SELECTED_BALANCE_TYPE = "selectedBalanceType";
    public static final String SELECTED_ORGANIZATION_CHART_OF_ACCOUNTS_CODE = "selectedOrganizationChartOfAccountsCode";
    public static final String SELECTED_ORGANIZATION_CODE = "selectedOrganizationCode";
    public static final String SEQUENCE_ID = "sequenceId";
    public static final String SEQUENCE_NUMBER = "sequenceNumber";
    public static final String SORT_NUMBER = "sortNumber";
    public static final String SOURCE_ACCOUNTING_LINE = "sourceAccountingLine";
    public static final String SOURCE_ACCOUNTING_LINES = "sourceAccountingLines";
    public static final String SOURCE_ACCOUNTING_LINES_SECTION_TITLE = "sourceAccountingLinesSectionTitle";
    public static final String SOURCE_CODE = "sourceCode";
    public static final String SOURCE_OF_FUNDS_TYPE_CODE = "sourceOfFundsTypeCode";
    public static final String SOURCE_TOTAL = "sourceTotal";
    public static final String SPSI_USER = "spsiUser";
    public static final String STATE = "state";
    public static final String STATE_CODE = "stateCode";
    public static final String STATE_INCOME_TAX_PERCENT = "stateIncomeTaxPercent";
    public static final String STOP_WORK_REASON = "stopWorkReason";
    public static final String SUB_ACCOUNT = "subAccount";
    public static final String SUB_ACCOUNT_ACTIVE_INDICATOR = "active";
    public static final String SUB_ACCOUNT_NAME = "subAccountName";
    public static final String SUB_ACCOUNT_NUMBER = "subAccountNumber";
    public static final String SUB_ACCOUNT_TYPE_CODE = "subAccountTypeCode";
    public static final String SUB_ACCOUNTS = "subAccounts";
    public static final String SUB_FUND_GROUP = "subFundGroup";
    public static final String SUB_FUND_GROUP_CODE = "subFundGroupCode";
    public static final String SUB_FUND_GROUP_DESCRIPTION = "subFundGroupDescription";
    public static final String SUB_FUND_GROUP_TYPE_CODE = "subFundGroupTypeCode";
    public static final String SUB_FUND_GROUP_WAGES_INDICATOR = "subFundGroupWagesIndicator";
    public static final String SUB_FUND_SORT_CODE = "subFundSortCode";
    public static final String SUB_OBJ_CODE_CHANGE_DETAILS = "subObjCdGlobalDetails";
    public static final String SUB_OBJECT_CODE = "subObjectCode";
    public static final String SUBCONTRACTOR_NUMBER = "subcontractorNumber";
    public static final String SUBFUNDGRP_ACTIVITY_INDICATOR = "subfundgrpActivityIndicator";
    public static final String SUFFICIENT_FUNDS_CODE = "sufficientFundsCode";
    public static final String SUFFICIENT_FUNDS_OBJECT_CODE = "sufficientFundsObjectCode";
    public static final String SUPERVISOR_USER = "supervisorUser";
    public static final String EXCLUDED_FROM_INVOICING_REASON = "excludedFromInvoicingReason";
    public static final String TABLE_NAME = "tableName";
    public static final String TARGET_ACCOUNTING_LINE = "targetAccountingLine";
    public static final String TARGET_ACCOUNTING_LINES = "targetAccountingLines";
    public static final String TARGET_ACCOUNTING_LINES_SECTION_TITLE = "targetAccountingLinesSectionTitle";
    public static final String TARGET_TOTAL = "targetTotal";
    public static final String TASK = "task";
    public static final String TASK_LIST_SIZE = "taskListSize";
    public static final String TASKS = "tasks";
    public static final String TAX_ID_NUMBER = "taxIdNumber";
    public static final String TAXPAYER_CITY_NAME = "taxpayerCityName";
    public static final String TAXPAYER_COUNTRY_NAME = "taxpayerCountryName";
    public static final String TAXPAYER_LINE1_ADDR = "taxpayerLine1Addr";
    public static final String TAXPAYER_LINE2_ADDR = "taxpayerLine2Addr";
    public static final String TAXPAYER_STATE_CODE = "taxpayerStateCode";
    public static final String TAXPAYER_TYPE_CODE = "taxpayerTypeCode";
    public static final String TAXPAYER_ZIP_CODE = "taxpayerZipCode";
    public static final String TIMESTAMP = "timestamp";
    public static final String TOTAL = "total";
    public static final String TOTAL_ACTUAL_DIRECT_COST_AMOUNT = "totalActualDirectCostAmount";
    public static final String TOTAL_AMOUNT = "totalAmount";
    public static final String CONFIRMED = "confirmed";
    public static final String CURRENCY = "currency";
    public static final String COIN = "coin";
    public static final String CHANGE_CURRENCY = "changeCurrency";
    public static final String CHANGE_COIN = "changeCoin";
    public static final String DETAIL_PREFIX = "Detail.";
    public static final String TOTAL_DIRECT_COST_AMOUNT = "totalDirectCostAmount";
    public static final String TOTAL_DOLLAR_AMOUNT = "totalDollarAmount";
    public static final String TOTAL_EXPENSE_AMOUNT = "totalExpenseAmount";
    public static final String TOTAL_FRINGE_AMOUNT = "totalFringeAmount";
    public static final String TOTAL_MODULAR_DIRECT_COST_AMOUNT = "totalModularDirectCostAmount";
    public static final String TOTAL_PERCENT_EFFORT = "totalPercentEffort";
    public static final String TOTAL_PRE_PAID_AMOUNT = "totalPrePaidAmount";
    public static final String TOTAL_RECORDS = "totalRecords";
    public static final String TOTAL_SALARY_AMOUNT = "totalSalaryAmount";
    public static final String TOTAL_TRAVEL_AMOUNT = "totalTravelAmount";
    public static final String TRAILER_RECORD_FIRST_EMPTY_FIELD = "firstEmptyField";
    public static final String TRAILER_RECORD_SECOND_EMPTY_FIELD = "secondEmptyField";
    public static final String TRANSACTION = "transaction";
    public static final String TRANSACTION_CREDIT_CARD_NUMBER = "transactionCreditCardNumber";
    public static final String TRANSACTION_DATE = "transactionDate";
    public static final String TRANSACTION_DATE_TIME_STAMP = "transactionDateTimeStamp";
    public static final String TRANSACTION_DEBIT_CREDIT_CODE = "transactionDebitCreditCode";
    public static final String TRANSACTION_DEBIT_INDICATOR = "transactionDebitIndicator";
    public static final String TRANSACTION_ENCUMBRANCE_DATE = "transactionEncumbranceDate";
    public static final String TRANSACTION_ENCUMBRANCE_DESCRIPTION = "transactionEncumbranceDescription";
    public static final String TRANSACTION_ENCUMBRANCE_UPDT_CD = "transactionEncumbranceUpdateCode";
    public static final String TRANSACTION_ENTRIES = "transactionEntries";
    public static final String TRANSACTION_ENTRY_OFFSET_INDICATOR = "transactionEntryOffsetIndicator";
    public static final String TRANSACTION_ENTRY_PROCESSED_TIMESTAMP = "transactionEntryProcessedTimestamp";
    public static final String TRANSACTION_ENTRY_PROCESSED_TS = "transactionEntryProcessedTs";
    public static final String TRANSACTION_ENTRY_SEQUENCE_ID = "transactionEntrySequenceId";
    public static final String TRANSACTION_ENTRY_SEQUENCE_NUMBER = "transactionLedgerEntrySequenceNumber";
    public static final String TRANSACTION_LEDGER_ENTRY_AMOUNT = "transactionLedgerEntryAmount";
    public static final String TRANSACTION_LEDGER_ENTRY_DESC = "transactionLedgerEntryDescription";
    public static final String TRANSACTION_POSTING_DATE = "transactionPostingDate";
    public static final String TRANSACTION_TOTAL_HOURS = "transactionTotalHours";
    public static final String TRANSMISSION_DATE = "transmissionDate";
    public static final String CREDIT_CARD_NUMBER = "creditCardNumber";
    public static final String TRN_ENTRY_LEDGER_SEQUENCE_NUMBER = "transactionLedgerEntrySequenceNumber";
    public static final String TWO_DIGIT_TEXT_CODE = KRADPropertyConstants.TWO_DIGIT_TEXT_CODE;
    public static final String TYPE = KRADPropertyConstants.TYPE;
    public static final String TYPE_CODE = "typeCode";
    public static final String TYPE_FINANCIAL_REPORT_SORT_CODE = "typeFinancialReportSortCode";
    public static final String UNIT_OF_MEASURE_CODE = "unitOfMeasureCode";
    public static final String UNIVERSAL_IDENTIFIER = "universalIdentifier";
    public static final String UNIVERSAL_USER = KRADPropertyConstants.UNIVERSAL_USER;
    public static final String UNIVERSITY_ACCOUNT = "universityAccount";
    public static final String UNIVERSITY_ACCOUNT_NUMBER = "universityAccountNumber";
    public static final String UNIVERSITY_ACCT_CHART_OF_ACCT = "universityAcctChartOfAcct";
    public static final String UNIVERSITY_ACCT_CHART_OF_ACCT_CD = "universityAcctChartOfAcctCd";
    public static final String UNIVERSITY_APPOINTMENT_TYPE_CODE = "universityAppointmentTypeCode";
    public static final String UNIVERSITY_COST_SHARE_FRINGE_BENEFIT_TOTAL_AMOUNT = "universityCostShareFringeBenefitTotalAmount";
    public static final String UNIVERSITY_COST_SHARE_FRINGE_BENEFIT_TOTAL_AMOUNT_TASK = "universityCostShareFringeBenefitTotalAmountTask";
    public static final String UNIVERSITY_COST_SHARE_FRINGE_RATE_AMOUNT = "universityCostShareFringeRateAmount";
    public static final String UNIVERSITY_COST_SHARE_INDICATOR = "universityCostShareIndicator";
    public static final String UNIVERSITY_COST_SHARE_ITEMS = "universityCostShareItems";
    public static final String UNIVERSITY_COST_SHARE_PERCENT_EFFORT_AMOUNT = "universityCostSharePercentEffortAmount";
    public static final String UNIVERSITY_COST_SHARE_REQUEST_TOTAL_AMOUNT = "universityCostShareRequestTotalAmount";
    public static final String UNIVERSITY_COST_SHARE_REQUEST_TOTAL_AMOUNT_TASK = "universityCostShareRequestTotalAmountTask";
    public static final String UNIVERSITY_DATE = "universityDate";
    public static final String UNIVERSITY_FISCAL = "universityFiscal";
    public static final String UNIVERSITY_FISCAL_ACCOUNTING_PERIOD = "universityFiscalAccountingPeriod";
    public static final String UNIVERSITY_FISCAL_PERIOD_CODE = "universityFiscalPeriodCode";
    public static final String UNIVERSITY_FISCAL_PERIOD_END_DATE = "universityFiscalPeriodEndDate";
    public static final String UNIVERSITY_FISCAL_PERIOD_NAME = "universityFiscalPeriodName";
    public static final String UNIVERSITY_FISCAL_PERIOD_STATUS_CODE = "active";
    public static final String UNIVERSITY_FISCAL_YEAR = "universityFiscalYear";
    public static final String UNIVERSITY_NAME = "universityName";
    public static final String USER = "user";
    public static final String USER_AGENCY_HOURS = "userAgencyHours";
    public static final String USER_APPOINTMENT_TASK = "userAppointmentTask";
    public static final String USER_APPOINTMENT_TASK_PERIOD = "userAppointmentTaskPeriod";
    public static final String USER_APPOINTMENT_TASK_PERIODS = "userAppointmentTaskPeriods";
    public static final String USER_APPOINTMENT_TASKS = "userAppointmentTasks";
    public static final String USER_BUDGET_PERIOD_SALARY_AMOUNT = "userBudgetPeriodSalaryAmount";
    public static final String USER_HOURLY_RATE = "userHourlyRate";
    public static final String USER_SEQUENCE_NUMBER = "userSequenceNumber";
    public static final String USER_SORT_NUMBER = "userSortNumber";
    public static final String USER_UNIVERSITY_HOURS = "userUniversityHours";
    public static final String UU_ID = KRADPropertyConstants.UU_ID;
    public static final String VALID = "valid";
    public static final String VALUE = KRADPropertyConstants.VALUE;
    public static final String VENDOR = "vendor";
    public static final String VENDOR_ADDRESS_GENERATED_ID = "vendorAddressGeneratedIdentifier";
    public static final String VENDOR_CITY_NAME = "vendorCityName";
    public static final String VENDOR_COUNTRY_CODE = "vendorCountryCode";
    public static final String VENDOR_DETAIL_ASSIGNED_ID = "vendorDetailAssignedIdentifier";
    public static final String VENDOR_HEADER_GENERATED_ID = "vendorHeaderGeneratedIdentifier";
    public static final String VENDOR_LINE_1_ADDRESS = "vendorLine1Address";
    public static final String VENDOR_LINE_2_ADDRESS = "vendorLine1Address";
    public static final String VENDOR_STATE_CODE = "vendorStateCode";
    public static final String VENDOR_ZIP_CODE = "vendorZipCode";
    public static final String VERSION_NUMBER = KRADPropertyConstants.VERSION_NUMBER;
    public static final String WORKFLOW_CREATE_DATE = "workflowCreateDate";
    public static final String WORKFLOW_DOCUMENT = KRADPropertyConstants.WORKFLOW_DOCUMENT;
    public static final String WORKFLOW_SEARCH_RESULT_KEY = "routeHeaderId";
    public static final String WORKFLOW_DOCUMENT_STATUS_CODE = "workflowDocumentStatusCode";
    public static final String WORKFLOW_DOCUMENT_TYPE_NAME = "workflowDocumentTypeName";
    public static final String XML_DOCUMENT_CONTENTS = KRADPropertyConstants.XML_DOCUMENT_CONTENTS;
    public static final String ZIP_CODE = "zipCode";
    public static final String ZIPCODE = "zipcode"; // yeah, this is sadly for reals...
    public static final String CASH_CONTROL_DETAIL = "cashControlDetail";
    public static final String CASH_CONTROL_DETAILS = "cashControlDetails";
    public static final String BANK_CODE = "bankCode";
    public static final String CAPITAL_ASSET_MANAGEMENT_ASSET = "capitalAssetManagementAsset";
    public static final String VENDOR_NUMBER = "vendorNumber";
    public static final String CAPITAL_ASSET_MANAGEMENT_ASSET_TYPE = "capitalAssetManagementAssetType";
    public static final String POSTAL_COUNTRY_RESTRICTED_INDICATOR = "postalCountryRestrictedIndicator";
    public static final String CAPITAL_ASSET_INFORMATION = "capitalAssetInformation";
    public static final String CAPITAL_ASSET_MODIFY_INFORMATION = "capitalAssetModify";

    public static final String CAPITAL_ACCOUNTING_LINES = "capitalAccountingLines";
    public static final String CAPITAL_ASSET_INFORMATION_DETAILS = "capitalAssetInformationDetails";
    public static final String CLOSED = "closed";
    public static final String ITEM_LINE_NUMBER = "itemLineNumber";
    public static final String CAPITAL_ASSET_LINE_NUMBER = "capitalAssetLineNumber";
    public static final String CAPITAL_ASSET_ACTION_INDICATOR = "capitalAssetActionIndicator";
    public static final String CAPITAL_ASSET_ACCOUNT_LINE_NUMBER = "capitalAssetAccountLineNumber";
    public static final String VENDOR_NAME = "vendorName";
    public static final String PAYEE_NAME = "payeeName";
    public static final String VENDOR_ADDRESSES = "vendorAddresses";
    public static final String PAYMENT_REASON_CODE = "paymentReasonCode";
    public static final String TAX_NUMBER = "taxNumber";
    public static final String VENDOR_TYPE_CODE = "vendorTypeCode";
    public static final String PRINCIPAL_ID = "principalId";
    public static final String ELECTRONIC_PAYMENT_CLAIMS = "electronicPaymentClaims";
    public static final String ITEM_UNIT_OF_MEASURE_DESCRIPTION = "itemUnitOfMeasureDescription";
    public static final String ITEM_UNIT_OF_MEASURE_CODE = "itemUnitOfMeasureCode";
    public static final String PURAP_DOC_ID = "purapDocumentIdentifier";
    public static final String PURCHASE_ORDER_DOCUMENT_SIMPLE_NAME = "PurchaseOrderDocument";
    public static final String CAPITAL_ASSET_LINE_AMOUNT = "capitalAssetLineAmount";
    public static final String APPLICATION_DOCUMENT_STATUS = "applicationDocumentStatus";
    public static final String SALES_TAX = "salesTax";
    public static final String INVOICE_TEMPLATE_CODE = "invoiceTemplateCode";
    public static final String MEMORY_MONITOR_THRESHOLD_KEY = "memory.monitor.threshold";
    public static final String USE_QUARTZ_SCHEDULING_KEY = "use.quartz.scheduling";
    public static final String DIRECTORIES_TO_CREATE_PATH = "directoriesToCreateOnStartup";
    public static final String UPDATE_DATABASE_ON_STARTUP = "updateDatabaseOnStartup";
    public static final String UPDATE_DOCUMENTSTORE_ON_STARTUP = "updateDocumentstoreOnStartup";
    public static final String UPDATE_DOCUMENTSTORE_FILE_PATH = "updateDocumentstoreFilePath";
    public static final String UPDATE_WORKFLOW_ON_STARTUP = "updateWorkflowOnStartup";

    public static final String HAS_DOCUMENTATION = "hasDocumentation";
    public static final String CHOSEN_ELECTRONIC_PAYMENT_CLAIMING_DOCUMENT_CODE = "chosenElectronicPaymentClaimingDocumentCode";
    public static final String CLAIMS = "claims";
    public static final String PAYMENT_CLAIM_STATUS_CODE = "paymentClaimStatusCode";
    public static final String RANGE_LOWER_BOUND_KEY_PREFIX = "rangeLowerBoundKeyPrefix_";
    public static final String GENERATING_ACCOUNTING_LINE = "generatingAccountingLine";
    public static final String GENERATING_ADVANCE_DEPOSIT_DETAIL = "generatingAdvanceDepositDetail";
    public static final String FINANCIAL_DOCUMENT_ADVANCE_DEPOSIT_DATE = "financialDocumentAdvanceDepositDate";
    public static final String PAYMENT_CLAIM_AMOUNT_FROM = "amountFrom";
    public static final String PAYMENT_CLAIM_AMOUNT_TO = "amountTo";
    public static final String ADVANCE_DEPOSITS = "advanceDeposits";
    public static final String LINK_GROUPS = "linkGroups";
    public static final String MENU = "menu";
    public static final String LOGO_URL = "logoUrl";
    public static final String PERMISSION = "permission";
    public static final String ACTION_LIST_URL = "actionListUrl";
    public static final String SIGNOUT_URL = "signoutUrl";
    public static final String DOC_SEARCH_URL = "docSearchUrl";
    public static final String REMOTE_VIEW_URL = "remoteViewUrl";
    public static final String VERSIONS = "versions";
    public static final String LABEL = "label";
    public static final String LINK = "link";
    public static final String LINKS = "links";
    public static final String BUSINESS_OBJECT_CLASS = "businessObjectClass";
    public static final String LINK_TYPE = "linkType";
    public static final String TEMPLATE_NAMESPACE = "templateNamespace";
    public static final String TEMPLATE_NAME = "templateName";
    public static final String DETAILS = "details";
    public static final String INSTITUTION_ID = "institutionId";
    public static final String SIDEBAR_OUT = "sidebarOut";
    public static final String CHECKED_LINK_FILTERS = "checkedLinkFilters";

    public static class SubAccountImport {
        public static final String CHART_OF_ACCOUNTS_CODE = "chartOfAccountsCode";
        public static final String ACCOUNT_NUMBER = "accountNumber";
        public static final String SUB_ACCOUNT_NUMBER = "subAccountNumber";
        public static final String SUB_ACCOUNT_NAME = "subAccountName";
        public static final String ACTIVE = "active";
        public static final String FINANCIAL_REPORT_CHART_CODE = "financialReportChartCode";
        public static final String FIN_REPORT_ORGANIZATION_CODE = "finReportOrganizationCode";
        public static final String FINANCIAL_REPORTING_CODE = "financialReportingCode";
        public static final String SUB_ACCOUNT_IMPORT_DETAILS = "subAccountImportDetails";

    }

    public static class SubObjectCodeImport {
        public static final String UNIVERSITY_FISCAL_YEAR = "universityFiscalYear";
        public static final String CHART_OF_ACCOUNTS_CODE = "chartOfAccountsCode";
        public static final String ACCOUNT_NUMBER = "accountNumber";
        public static final String FIN_OBJECT_CODE = "financialObjectCode";
        public static final String ACTIVE = "active";
        public static final String FIN_SUB_OBJECT_CODE = "financialSubObjectCode";
        public static final String FIN_SUB_OBJECT_CODE_NAME = "financialSubObjectCodeName";
        public static final String FIN_SUB_OBJECT_CODE_SHORT_NAME = "financialSubObjectCdshortNm";
        public static final String SUB_OBJECT_CODE_IMPORT_DETAILS = "subObjectCodeImportDetails";

    }

    // ASR 2590 mass upload project code
    public static class ProjectCodeImport {
        public static final String PROJECT_CODE = "projectCode";
        public static final String CHART_OF_ACCOUNTS_CODE = "chartOfAccountsCode";
        public static final String PROJECT_NAME = "projectName";
        public static final String PROJECT_DESCRIPTION = "projectDescription";
        public static final String ACTIVE = "active";
        public static final String ORGANIZATION_CODE = "organizationCode";
        public static final String PROJECT_MANAGER_UNIVERSAL_ID = "projectManagerUniversalId";
        public static final String PROJECT_MANAGER_PRINCIPAL_NAME = "projectManagerPrincipalName";
        public static final String PROJECT_CODE_IMPORT_DETAILS = "projectCodeImportDetails";
    }
}
