/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2016 The Kuali Foundation
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.vnd;


/**
 * Holds constants for Vendor business parameters.
 */
public class VendorParameterConstants {
    public static final String DEFAULT_TAX_NUMBER_DIGITS = "DEFAULT_TAX_NUMBER_DIGITS";
    public static final String NOT_ALLOWED_TAX_NUMBERS = "TAX_NUMBERS";
    public static final String TAX_FEIN_NUMBER_FORMATS = "TAX_FEIN_NUMBER_FORMATS";
    public static final String TAX_SSN_NUMBER_FORMATS = "TAX_SSN_NUMBER_FORMATS";
    public static final String GIIN_NUMBER_FORMAT = "GIIN_NUMBER_FORMAT";
    public static final String PAYMENT_TERMS_DUE_TYPE_DESC = "PAYMENT_TERMS_DUE_TYPE_DESC";
    public static final String VENDOR_MIN_ORDER_AMOUNT = "MIN_ORDER_AMOUNT";
    public static final String SSN_ALLOWED_OWNERSHIP_TYPES = "SSN_OWNERSHIP_TYPES";
    public static final String FEIN_ALLOWED_OWNERSHIP_TYPES = "FEIN_OWNERSHIP_TYPES";
    public static final String PHONE_NUMBER_FORMATS = "GENERIC_PHONE_NUMBER_FORMATS";
    public static final String DEFAULT_PHONE_NUMBER_DIGITS = "GENERIC_DEFAULT_PHONE_NUMBER_LENGTH";
    public static final String OVERRIDE_VENDOR_DOC_TITLE = "OVERRIDE_DOCUMENT_TITLE_IND";
    public static final String EXCLUSION_AND_DEBARRED_VENDOR_TYPES = "EXCLUSION_AND_DEBARRED_VENDOR_TYPES";
    public static final String W8_DATA_REQUIRED_IND = "W8_DATA_REQUIRED_IND";
    public static final String W9_SIGNED_DATE_REQUIRED = "W9_SIGNED_DATE_REQUIRED_IND";

}
